/*-------------------------------------------------------------------

** %PS

**

** IBM Confidential

**

** Licensed Internal Code Source Materials

**

** 2105 Licensed Internal Code

**

** (C) Copyright IBM Corp. 2002

**

** The source code for this program is not published or otherwise

** divested of its trade secrets, irrespective of what has been

** deposited with the U.S. Copyright Office.

** %EPS

**     

**-------------------------------------------------------------------
*/

/**

 * <P><CODE>requestor.js</CODE> handles the user requests and forwards these to proper
 * places.
 * </P>

 */

/** Find the controller and call showHelp or setHelp function for given plugin and topic.

 * @param plugin 	The help document plugin.

 * @param topic		The topic to display.

 */

function setHelp( plugin, topic ) {

  var controller = findHelpController();

  if ( controller ) {

    if ( isHelpControllerRemote() )

      controller.showHelp( plugin, topic );

    else

      controller.setHelp( plugin, topic );

  }

}



/** Call setTopic function of controller.

 * @param topic 	The help topic to disply.

 */

function setHelpTopic( topic ) {

  var controller = findHelpController();

  if ( controller ) {

    if ( isHelpControllerRemote() )

      controller.showTopic( topic );

    else

      controller.setTopic( topic );

  }

}



/** Find the controller and call showHelp function for given plugin and topic.

 * @param plugin 	The help document plugin.

 * @param topic		The topic to display.

 */

function showHelp( plugin, topic ) {

  var controller = findHelpController();

  if ( controller )

    controller.showHelp( plugin, topic );

}



/** Call showTopic function of controller.

 * @param topic 	The help topic to disply.

 */

function showHelpTopic( topic ) {

  var controller = findHelpController();

  if ( controller )

    controller.showTopic( topic );

}



/** Find the controller and call viewHelp function for given plugin and topic.

 * @param plugin 	The help document plugin.

 * @param topic		The topic to display.

 */

function viewHelp( plugin, topic ) {

  var controller = findHelpController();

  if ( controller )

    controller.viewHelp( plugin, topic );

}



/** Call viewHelpTopic function of controller.

 *  @param topic 	The help topic to disply.

 */

function viewHelpTopic( topic ) {

  var controller = findHelpController();

  if ( controller )

    controller.viewHelpTopic( topic );

}



/** Find the controller and call viewHelp function for given plugin and topic.

 *  @param plugin 	The help document plugin.

 *  @param topic	The topic to display.

 */

function viewHref( plugin, topic ) {

  var controller = findHelpController();

  if ( controller )

    controller.viewHelp( plugin, topic );

}

/** Call viewHelpTopic function of controller.

 *  @param topic 	The help topic to disply.

 */

function viewHrefTopic( topic ) {

  var controller=findHelpController();

  if ( controller )

    controller.viewHelpTopic( topic );

}

