/*
 * @(#)src/j9classes/com/ibm/jvm/ExtendedSystem.java, asdev, as1420, 20040618 1.3.1.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2002, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

package com.ibm.jvm;


import java.lang.reflect.Array;
import java.util.jar.Attributes;
import java.util.Comparator;

public class ExtendedSystem {
	public static final Attributes.Name EXTENSION_COMPATIBLE = new Attributes.Name("IBM-Reusable-JVM-Compatible");

	public static final int SCJVM_MODIFYING_STATIC = 0x00020001;
	public static final int SCJVM_AWT = 0x00020002;
	public static final int SCJVM_MODIFYING_SECURITY = 0x00020003;
	public static final int SCJVM_SETTING_CLASSLOADER_OR_SECURITY_MANAGER =
                                                                     0x00020004;
	public static final int SCJVM_USING_REFLECTION = 0x00020005;
	public static final int SCJVM_PROPERTIES = 0x00020006;
	public static final int SCJVM_REDIRECTING_IO = 0x00020007;
	public static final int SCJVM_CLOSING_IO = 0x00020008;
	public static final int SCJVM_THREADS = 0x00020009;
	public static final int SCJVM_JNI = 0x0002000A;
	public static final int SCJVM_CREATING_PROCESS = 0x0002000B;

	public static final int SCJVM_TIDYUP_FAILED = 0x0001000C;
	public static final int SCJVM_APPLICATION_OBJECT_REACHABLE_FROM_STATIC = 0x0001000D;
	public static final int SCJVM_REF_FROM_MW_TO_TH = 0x0001000E;
	public static final int SCJVM_MW_STATIC_VARIABLE_IN_TH = 0x0001000F;
	public static final int SCJVM_JNI_GLOBAL_REFERENCE_IN_TH = 0x00010010;
	public static final int SCJVM_PINNED_OBJECT_FOUND_DURING_RESET = 0x00010011;     /*ibm@15565*/
	public static final int SCJVM_TRANSIENT_HEAP_TOO_SMALL = 0x00010012;             /*ibm@14365*/
	public static final int SCJVM_MIDDLEWARE_RETAINING_APPLICATION_CLASSLOADER = 0x00010013;
	public static final int SCJVM_LOADING_UNCHECKED_EXTENSION = 0x00010014; /*ibm@5654*/
	public static final int SCJVM_IN_DEBUG_MODE = 0x00010015;
	public static final int SCJVM_MULTIPLE_THREADS_AT_RESET = 0x00010016;
	public static final int SCJVM_REINITIALIZE_FAILED = 0x00010017;
	public static final int SCJVM_JVM_INTERNAL_ERROR = 0x00010018;
	public static final int SCJVM_REF_TO_SHAREABLE_APPLICATION_CLASS = 0x00010019;
	public static final int SCJVM_REF_TO_NONSHAREABLE_APPLICATION_CLASS = 0x0001001A;/*ibm@5723*/
	public static final int SCJVM_SECURITYMANAGER_NOT_PRIMORDIAL_OR_MIDDLEWARE = 0x0001001B; /*ibm@11752*/
	public static final int SCJVM_PROMOTION_OUT_OF_MEMORY = 0x0001001C;              /*ibm@5723*/
	public static final int SCJVM_OUTSTANDING_JAVA_EXCEPTION = 0x0001001D; /*ibm@23364*/
	public static final int SCJVM_TH_OR_ACSH_POINTER_FROM_LAUNCHER   = 0x0001001E;   /*ibm@5724*/
	public static final int SCJVM_TH_OR_ACSH_POINTER_IN_NON_LAUNCHER = 0x0001001F;   /*ibm@5724*/

public static Object newArray(Class type, int size, Object obj) {
	return Array.newInstance(type, size);
}

public static Object resizeArray(int newSize, Object oldArray, int offset, int length) {
	Class type = oldArray.getClass().getComponentType();
	Object newArray = Array.newInstance(type, newSize);
	System.arraycopy(oldArray, offset, newArray, 0, length);
	return newArray;
}

public static void setJVMUnresettableConditionally(int value, String str) {
}

public static void setJVMUnresettableConditionally(int value) {
}

public static boolean getDoUnresettableEventsCheck() {
	return false;
}

public static boolean isResettableJVM() {
	return false;
}

public static boolean isJVMUnresettable() {
	// This should return false (it implies the reset code is in a particular state).
	return false;
}

public static void registerShareableClassLoader(com.ibm.jvm.classloader.Shareable cl, String name) {
}

public static boolean isOldReflectionMode() {
	// Always return false as we will use the new reflection model
	return false;
}

public static void sortArray(Object[] array, Comparator compare) {
	// Do nothing for now - only called from resettable JVMs
}

public static Object allocateNewObject(Class type) throws IllegalAccessException, InstantiationException {
	return type.newInstance();
}

public static void registerTrustedJars(java.net.URL[] urls) {       /*ibm@66079.1*/
	// Do nothing for now - only called from resettable JVMs
}

public static boolean isJarRegistered(String url) {                 /*ibm@66079.1*/
	// Always return false - only called from resettable JVMs
        return false;
}

}
