package com.ibm.oti.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2003  All Rights Reserved
 */

import java.util.Calendar;
import java.util.TimeZone;
import java.io.UTFDataFormatException;

public final class Util {

	private static final String defaultEncoding;

	static {
		String encoding = System.getProperty("os.encoding");
		if (encoding != null) {
			try {
				"".getBytes(encoding);
			} catch (java.io.UnsupportedEncodingException e) {
				encoding = null;
			}
		}
		defaultEncoding = encoding;
	}

public static byte[] getBytes(String name) {
	if (defaultEncoding != null) {
		try {
			return name.getBytes(defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return name.getBytes();
}

public static String toString(byte[] bytes) {
	if (defaultEncoding != null) {
		try {
			return new String(bytes, 0, bytes.length, defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return new String(bytes, 0, bytes.length);
}

public static String toString(byte[] bytes, int offset, int length) {
	if (defaultEncoding != null) {
		try {
			return new String(bytes, offset, length, defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return new String(bytes, offset, length);
}

}
