
package com.ibm.oti.vm;

import java.util.jar.*;
import java.io.IOException;
import java.lang.reflect.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2003  All Rights Reserved
 */

public class JarRunner {

	public static void main(String args[]) throws Exception {

		//Manifest from the jarfile
		Manifest manifest = getManifest(args[0]);
		if (null==manifest) {
			System.err.println(com.ibm.oti.util.Msg.getString("K0222", args[0]));
			return;
		}

		// Main class name from the jarFile
		String mainClass = JarRunner.mainClassName(manifest);
		if (mainClass == null) {
			System.err.println(com.ibm.oti.util.Msg.getString("K01c6", args[0]));
			return;
		}

		// Get the main method from the mainClass
		Class runnable = Class.forName(mainClass, true, ClassLoader.getSystemClassLoader());
		Class mainParams[] = new Class[1];
		mainParams[0] = args.getClass();
		Method mainMethod =  runnable.getMethod("main", mainParams);

		// Run the main method
		Object params[] = new Object[1];
		String margs[] = new String[args.length - 1];
		System.arraycopy(args, 1, margs, 0, (args.length - 1));
		params[0] = margs;
		mainMethod.invoke(null, params);
	}

	private static String mainClassName(Manifest manifest) throws IOException {
		Attributes mainAttrib = manifest.getMainAttributes();
		String name = mainAttrib.getValue(Attributes.Name.MAIN_CLASS);
		if (name != null) name = name.replace('/', '.');
		return name;
	}

	private static Manifest getManifest(String jarFileName) throws IOException {
		JarFile jar = new JarFile(jarFileName);
		return jar.getManifest();
	}
}

