package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * This class is a placeholder for environments which
 * explicitely manage the action of a "Just In Time"
 * compiler. In our environment they do nothing.
 *
 * @author		OTI
 * @version		initial
 *
 * @see			Cloneable
 */
public final class Compiler {

private Compiler() {}

/**
 * Low level interface to the JIT compiler. Can return
 * any object, or null if no JIT compiler is available.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		Object
 *					result of executing command
 * @param		cmd Object
 *					a command for the JIT compiler
 */
public static Object command(Object cmd) {
	return null;
}
/**
 * Compiles the class using the JIT compiler. Answers
 * true if the compilation was successful, or false if
 * it failed or there was no JIT compiler available.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		boolean
 *					indicating compilation success
 * @param		classToCompile java.lang.Class
 *					the class to JIT compile
 */
public static boolean compileClass(Class classToCompile) {
	return false;
}
/**
 * Compiles all classes whose name matches the argument
 * using the JIT compiler. Answers true if the compilation
 * was successful, or false if it failed or there was no
 * JIT compiler available.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		boolean
 *					indicating compilation success
 * @param		nameRoot String
 *					the string to match against class names
 */
public static boolean compileClasses(String nameRoot) {
	return false;
}
/**
 * Disable the JIT compiler
 *
 * @author		OTI
 * @version		initial
 */
public static void disable() {
	// Nope.
}
/**
 * Disable the JIT compiler
 *
 * @author		OTI
 * @version		initial
 */
public static void enable() {
	// Nope.
}

}
