package java.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

/**
 * MapEntry is an internal class which provides an implementation of Map.Entry.
 *
 * @author		OTI
 * @version		initial
 */

class MapEntry implements Map.Entry, Cloneable {
	Object key, value;

	interface Type {
		Object get(MapEntry entry);
	}

MapEntry(Object theKey) {
	key = theKey;
}
MapEntry(Object theKey, Object theValue) {
	key = theKey;
	value = theValue;
}
public Object clone() {
	try {
		return super.clone();
	} catch (CloneNotSupportedException e) {return null;}
}

public boolean equals(Object object) {
	if (this == object) return true;
	if (object instanceof Map.Entry) {
		Map.Entry entry = (Map.Entry)object;
		return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) &&
			(value == null ? entry.getValue() == null : value.equals(entry.getValue()));
	} else return false;
}

public Object getKey() {
	return key;
}

public Object getValue() {
	return value;
}

public int hashCode() {
	return (key == null ? 0 : key.hashCode()) ^
		(value == null ? 0 : value.hashCode());
}

public Object setValue(Object object) {
	Object result = value;
	value = object;
	return result;
}
}
