public class SwingTextInputDialog extends JDialog
    implements ActionListener, KeyListener
{

    public static final int TEXT = 0;
    public static final int PATH_FILES_AND_DIRECTORIES = 1;
    public static final int PATH_DIRECTORIES_ONLY = 2;
    public static final int PATH_FILES_ONLY = 3;
    private String textValue;
    private int result;
    private int type;
    private JTextField userInputField;
    private JButton browseButton;
    private JButton buttons[];
    private int transferFocusIndex;
    private final int captionWidth = 10;

    public SwingTextInputDialog(Frame frame, String s, String s1, int i, String s2, String as[], int j, 
            Image image, String s3)
    {
        super(frame, s, true);
        userInputField = null;
        browseButton = null;
        transferFocusIndex = 0;
        if(as == null)
        {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        if(j < 0 || j >= as.length)
        {
            throw new IllegalArgumentException("defaultOptionIndex parameter must indicate acceptable index within the options a" +
"rray"
);
        }
        type = i;
        textValue = s2 != null ? s2 : "";
        result = j >= 0 && j < as.length ? j : 0;
        transferFocusIndex = result;
        getContentPane().setForeground(SystemColor.controlText);
        getContentPane().setBackground(SystemColor.control);
        getContentPane().setLayout(new ColumnLayout());
        setTitle(s);
        JPanel jpanel = new JPanel();
        jpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jpanel.setLayout(new ColumnLayout());
        getContentPane().add(jpanel, ColumnConstraints.createLeftAlign());
        setDefaultCloseOperation(0);
        JPanel jpanel1 = new JPanel(new FlowLayout(0, 0, 0));
        if(image != null)
        {
            ImageIcon imageicon = new ImageIcon(image);
            JLabel jlabel = new JLabel(imageicon);
            jpanel1.add(jlabel);
            jpanel1.add(Spacing.createHorizontalSpacing(5));
        }
        JPanel jpanel2 = new JPanel(new ColumnLayout());
        MnemonicString mnemonicstring = new MnemonicString(s1);
        JLabel jlabel1 = null;
        JTextArea area = null;
        String prompt = mnemonicstring.toString();
        if(prompt != null)
        {
            prompt = prompt.trim();
        } else
        {
            prompt = "";
        }
        if(prompt.length() > 80 || prompt.indexOf('\n') >= 0)
        {
            area = new JTextArea(prompt, 0, 50);
            area.setEditable(false);
            area.setForeground(SystemColor.controlText);
            area.setBackground(SystemColor.control);
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            area.setAutoscrolls(false);
            jpanel2.add(area, ColumnConstraints.createBothFill());
            jpanel1.add(jpanel2);
            jpanel.add(jpanel1, ColumnConstraints.createBothFill());
        } else
        {
            jlabel1 = new JLabel(mnemonicstring.toString());
            jpanel2.add(jlabel1, ColumnConstraints.createLeftAlign());
            jpanel1.add(jpanel2);
            jpanel.add(jpanel1, ColumnConstraints.createLeftAlign());
        }
        if(i == 0)
        {
            jpanel.add(Spacing.createVerticalSpacing(4));
            userInputField = new JTextField(textValue);
            jpanel.add(userInputField, ColumnConstraints.createHorizontalFill());
        } else
        {
            userInputField = new JTextField(40);
            userInputField.setText(textValue);
            jpanel.add(Spacing.createVerticalSpacing(4));
            jpanel.add(userInputField, ColumnConstraints.createHorizontalFill());
            browseButton = createJButton(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browseWithMn"));
            jpanel.add(Spacing.createVerticalSpacing(4));
            jpanel.add(browseButton, ColumnConstraints.createRightAlign());
        }
        userInputField.addKeyListener(this);
        if(mnemonicstring.isMnemonicSpecified() && jlabel1 != null)
        {
            jlabel1.setDisplayedMnemonic(mnemonicstring.getMnemonicChar());
            jlabel1.setLabelFor(userInputField);
        }
        if(s3 != null && s3.trim().length() != 0)
        {
            JISBranding jisbranding = new JISBranding(s3);
            jpanel.add(Spacing.createVerticalSpacing(4));
            jpanel.add(jisbranding, ColumnConstraints.createHorizontalFill());
        }
        JPanel jpanel3 = new JPanel(new FlowLayout(1, 5, 0));
        buttons = new JButton[as.length];
        for(int k = 0; k < as.length; k++)
        {
            buttons[k] = createJButton(as[k]);
            jpanel3.add(buttons[k]);
        }

        jpanel.add(Spacing.createVerticalSpacing(10));
        jpanel.add(jpanel3, ColumnConstraints.createCenterAlign());
        if(area != null)
        {
            jpanel.add(Spacing.createVerticalSpacing(20));
            setSize(375, 0);
        } else
        {
            setSize(375, 175);
        }
        enableEvents(64L);
        pack();
        synchronized(frame)
        {
            Dimension dimension = frame.isVisible() ? frame.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            Point point = frame.isVisible() ? frame.getLocation() : new Point(0, 0);
            setLocation(point.x + (dimension.width - getSize().width) / 2, point.y + (dimension.height - getSize().height) / 2);
        }
        setResizable(false);
    }

    public SwingTextInputDialog(Frame frame, String s, String s1, String s2, String as[], int i)
    {
        this(frame, s, s1, 0, s2, as, i, null, null);
    }

    public void actionPerformed(ActionEvent actionevent)
    {
        if(actionevent.getSource() == browseButton)
        {
            JFileChooser jfilechooser = new JFileChooser();
            jfilechooser.setCurrentDirectory(new File(userInputField.getText()));
            byte byte0;
            String s;
            switch(type)
            {
            case 3: // '\003'
                byte0 = 0;
                s = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.File");
                break;

            case 2: // '\002'
                byte0 = 1;
                s = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder");
                break;

            default:
                s = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.File");
                byte0 = 2;
                break;
            }
            jfilechooser.setFileSelectionMode(byte0);
            jfilechooser.setDialogTitle(s);
            jfilechooser.setLocation(getLocation().x + (getSize().width - jfilechooser.getSize().width) / 2, getLocation().y + (getSize().height - jfilechooser.getSize().height) / 2);
            int j = jfilechooser.showDialog(this, null);
            if(j == 0 && jfilechooser.getSelectedFile() != null)
            {
                userInputField.setText(jfilechooser.getSelectedFile().getAbsolutePath());
            }
            requestFocus();
        } else
        {
            result = -1;
            for(int i = 0; i < buttons.length; i++)
            {
                if(buttons[i] != actionevent.getSource())
                {
                    continue;
                }
                result = i;
                break;
            }

            textValue = userInputField.getText();
            setVisible(false);
        }
    }

    private JButton createJButton(String s)
    {
        MnemonicString mnemonicstring = new MnemonicString(s);
        JButton jbutton = new JButton(pad(mnemonicstring.toString()));
        if(mnemonicstring.isMnemonicSpecified())
        {
            jbutton.setMnemonic(mnemonicstring.getMnemonicChar());
        }
        jbutton.addActionListener(this);
        jbutton.addKeyListener(this);
        return jbutton;
    }

    public int getResult()
    {
        return result;
    }

    public String getTextValue()
    {
        return textValue;
    }

    public void keyPressed(KeyEvent keyevent)
    {
        if(keyevent.getKeyCode() == 10)
        {
            actionPerformed(new ActionEvent(keyevent.getSource(), 1001, ""));
        }
    }

    public void keyReleased(KeyEvent keyevent1)
    {
    }

    public void keyTyped(KeyEvent keyevent1)
    {
    }

    private String pad(String s)
    {
        int i = 10 - s.length();
        if(i > 0)
        {
            i /= 2;
            StringBuffer stringbuffer = new StringBuffer();
            for(int j = 0; j < i; j++)
            {
                stringbuffer.append(' ');
            }

            stringbuffer.append(s);
            for(int k = 0; k < i; k++)
            {
                stringbuffer.append(' ');
            }

            return stringbuffer.toString();
        } else
        {
            return s;
        }
    }

    protected void processWindowEvent(WindowEvent windowevent)
    {
        if(windowevent.getID() == 202)
        {
            result = -1;
            setVisible(false);
        } else
        if(windowevent.getID() == 200)
        {
            userInputField.requestFocus();
            userInputField.selectAll();
        }
    }
}
