public class RPM
{

    public String major;
    public String minor;
    public String update;
    public String arch;
    public String OS;
    public static String RPM_VERSION = "RPM_VERSION";
    public static String RPMSPEC = "rpmspec";
    public static String RPMSPEC4 = "rpmspec4";
    private static final String spaceSeparator = new String(new byte[] {
        32
    });

    public RPM(String s, String s1)
    {
        major = "";
        minor = "";
        update = "";
        arch = "";
        OS = "";
        major = s;
        minor = s1;
    }

    private static String RPMCommandLineInterface(String s)
        throws IOException, ProcessExecException
    {
        ProcessExec processexec = new ProcessExec("sh", new String[] {
            "-c", s
        });
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        processexec.setProcessOutputHandler(new MemoryProcessOutputHandler(bytearrayoutputstream, null));
        processexec.executeProcess();
        bytearrayoutputstream.close();
        return new String(bytearrayoutputstream.toByteArray());
    }

    public static void createRPMPackage(String s, String s1)
    {
        try
        {
            String s2 = formatRPMBuildCommand(s, s1);
            if(s2 != null)
            {
                String s3 = RPMCommandLineInterface(s2);
                GenericLinuxCommands.linuxPPKDebugPrint(s3);
            } else
            {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMBuildcommand. RPM package can not be created ");
            }
        }
        catch(Exception exception)
        {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while creating RPM Package. ISMP Components will not be registered" +
" in RPM DB."
);
            exception.printStackTrace();
        }
    }

    private static String formatRPMBuildCommand(String s, String s1)
        throws IOException, Exception
    {
        String s2 = "rpm";
        CommandResult commandresult = CommandUtils.executeCommand("sh", new String[] {
            "-c", "rpmbuild --version"
        });
        if(commandresult.getExitCode() == 0)
        {
            s2 = "rpmbuild";
        }
        File file = new File(s);
        if(s != null && file.exists())
        {
            File file1 = new File(s1);
            StringBuffer stringbuffer = new StringBuffer();
            stringbuffer.append(s2).append(spaceSeparator);
            stringbuffer.append("--define").append(spaceSeparator);
            stringbuffer.append("'");
            stringbuffer.append("_rpmdir").append(spaceSeparator);
            stringbuffer.append(FileUtils.getParent(file1.getAbsolutePath()));
            stringbuffer.append("'").append(spaceSeparator);
            stringbuffer.append("--define").append(spaceSeparator);
            stringbuffer.append("'");
            stringbuffer.append("_rpmfilename").append(spaceSeparator);
            stringbuffer.append(FileUtils.getName(file1.getAbsolutePath()));
            stringbuffer.append("'").append(spaceSeparator);
            stringbuffer.append("-bb").append(spaceSeparator);
            s = file.getAbsolutePath();
            stringbuffer.append(s);
            s2 = stringbuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmbuildCommand = " + s2);
        return s2;
    }

    private static String formatRPMRemoveCommand(String s)
    {
        String s1 = null;
        if(s != null)
        {
            StringBuffer stringbuffer = new StringBuffer();
            stringbuffer.append("rpm").append(spaceSeparator);
            stringbuffer.append("-e").append(spaceSeparator);
            stringbuffer.append(s);
            s1 = stringbuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmRemoveCommand = " + s1);
        return s1;
    }

    private static String formatRPMinstallCommand(String s)
        throws IOException
    {
        String s1 = null;
        File file = new File(s);
        if(s != null && file.exists())
        {
            StringBuffer stringbuffer = new StringBuffer();
            stringbuffer.append("rpm").append(spaceSeparator);
            stringbuffer.append("-U").append(spaceSeparator).append("--force").append(spaceSeparator);
            s = file.getAbsolutePath();
            stringbuffer.append(s);
            s1 = stringbuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpminstallCommand = " + s1);
        return s1;
    }

    private static String formatRPMqueryCommand(String s)
    {
        String s1 = null;
        if(s != null)
        {
            StringBuffer stringbuffer = new StringBuffer();
            stringbuffer.append("rpm").append(spaceSeparator);
            stringbuffer.append("-q").append(spaceSeparator);
            stringbuffer.append(s);
            s1 = stringbuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmqueryCommand = " + s1);
        return s1;
    }

    public static boolean isHostRPMSupported()
    {
        boolean flag = false;
        try
        {
            String s = RPMCommandLineInterface("rpm --version");
            flag = s != null && s.length() > 0;
            GenericLinuxCommands.linuxPPKDebugPrint(s);
        }
        catch(Exception exception)
        {
            GenericLinuxCommands.linuxPPKDebugPrint("Host RPM is not supported. ISMP Components will not be registered in RPM DB.");
            exception.printStackTrace();
        }
        return flag;
    }

    public static String queryRPMDB(String s)
    {
        String s1 = "";
        try
        {
            String s2 = formatRPMqueryCommand(s);
            if(s2 != null)
            {
                s1 = RPMCommandLineInterface(s2);
                GenericLinuxCommands.linuxPPKDebugPrint(s1);
            } else
            {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMQuerycommand. RPMDB can not be queried.");
            }
        }
        catch(Exception exception)
        {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while querying RPMDB. RPMDB can not be queried for the RPM Package" +
" "
 + s);
            exception.printStackTrace();
        }
        return s1;
    }

    public static void registerRPMPackage(String s)
    {
        try
        {
            String s1 = formatRPMinstallCommand(s);
            if(s1 != null)
            {
                String s2 = RPMCommandLineInterface(s1);
                GenericLinuxCommands.linuxPPKDebugPrint(s2);
            } else
            {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMInstallcommand. ISMP Components will not be entered in RPM DB.");
            }
        }
        catch(Exception exception)
        {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while installing RPM Package. ISMP Components is not entered in RP" +
"M DB."
);
            exception.printStackTrace();
        }
    }

    public static void removeRPMPackage(String s)
    {
        try
        {
            String s1 = formatRPMRemoveCommand(s);
            if(s1 != null)
            {
                String s2 = RPMCommandLineInterface(s1);
                GenericLinuxCommands.linuxPPKDebugPrint(s2);
            } else
            {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating rpm remove command. RPM package can not be removed.");
            }
        }
        catch(Exception exception)
        {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while removing RPM Package. ISMP Components is not removed from RP" +
"M DB."
);
            exception.printStackTrace();
        }
    }

}
