/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.HTTPProxyException;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.LocalStreamForwarder;
import ch.ethz.ssh2.ProxyData;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.auth.AuthenticationManager;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.packets.PacketIgnore;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.TransportManager;
import ch.ethz.ssh2.util.TimeoutService;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.Vector;

public class Connection {
    public static final String identification = "Ganymed Build_251beta1";
    private SecureRandom generator;
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private final String hostname;
    private final int port;
    private TransportManager tm;
    private boolean tcpNoDelay = false;
    private ProxyData proxyData = null;
    private Vector connectionMonitors = new Vector();

    public static synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getDefaultCipherList();
    }

    public static synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public static synchronized String[] getAvailableServerHostKeyAlgorithms() {
        return KexManager.getDefaultServerHostkeyAlgorithmList();
    }

    public Connection(String string) {
        this(string, 22);
    }

    public Connection(String string, int n) {
        this.hostname = string;
        this.port = n;
    }

    public synchronized boolean authenticateWithDSA(String string, String string2, String string3) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("pem argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, string2.toCharArray(), string3, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, InteractiveCallback interactiveCallback) throws IOException {
        return this.authenticateWithKeyboardInteractive(string, null, interactiveCallback);
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, String[] stringArray, InteractiveCallback interactiveCallback) throws IOException {
        if (interactiveCallback == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateInteractive(string, stringArray, interactiveCallback);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String string, String string2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password argument is null");
        }
        this.authenticated = this.am.authenticatePassword(string, string2);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithNone(String string) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateNone(string);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, char[] cArray, String string2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (cArray == null) {
            throw new IllegalArgumentException("pemPrivateKey argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, cArray, string2, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, File file, String string2) throws IOException {
        int n;
        if (file == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] cArray = new char[256];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        FileReader fileReader = new FileReader(file);
        while ((n = fileReader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        fileReader.close();
        return this.authenticateWithPublicKey(string, charArrayWriter.toCharArray(), string2);
    }

    public synchronized void addConnectionMonitor(ConnectionMonitor connectionMonitor) {
        if (connectionMonitor == null) {
            throw new IllegalArgumentException("cmon argument is null");
        }
        this.connectionMonitors.addElement(connectionMonitor);
        if (this.tm != null) {
            this.tm.setConnectionMonitors(this.connectionMonitors);
        }
    }

    public synchronized void close() {
        Throwable throwable = new Throwable("Closed due to user request.");
        this.close(throwable, false);
    }

    private void close(Throwable throwable, boolean bl) {
        if (this.cm != null) {
            this.cm.closeAllChannels();
        }
        if (this.tm != null) {
            this.tm.close(throwable, !bl);
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() throws IOException {
        return this.connect(null, 0, 0);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier) throws IOException {
        return this.connect(serverHostKeyVerifier, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier, int n, int n2) throws IOException {
        if (this.tm != null) {
            throw new IOException("Connection to " + this.hostname + " is already in connected state!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connectTimeout must be non-negative!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("kexTimeout must be non-negative!");
        }
        final class TimeoutState {
            boolean isCancelled = false;
            boolean timeoutSocketClosed = false;

            TimeoutState() {
            }
        }
        final TimeoutState timeoutState = new TimeoutState();
        this.tm = new TransportManager(this.hostname, this.port);
        this.tm.setConnectionMonitors(this.connectionMonitors);
        Object object = this.tm;
        // MONITORENTER : object
        // MONITOREXIT : object
        try {
            Object object2;
            object = null;
            if (n2 > 0) {
                object2 = new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        TimeoutState timeoutState2 = timeoutState;
                        synchronized (timeoutState2) {
                            if (timeoutState.isCancelled) {
                                return;
                            }
                            timeoutState.timeoutSocketClosed = true;
                            if (Connection.this.tm != null) {
                                Connection.this.tm.close(new SocketTimeoutException("The connect timeout expired"), false);
                            }
                        }
                    }
                };
                long l = System.currentTimeMillis() + (long)n2;
                object = TimeoutService.addTimeoutHandler(l, (Runnable)object2);
            }
            try {
                this.tm.initialize(this.cryptoWishList, serverHostKeyVerifier, this.dhgexpara, n, this.getOrCreateSecureRND(), this.proxyData);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw (SocketTimeoutException)new SocketTimeoutException("The connect() operation on the socket timed out.").initCause(socketTimeoutException);
            }
            this.tm.setTcpNoDelay(this.tcpNoDelay);
            object2 = this.tm.getConnectionInfo(1);
            if (object == null) return object2;
            TimeoutService.cancelTimeoutHandler((TimeoutService.TimeoutToken)object);
            TimeoutState timeoutState2 = timeoutState;
            // MONITORENTER : timeoutState2
            if (timeoutState.timeoutSocketClosed) {
                throw new IOException("This exception will be replaced by the one below =)");
            }
            timeoutState.isCancelled = true;
            // MONITOREXIT : timeoutState2
            return object2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            this.close(new Throwable("There was a problem during connect."), false);
            TimeoutState timeoutState3 = timeoutState;
            // MONITORENTER : timeoutState3
            if (timeoutState.timeoutSocketClosed) {
                throw new SocketTimeoutException("The kexTimeout (" + n2 + " ms) expired.");
            }
            // MONITOREXIT : timeoutState3
            if (!(iOException instanceof HTTPProxyException)) throw (IOException)new IOException("There was a problem while connecting to " + this.hostname + ":" + this.port).initCause(iOException);
            throw iOException;
        }
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int n, String string, int n2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, n, string, n2);
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(InetSocketAddress inetSocketAddress, String string, int n) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, inetSocketAddress, string, n);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String string, int n) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, string, n);
    }

    public synchronized SCPClient createSCPClient() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot create SCP client, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot create SCP client, connection is not authenticated.");
        }
        return new SCPClient(this);
    }

    public synchronized void forceKeyExchange() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized String getHostname() {
        return this.hostname;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized String[] getRemainingAuthMethods(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("user argument may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(string);
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthMethodAvailable(String string, String string2) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("method argument may not be NULL!");
        }
        String[] stringArray = this.getRemainingAuthMethods(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string2) != 0) continue;
            return true;
        }
        return false;
    }

    private final SecureRandom getOrCreateSecureRND() {
        if (this.generator == null) {
            this.generator = new SecureRandom();
        }
        return this.generator;
    }

    public synchronized Session openSession() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm, this.getOrCreateSecureRND());
    }

    public synchronized void sendIgnorePacket() throws IOException {
        SecureRandom secureRandom = this.getOrCreateSecureRND();
        byte[] byArray = new byte[secureRandom.nextInt(16)];
        secureRandom.nextBytes(byArray);
        this.sendIgnorePacket(byArray);
    }

    public synchronized void sendIgnorePacket(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("data argument must not be null.");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Cannot send SSH_MSG_IGNORE packet, you need to establish a connection first.");
        }
        PacketIgnore packetIgnore = new PacketIgnore();
        packetIgnore.setData(byArray);
        this.tm.sendMessage(packetIgnore.getPayload());
    }

    private String[] removeDuplicates(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String string = stringArray[i];
            for (int j = 0; j < n; ++j) {
                if ((string != null || stringArray2[j] != null) && (string == null || !string.equals(stringArray2[j]))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringArray2[n++] = stringArray[i];
        }
        if (n == stringArray2.length) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    public synchronized void setClient2ServerCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.c2s_enc_algos = stringArray;
    }

    public synchronized void setClient2ServerMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.c2s_mac_algos = stringArray;
    }

    public synchronized void setDHGexParameters(DHGexParameters dHGexParameters) {
        if (dHGexParameters == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dHGexParameters;
    }

    public synchronized void setServer2ClientCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.s2c_enc_algos = stringArray;
    }

    public synchronized void setServer2ClientMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.s2c_mac_algos = stringArray;
    }

    public synchronized void setServerHostKeyAlgorithms(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        KexManager.checkServerHostkeyAlgorithmsList(stringArray);
        this.cryptoWishList.serverHostKeyAlgorithms = stringArray;
    }

    public synchronized void setTCPNoDelay(boolean bl) throws IOException {
        this.tcpNoDelay = bl;
        if (this.tm != null) {
            this.tm.setTcpNoDelay(bl);
        }
    }

    public synchronized void setProxyData(ProxyData proxyData) {
        this.proxyData = proxyData;
    }

    public synchronized void requestRemotePortForwarding(String string, int n, String string2, int n2) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        if (string == null || string2 == null || n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.cm.requestGlobalForward(string, n, string2, n2);
    }

    public synchronized void cancelRemotePortForwarding(int n) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        this.cm.requestCancelGlobalForward(n);
    }

    public synchronized void setSecureRandom(SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException();
        }
        this.generator = secureRandom;
    }
}

