/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.channel.X11ServerData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class Session {
    ChannelManager cm;
    Channel cn;
    boolean flag_pty_requested = false;
    boolean flag_x11_requested = false;
    boolean flag_execution_started = false;
    boolean flag_closed = false;
    String x11FakeCookie = null;
    final SecureRandom rnd;

    Session(ChannelManager channelManager, SecureRandom secureRandom) throws IOException {
        this.cm = channelManager;
        this.cn = channelManager.openSessionChannel();
        this.rnd = secureRandom;
    }

    public void requestDumbPTY() throws IOException {
        this.requestPTY("dumb", 0, 0, 0, 0, null);
    }

    public void requestPTY(String string) throws IOException {
        this.requestPTY(string, 0, 0, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(String string, int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("TERM cannot be null.");
        }
        if (byArray != null && byArray.length > 0) {
            if (byArray[byArray.length - 1] != 0) {
                throw new IOException("Illegal terminal modes description, does not end in zero byte");
            }
        } else {
            byArray = new byte[]{0};
        }
        Session session = this;
        synchronized (session) {
            if (this.flag_closed) {
                throw new IOException("This session is closed.");
            }
            if (this.flag_pty_requested) {
                throw new IOException("A PTY was already requested.");
            }
            if (this.flag_execution_started) {
                throw new IOException("Cannot request PTY at this stage anymore, a remote execution has already started.");
            }
            this.flag_pty_requested = true;
        }
        this.cm.requestPTY(this.cn, string, n, n2, n3, n4, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestX11Forwarding(String string, int n, byte[] byArray, boolean bl) throws IOException {
        Object object;
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("hostname argument may not be null");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.flag_closed) {
                throw new IOException("This session is closed.");
            }
            if (this.flag_x11_requested) {
                throw new IOException("X11 forwarding was already requested.");
            }
            if (this.flag_execution_started) {
                throw new IOException("Cannot request X11 forwarding at this stage anymore, a remote execution has already started.");
            }
            this.flag_x11_requested = true;
        }
        object2 = new X11ServerData();
        ((X11ServerData)object2).hostname = string;
        ((X11ServerData)object2).port = n;
        ((X11ServerData)object2).x11_magic_cookie = byArray;
        byte[] byArray2 = new byte[16];
        do {
            this.rnd.nextBytes(byArray2);
            object = new StringBuffer(32);
            for (int i = 0; i < byArray2.length; ++i) {
                String string3 = Integer.toHexString(byArray2[i] & 0xFF);
                ((StringBuffer)object).append(string3.length() == 2 ? string3 : "0" + string3);
            }
        } while (this.cm.checkX11Cookie(string2 = ((StringBuffer)object).toString()) != null);
        this.cm.requestX11(this.cn, bl, "MIT-MAGIC-COOKIE-1", string2, 0);
        object = this;
        synchronized (object) {
            if (!this.flag_closed) {
                this.x11FakeCookie = string2;
                this.cm.registerX11Cookie(string2, (X11ServerData)object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execCommand(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("cmd argument may not be null");
        }
        Session session = this;
        synchronized (session) {
            if (this.flag_closed) {
                throw new IOException("This session is closed.");
            }
            if (this.flag_execution_started) {
                throw new IOException("A remote execution has already started.");
            }
            this.flag_execution_started = true;
        }
        this.cm.requestExecCommand(this.cn, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startShell() throws IOException {
        Session session = this;
        synchronized (session) {
            if (this.flag_closed) {
                throw new IOException("This session is closed.");
            }
            if (this.flag_execution_started) {
                throw new IOException("A remote execution has already started.");
            }
            this.flag_execution_started = true;
        }
        this.cm.requestShell(this.cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSubSystem(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("name argument may not be null");
        }
        Session session = this;
        synchronized (session) {
            if (this.flag_closed) {
                throw new IOException("This session is closed.");
            }
            if (this.flag_execution_started) {
                throw new IOException("A remote execution has already started.");
            }
            this.flag_execution_started = true;
        }
        this.cm.requestSubSystem(this.cn, string);
    }

    public InputStream getStdout() {
        return this.cn.getStdoutStream();
    }

    public InputStream getStderr() {
        return this.cn.getStderrStream();
    }

    public OutputStream getStdin() {
        return this.cn.getStdinStream();
    }

    public int waitUntilDataAvailable(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must not be negative!");
        }
        int n = this.cm.waitForCondition(this.cn, l, 28);
        if ((n & 1) != 0) {
            return -1;
        }
        if ((n & 0xC) != 0) {
            return 1;
        }
        if ((n & 0x10) != 0) {
            return 0;
        }
        throw new IllegalStateException("Unexpected condition result (" + n + ")");
    }

    public int waitForCondition(int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative!");
        }
        return this.cm.waitForCondition(this.cn, l, n);
    }

    public Integer getExitStatus() {
        return this.cn.getExitStatus();
    }

    public String getExitSignal() {
        return this.cn.getExitSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Session session = this;
        synchronized (session) {
            if (this.flag_closed) {
                return;
            }
            this.flag_closed = true;
            if (this.x11FakeCookie != null) {
                this.cm.unRegisterX11Cookie(this.x11FakeCookie, true);
            }
            try {
                this.cm.closeChannel(this.cn, "Closed due to user request", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

