/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import java.io.IOException;
import java.io.InputStream;

public class StreamGobbler
extends InputStream {
    private InputStream is;
    private GobblerThread t;
    private Object synchronizer = new Object();
    private boolean isEOF = false;
    private boolean isClosed = false;
    private IOException exception = null;
    private byte[] buffer = new byte[2048];
    private int read_pos = 0;
    private int write_pos = 0;

    public StreamGobbler(InputStream inputStream) {
        this.is = inputStream;
        this.t = new GobblerThread();
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        int n;
        boolean bl = false;
        try {
            Object object = this.synchronizer;
            // MONITORENTER : object
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        while (this.read_pos == this.write_pos) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.isEOF) {
                int n2 = -1;
                // MONITOREXIT : object
                if (!bl) return n2;
                Thread.currentThread().interrupt();
                return n2;
            }
            try {
                this.synchronizer.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        int n3 = n = this.buffer[this.read_pos++] & 0xFF;
        // MONITOREXIT : object
        if (!bl) return n3;
        Thread.currentThread().interrupt();
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
            return this.write_pos - this.read_pos;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.isEOF = true;
            this.synchronizer.notifyAll();
            this.is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0) throw new IndexOutOfBoundsException();
        if (n2 < 0) throw new IndexOutOfBoundsException();
        if (n + n2 > byArray.length) throw new IndexOutOfBoundsException();
        if (n + n2 < 0) throw new IndexOutOfBoundsException();
        if (n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        boolean bl = false;
        try {
            Object object = this.synchronizer;
            // MONITORENTER : object
            if (this.isClosed) {
                throw new IOException("This StreamGobbler is closed.");
            }
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        while (this.read_pos == this.write_pos) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.isEOF) {
                int n3 = -1;
                // MONITOREXIT : object
                if (!bl) return n3;
                Thread.currentThread().interrupt();
                return n3;
            }
            try {
                this.synchronizer.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        int n4 = this.write_pos - this.read_pos;
        n4 = n4 > n2 ? n2 : n4;
        System.arraycopy(this.buffer, this.read_pos, byArray, n, n4);
        this.read_pos += n4;
        int n5 = n4;
        // MONITOREXIT : object
        if (!bl) return n5;
        Thread.currentThread().interrupt();
        return n5;
    }

    static /* synthetic */ byte[] access$302(StreamGobbler streamGobbler, byte[] byArray) {
        streamGobbler.buffer = byArray;
        return byArray;
    }

    class GobblerThread
    extends Thread {
        GobblerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            byte[] byArray = new byte[8192];
            try {
                while (true) {
                    int n = StreamGobbler.this.is.read(byArray);
                    Object object = StreamGobbler.this.synchronizer;
                    synchronized (object) {
                        if (n <= 0) {
                            StreamGobbler.this.isEOF = true;
                            StreamGobbler.this.synchronizer.notifyAll();
                            return;
                        }
                        int n2 = StreamGobbler.this.buffer.length - StreamGobbler.this.write_pos;
                        if (n2 < n) {
                            int n3 = StreamGobbler.this.write_pos - StreamGobbler.this.read_pos;
                            int n4 = n3 + n;
                            byte[] byArray2 = StreamGobbler.this.buffer;
                            if (n4 > StreamGobbler.this.buffer.length) {
                                int n5 = n4 / 3;
                                n5 = n5 < 256 ? 256 : n5;
                                n5 = n5 > 8192 ? 8192 : n5;
                                byArray2 = new byte[n4 + n5];
                            }
                            if (n3 > 0) {
                                System.arraycopy(StreamGobbler.this.buffer, StreamGobbler.this.read_pos, byArray2, 0, n3);
                            }
                            StreamGobbler.access$302(StreamGobbler.this, byArray2);
                            StreamGobbler.this.read_pos = 0;
                            StreamGobbler.this.write_pos = n3;
                        }
                        System.arraycopy(byArray, 0, StreamGobbler.this.buffer, StreamGobbler.this.write_pos, n);
                        StreamGobbler.this.write_pos += n;
                        StreamGobbler.this.synchronizer.notifyAll();
                    }
                }
            }
            catch (IOException iOException) {
                Object object = StreamGobbler.this.synchronizer;
                synchronized (object) {
                    StreamGobbler.this.exception = iOException;
                    StreamGobbler.this.synchronizer.notifyAll();
                    return;
                }
            }
        }
    }
}

