/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.channel.IChannelWorkerThread;
import ch.ethz.ssh2.channel.StreamForwarder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class LocalAcceptThread
extends Thread
implements IChannelWorkerThread {
    ChannelManager cm;
    String host_to_connect;
    int port_to_connect;
    final ServerSocket ss;

    public LocalAcceptThread(ChannelManager channelManager, int n, String string, int n2) throws IOException {
        this.cm = channelManager;
        this.host_to_connect = string;
        this.port_to_connect = n2;
        this.ss = new ServerSocket(n);
    }

    public LocalAcceptThread(ChannelManager channelManager, InetSocketAddress inetSocketAddress, String string, int n) throws IOException {
        this.cm = channelManager;
        this.host_to_connect = string;
        this.port_to_connect = n;
        this.ss = new ServerSocket();
        this.ss.bind(inetSocketAddress);
    }

    public void run() {
        try {
            this.cm.registerThread(this);
        }
        catch (IOException iOException) {
            this.stopWorking();
            return;
        }
        while (true) {
            Socket socket = null;
            try {
                socket = this.ss.accept();
            }
            catch (IOException iOException) {
                this.stopWorking();
                return;
            }
            Channel channel = null;
            StreamForwarder streamForwarder = null;
            StreamForwarder streamForwarder2 = null;
            try {
                channel = this.cm.openDirectTCPIPChannel(this.host_to_connect, this.port_to_connect, socket.getInetAddress().getHostAddress(), socket.getPort());
            }
            catch (IOException iOException) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {}
                continue;
            }
            try {
                streamForwarder = new StreamForwarder(channel, null, null, channel.stdoutStream, socket.getOutputStream(), "RemoteToLocal");
                streamForwarder2 = new StreamForwarder(channel, streamForwarder, socket, socket.getInputStream(), channel.stdinStream, "LocalToRemote");
            }
            catch (IOException iOException) {
                try {
                    channel.cm.closeChannel(channel, "Weird error during creation of StreamForwarder (" + iOException.getMessage() + ")", true);
                }
                catch (IOException iOException3) {}
                continue;
            }
            streamForwarder.setDaemon(true);
            streamForwarder2.setDaemon(true);
            streamForwarder.start();
            streamForwarder2.start();
        }
    }

    public void stopWorking() {
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

