/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto;

import ch.ethz.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;

public class KeyMaterial {
    public byte[] initial_iv_client_to_server;
    public byte[] initial_iv_server_to_client;
    public byte[] enc_key_client_to_server;
    public byte[] enc_key_server_to_client;
    public byte[] integrity_key_client_to_server;
    public byte[] integrity_key_server_to_client;

    private static byte[] calculateKey(HashForSSH2Types hashForSSH2Types, BigInteger bigInteger, byte[] byArray, byte by, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[n];
        int n2 = hashForSSH2Types.getDigestLength();
        int n3 = (n + n2 - 1) / n2;
        byte[][] byArrayArray = new byte[n3][];
        hashForSSH2Types.reset();
        hashForSSH2Types.updateBigInt(bigInteger);
        hashForSSH2Types.updateBytes(byArray);
        hashForSSH2Types.updateByte(by);
        hashForSSH2Types.updateBytes(byArray2);
        byArrayArray[0] = hashForSSH2Types.getDigest();
        int n4 = 0;
        int n5 = Math.min(n2, n);
        System.arraycopy(byArrayArray[0], 0, byArray3, n4, n5);
        n -= n5;
        n4 += n5;
        for (int i = 1; i < n3; ++i) {
            hashForSSH2Types.updateBigInt(bigInteger);
            hashForSSH2Types.updateBytes(byArray);
            for (int j = 0; j < i; ++j) {
                hashForSSH2Types.updateBytes(byArrayArray[j]);
            }
            byArrayArray[i] = hashForSSH2Types.getDigest();
            n5 = Math.min(n2, n);
            System.arraycopy(byArrayArray[i], 0, byArray3, n4, n5);
            n -= n5;
            n4 += n5;
        }
        return byArray3;
    }

    public static KeyMaterial create(String string, byte[] byArray, BigInteger bigInteger, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        KeyMaterial keyMaterial = new KeyMaterial();
        HashForSSH2Types hashForSSH2Types = new HashForSSH2Types(string);
        keyMaterial.initial_iv_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)65, byArray2, n2);
        keyMaterial.initial_iv_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)66, byArray2, n5);
        keyMaterial.enc_key_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)67, byArray2, n);
        keyMaterial.enc_key_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)68, byArray2, n4);
        keyMaterial.integrity_key_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)69, byArray2, n3);
        keyMaterial.integrity_key_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)70, byArray2, n6);
        return keyMaterial;
    }
}

