/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.PEMStructure;
import ch.ethz.ssh2.crypto.SimpleDERReader;
import ch.ethz.ssh2.crypto.cipher.AES;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import ch.ethz.ssh2.crypto.cipher.DES;
import ch.ethz.ssh2.crypto.cipher.DESede;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.util.StringEncoder;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.math.BigInteger;

public class PEMDecoder {
    private static final int PEM_RSA_PRIVATE_KEY = 1;
    private static final int PEM_DSA_PRIVATE_KEY = 2;

    private static final int hexToInt(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Need hex char");
    }

    private static byte[] hexToByteArray(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Uneven string length in hex encoding.");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = PEMDecoder.hexToInt(string.charAt(i * 2));
            int n2 = PEMDecoder.hexToInt(string.charAt(i * 2 + 1));
            byArray[i] = (byte)(n * 16 + n2);
        }
        return byArray;
    }

    private static byte[] generateKeyFromPasswordSaltWithMD5(byte[] byArray, byte[] byArray2, int n) throws IOException {
        if (byArray2.length < 8) {
            throw new IllegalArgumentException("Salt needs to be at least 8 bytes for key generation.");
        }
        MD5 mD5 = new MD5();
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[mD5.getDigestLength()];
        while (true) {
            mD5.update(byArray, 0, byArray.length);
            mD5.update(byArray2, 0, 8);
            int n2 = n < byArray4.length ? n : byArray4.length;
            mD5.digest(byArray4, 0);
            System.arraycopy(byArray4, 0, byArray3, byArray3.length - n, n2);
            if ((n -= n2) == 0) {
                return byArray3;
            }
            mD5.update(byArray4, 0, byArray4.length);
        }
    }

    private static byte[] removePadding(byte[] byArray, int n) throws IOException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 < 1 || n2 > n) {
            throw new IOException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        for (int i = 2; i <= n2; ++i) {
            if (byArray[byArray.length - i] == n2) continue;
            throw new IOException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length - n2);
        return byArray2;
    }

    private static final PEMStructure parsePEM(char[] cArray) throws IOException {
        Object object;
        String string;
        BufferedReader bufferedReader;
        String string2;
        PEMStructure pEMStructure;
        block9: {
            pEMStructure = new PEMStructure();
            string2 = null;
            bufferedReader = new BufferedReader(new CharArrayReader(cArray));
            string = null;
            do {
                if ((string2 = bufferedReader.readLine()) == null) {
                    throw new IOException("Invalid PEM structure, '-----BEGIN...' missing");
                }
                if (!(string2 = string2.trim()).startsWith("-----BEGIN DSA PRIVATE KEY-----")) continue;
                string = "-----END DSA PRIVATE KEY-----";
                pEMStructure.pemType = 2;
                break block9;
            } while (!string2.startsWith("-----BEGIN RSA PRIVATE KEY-----"));
            string = "-----END RSA PRIVATE KEY-----";
            pEMStructure.pemType = 1;
        }
        while (true) {
            if ((string2 = bufferedReader.readLine()) == null) {
                throw new IOException("Invalid PEM structure, " + string + " missing");
            }
            int n = (string2 = string2.trim()).indexOf(58);
            if (n == -1) break;
            object = string2.substring(0, n + 1);
            String string3 = string2.substring(n + 1);
            String[] stringArray = string3.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            if ("Proc-Type:".equals(object)) {
                pEMStructure.procType = stringArray;
                continue;
            }
            if (!"DEK-Info:".equals(object)) continue;
            pEMStructure.dekInfo = stringArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (string2 == null) {
                throw new IOException("Invalid PEM structure, " + string + " missing");
            }
            if ((string2 = string2.trim()).startsWith(string)) break;
            stringBuffer.append(string2);
            string2 = bufferedReader.readLine();
        }
        object = new char[stringBuffer.length()];
        stringBuffer.getChars(0, ((Object)object).length, (char[])object, 0);
        pEMStructure.data = Base64.decode((char[])object);
        if (pEMStructure.data.length == 0) {
            throw new IOException("Invalid PEM structure, no data available");
        }
        return pEMStructure;
    }

    private static final void decryptPEM(PEMStructure pEMStructure, byte[] byArray) throws IOException {
        Object object;
        if (pEMStructure.dekInfo == null) {
            throw new IOException("Broken PEM, no mode and salt given, but encryption enabled");
        }
        if (pEMStructure.dekInfo.length != 2) {
            throw new IOException("Broken PEM, DEK-Info is incomplete!");
        }
        String string = pEMStructure.dekInfo[0];
        byte[] byArray2 = PEMDecoder.hexToByteArray(pEMStructure.dekInfo[1]);
        CBCMode cBCMode = null;
        if (string.equals("DES-EDE3-CBC")) {
            object = new DESede();
            ((DESede)object).init(false, PEMDecoder.generateKeyFromPasswordSaltWithMD5(byArray, byArray2, 24));
            cBCMode = new CBCMode((BlockCipher)object, byArray2, false);
        } else if (string.equals("DES-CBC")) {
            object = new DES();
            ((DES)object).init(false, PEMDecoder.generateKeyFromPasswordSaltWithMD5(byArray, byArray2, 8));
            cBCMode = new CBCMode((BlockCipher)object, byArray2, false);
        } else if (string.equals("AES-128-CBC")) {
            object = new AES();
            ((AES)object).init(false, PEMDecoder.generateKeyFromPasswordSaltWithMD5(byArray, byArray2, 16));
            cBCMode = new CBCMode((BlockCipher)object, byArray2, false);
        } else if (string.equals("AES-192-CBC")) {
            object = new AES();
            ((AES)object).init(false, PEMDecoder.generateKeyFromPasswordSaltWithMD5(byArray, byArray2, 24));
            cBCMode = new CBCMode((BlockCipher)object, byArray2, false);
        } else if (string.equals("AES-256-CBC")) {
            object = new AES();
            ((AES)object).init(false, PEMDecoder.generateKeyFromPasswordSaltWithMD5(byArray, byArray2, 32));
            cBCMode = new CBCMode((BlockCipher)object, byArray2, false);
        } else {
            throw new IOException("Cannot decrypt PEM structure, unknown cipher " + string);
        }
        if (pEMStructure.data.length % cBCMode.getBlockSize() != 0) {
            throw new IOException("Invalid PEM structure, size of encrypted block is not a multiple of " + cBCMode.getBlockSize());
        }
        object = new byte[pEMStructure.data.length];
        for (int i = 0; i < pEMStructure.data.length / cBCMode.getBlockSize(); ++i) {
            cBCMode.transformBlock(pEMStructure.data, i * cBCMode.getBlockSize(), (byte[])object, i * cBCMode.getBlockSize());
        }
        object = PEMDecoder.removePadding((byte[])object, cBCMode.getBlockSize());
        pEMStructure.data = (byte[])object;
        pEMStructure.dekInfo = null;
        pEMStructure.procType = null;
    }

    public static final boolean isPEMEncrypted(PEMStructure pEMStructure) throws IOException {
        if (pEMStructure.procType == null) {
            return false;
        }
        if (pEMStructure.procType.length != 2) {
            throw new IOException("Unknown Proc-Type field.");
        }
        if (!"4".equals(pEMStructure.procType[0])) {
            throw new IOException("Unknown Proc-Type field (" + pEMStructure.procType[0] + ")");
        }
        return "ENCRYPTED".equals(pEMStructure.procType[1]);
    }

    public static Object decode(char[] cArray, String string) throws IOException {
        PEMStructure pEMStructure = PEMDecoder.parsePEM(cArray);
        if (PEMDecoder.isPEMEncrypted(pEMStructure)) {
            if (string == null) {
                throw new IOException("PEM is encrypted, but no password was specified");
            }
            PEMDecoder.decryptPEM(pEMStructure, StringEncoder.GetBytes(string));
        }
        if (pEMStructure.pemType == 2) {
            SimpleDERReader simpleDERReader = new SimpleDERReader(pEMStructure.data);
            byte[] byArray = simpleDERReader.readSequenceAsByteArray();
            if (simpleDERReader.available() != 0) {
                throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
            }
            simpleDERReader.resetInput(byArray);
            BigInteger bigInteger = simpleDERReader.readInt();
            if (bigInteger.compareTo(BigInteger.ZERO) != 0) {
                throw new IOException("Wrong version (" + bigInteger + ") in DSA PRIVATE KEY DER stream.");
            }
            BigInteger bigInteger2 = simpleDERReader.readInt();
            BigInteger bigInteger3 = simpleDERReader.readInt();
            BigInteger bigInteger4 = simpleDERReader.readInt();
            BigInteger bigInteger5 = simpleDERReader.readInt();
            BigInteger bigInteger6 = simpleDERReader.readInt();
            if (simpleDERReader.available() != 0) {
                throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
            }
            return new DSAPrivateKey(bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6);
        }
        if (pEMStructure.pemType == 1) {
            SimpleDERReader simpleDERReader = new SimpleDERReader(pEMStructure.data);
            byte[] byArray = simpleDERReader.readSequenceAsByteArray();
            if (simpleDERReader.available() != 0) {
                throw new IOException("Padding in RSA PRIVATE KEY DER stream.");
            }
            simpleDERReader.resetInput(byArray);
            BigInteger bigInteger = simpleDERReader.readInt();
            if (bigInteger.compareTo(BigInteger.ZERO) != 0 && bigInteger.compareTo(BigInteger.ONE) != 0) {
                throw new IOException("Wrong version (" + bigInteger + ") in RSA PRIVATE KEY DER stream.");
            }
            BigInteger bigInteger7 = simpleDERReader.readInt();
            BigInteger bigInteger8 = simpleDERReader.readInt();
            BigInteger bigInteger9 = simpleDERReader.readInt();
            return new RSAPrivateKey(bigInteger9, bigInteger8, bigInteger7);
        }
        throw new IOException("PEM problem: it is of unknown type");
    }
}

