/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;

public class CBCMode
implements BlockCipher {
    BlockCipher tc;
    int blockSize;
    boolean doEncrypt;
    byte[] cbc_vector;
    byte[] tmp_vector;

    public void init(boolean bl, byte[] byArray) {
    }

    public CBCMode(BlockCipher blockCipher, byte[] byArray, boolean bl) throws IllegalArgumentException {
        this.tc = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.doEncrypt = bl;
        if (this.blockSize != byArray.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + byArray.length + ")");
        }
        this.cbc_vector = new byte[this.blockSize];
        this.tmp_vector = new byte[this.blockSize];
        System.arraycopy(byArray, 0, this.cbc_vector, 0, this.blockSize);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        for (int i = 0; i < this.blockSize; ++i) {
            int n3 = i;
            this.cbc_vector[n3] = (byte)(this.cbc_vector[n3] ^ byArray[n + i]);
        }
        this.tc.transformBlock(this.cbc_vector, 0, byArray2, n2);
        System.arraycopy(byArray2, n2, this.cbc_vector, 0, this.blockSize);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        System.arraycopy(byArray, n, this.tmp_vector, 0, this.blockSize);
        this.tc.transformBlock(byArray, n, byArray2, n2);
        for (int i = 0; i < this.blockSize; ++i) {
            int n3 = n2 + i;
            byArray2[n3] = (byte)(byArray2[n3] ^ this.cbc_vector[i]);
        }
        byte[] byArray3 = this.cbc_vector;
        this.cbc_vector = this.tmp_vector;
        this.tmp_vector = byArray3;
    }

    public void transformBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.doEncrypt) {
            this.encryptBlock(byArray, n, byArray2, n2);
        } else {
            this.decryptBlock(byArray, n, byArray2, n2);
        }
    }
}

