/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public final class HMAC
implements Digest {
    Digest md;
    byte[] k_xor_ipad;
    byte[] k_xor_opad;
    byte[] tmp;
    int size;

    public HMAC(Digest digest, byte[] byArray, int n) {
        this.md = digest;
        this.size = n;
        this.tmp = new byte[digest.getDigestLength()];
        this.k_xor_ipad = new byte[64];
        this.k_xor_opad = new byte[64];
        if (byArray.length > 64) {
            digest.reset();
            digest.update(byArray);
            digest.digest(this.tmp);
            byArray = this.tmp;
        }
        System.arraycopy(byArray, 0, this.k_xor_ipad, 0, byArray.length);
        System.arraycopy(byArray, 0, this.k_xor_opad, 0, byArray.length);
        int n2 = 0;
        while (n2 < 64) {
            int n3 = n2;
            this.k_xor_ipad[n3] = (byte)(this.k_xor_ipad[n3] ^ 0x36);
            int n4 = n2++;
            this.k_xor_opad[n4] = (byte)(this.k_xor_opad[n4] ^ 0x5C);
        }
        digest.update(this.k_xor_ipad);
    }

    public final int getDigestLength() {
        return this.size;
    }

    public final void update(byte by) {
        this.md.update(by);
    }

    public final void update(byte[] byArray) {
        this.md.update(byArray);
    }

    public final void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public final void reset() {
        this.md.reset();
        this.md.update(this.k_xor_ipad);
    }

    public final void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public final void digest(byte[] byArray, int n) {
        this.md.digest(this.tmp);
        this.md.update(this.k_xor_opad);
        this.md.update(this.tmp);
        this.md.digest(this.tmp);
        System.arraycopy(this.tmp, 0, byArray, n, this.size);
        this.md.update(this.k_xor_ipad);
    }
}

