/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;
import ch.ethz.ssh2.crypto.digest.HMAC;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.crypto.digest.SHA1;

public final class MAC {
    Digest mac;
    int size;

    public static final String[] getMacList() {
        return new String[]{"hmac-sha1-96", "hmac-sha1", "hmac-md5-96", "hmac-md5"};
    }

    public static final void checkMacList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            MAC.getKeyLen(stringArray[i]);
        }
    }

    public static final int getKeyLen(String string) {
        if (string.equals("hmac-sha1")) {
            return 20;
        }
        if (string.equals("hmac-sha1-96")) {
            return 20;
        }
        if (string.equals("hmac-md5")) {
            return 16;
        }
        if (string.equals("hmac-md5-96")) {
            return 16;
        }
        throw new IllegalArgumentException("Unkown algorithm " + string);
    }

    public MAC(String string, byte[] byArray) {
        if (string.equals("hmac-sha1")) {
            this.mac = new HMAC(new SHA1(), byArray, 20);
        } else if (string.equals("hmac-sha1-96")) {
            this.mac = new HMAC(new SHA1(), byArray, 12);
        } else if (string.equals("hmac-md5")) {
            this.mac = new HMAC(new MD5(), byArray, 16);
        } else if (string.equals("hmac-md5-96")) {
            this.mac = new HMAC(new MD5(), byArray, 12);
        } else {
            throw new IllegalArgumentException("Unkown algorithm " + string);
        }
        this.size = this.mac.getDigestLength();
    }

    public final void initMac(int n) {
        this.mac.reset();
        this.mac.update((byte)(n >> 24));
        this.mac.update((byte)(n >> 16));
        this.mac.update((byte)(n >> 8));
        this.mac.update((byte)n);
    }

    public final void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    public final void getMac(byte[] byArray, int n) {
        this.mac.digest(byArray, n);
    }

    public final int size() {
        return this.size;
    }
}

