/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public final class MD5
implements Digest {
    private int state0;
    private int state1;
    private int state2;
    private int state3;
    private long count;
    private final byte[] block = new byte[64];
    private final int[] x = new int[16];
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public MD5() {
        this.reset();
    }

    private static final int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 & n3 | ~n2 & n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static final int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 & n4 | n3 & ~n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static final int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 ^ n3 ^ n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static final int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n3 ^ (n2 | ~n4)) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static final void encode(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    private final void transform(byte[] byArray, int n) {
        int n2 = this.state0;
        int n3 = this.state1;
        int n4 = this.state2;
        int n5 = this.state3;
        int n6 = 0;
        while (n6 < 16) {
            this.x[n6] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
            ++n6;
            n += 4;
        }
        n2 = MD5.FF(n2, n3, n4, n5, this.x[0], 7, -680876936);
        n5 = MD5.FF(n5, n2, n3, n4, this.x[1], 12, -389564586);
        n4 = MD5.FF(n4, n5, n2, n3, this.x[2], 17, 606105819);
        n3 = MD5.FF(n3, n4, n5, n2, this.x[3], 22, -1044525330);
        n2 = MD5.FF(n2, n3, n4, n5, this.x[4], 7, -176418897);
        n5 = MD5.FF(n5, n2, n3, n4, this.x[5], 12, 1200080426);
        n4 = MD5.FF(n4, n5, n2, n3, this.x[6], 17, -1473231341);
        n3 = MD5.FF(n3, n4, n5, n2, this.x[7], 22, -45705983);
        n2 = MD5.FF(n2, n3, n4, n5, this.x[8], 7, 1770035416);
        n5 = MD5.FF(n5, n2, n3, n4, this.x[9], 12, -1958414417);
        n4 = MD5.FF(n4, n5, n2, n3, this.x[10], 17, -42063);
        n3 = MD5.FF(n3, n4, n5, n2, this.x[11], 22, -1990404162);
        n2 = MD5.FF(n2, n3, n4, n5, this.x[12], 7, 1804603682);
        n5 = MD5.FF(n5, n2, n3, n4, this.x[13], 12, -40341101);
        n4 = MD5.FF(n4, n5, n2, n3, this.x[14], 17, -1502002290);
        n3 = MD5.FF(n3, n4, n5, n2, this.x[15], 22, 1236535329);
        n2 = MD5.GG(n2, n3, n4, n5, this.x[1], 5, -165796510);
        n5 = MD5.GG(n5, n2, n3, n4, this.x[6], 9, -1069501632);
        n4 = MD5.GG(n4, n5, n2, n3, this.x[11], 14, 643717713);
        n3 = MD5.GG(n3, n4, n5, n2, this.x[0], 20, -373897302);
        n2 = MD5.GG(n2, n3, n4, n5, this.x[5], 5, -701558691);
        n5 = MD5.GG(n5, n2, n3, n4, this.x[10], 9, 38016083);
        n4 = MD5.GG(n4, n5, n2, n3, this.x[15], 14, -660478335);
        n3 = MD5.GG(n3, n4, n5, n2, this.x[4], 20, -405537848);
        n2 = MD5.GG(n2, n3, n4, n5, this.x[9], 5, 568446438);
        n5 = MD5.GG(n5, n2, n3, n4, this.x[14], 9, -1019803690);
        n4 = MD5.GG(n4, n5, n2, n3, this.x[3], 14, -187363961);
        n3 = MD5.GG(n3, n4, n5, n2, this.x[8], 20, 1163531501);
        n2 = MD5.GG(n2, n3, n4, n5, this.x[13], 5, -1444681467);
        n5 = MD5.GG(n5, n2, n3, n4, this.x[2], 9, -51403784);
        n4 = MD5.GG(n4, n5, n2, n3, this.x[7], 14, 1735328473);
        n3 = MD5.GG(n3, n4, n5, n2, this.x[12], 20, -1926607734);
        n2 = MD5.HH(n2, n3, n4, n5, this.x[5], 4, -378558);
        n5 = MD5.HH(n5, n2, n3, n4, this.x[8], 11, -2022574463);
        n4 = MD5.HH(n4, n5, n2, n3, this.x[11], 16, 1839030562);
        n3 = MD5.HH(n3, n4, n5, n2, this.x[14], 23, -35309556);
        n2 = MD5.HH(n2, n3, n4, n5, this.x[1], 4, -1530992060);
        n5 = MD5.HH(n5, n2, n3, n4, this.x[4], 11, 1272893353);
        n4 = MD5.HH(n4, n5, n2, n3, this.x[7], 16, -155497632);
        n3 = MD5.HH(n3, n4, n5, n2, this.x[10], 23, -1094730640);
        n2 = MD5.HH(n2, n3, n4, n5, this.x[13], 4, 681279174);
        n5 = MD5.HH(n5, n2, n3, n4, this.x[0], 11, -358537222);
        n4 = MD5.HH(n4, n5, n2, n3, this.x[3], 16, -722521979);
        n3 = MD5.HH(n3, n4, n5, n2, this.x[6], 23, 76029189);
        n2 = MD5.HH(n2, n3, n4, n5, this.x[9], 4, -640364487);
        n5 = MD5.HH(n5, n2, n3, n4, this.x[12], 11, -421815835);
        n4 = MD5.HH(n4, n5, n2, n3, this.x[15], 16, 530742520);
        n3 = MD5.HH(n3, n4, n5, n2, this.x[2], 23, -995338651);
        n2 = MD5.II(n2, n3, n4, n5, this.x[0], 6, -198630844);
        n5 = MD5.II(n5, n2, n3, n4, this.x[7], 10, 1126891415);
        n4 = MD5.II(n4, n5, n2, n3, this.x[14], 15, -1416354905);
        n3 = MD5.II(n3, n4, n5, n2, this.x[5], 21, -57434055);
        n2 = MD5.II(n2, n3, n4, n5, this.x[12], 6, 1700485571);
        n5 = MD5.II(n5, n2, n3, n4, this.x[3], 10, -1894986606);
        n4 = MD5.II(n4, n5, n2, n3, this.x[10], 15, -1051523);
        n3 = MD5.II(n3, n4, n5, n2, this.x[1], 21, -2054922799);
        n2 = MD5.II(n2, n3, n4, n5, this.x[8], 6, 1873313359);
        n5 = MD5.II(n5, n2, n3, n4, this.x[15], 10, -30611744);
        n4 = MD5.II(n4, n5, n2, n3, this.x[6], 15, -1560198380);
        n3 = MD5.II(n3, n4, n5, n2, this.x[13], 21, 1309151649);
        n2 = MD5.II(n2, n3, n4, n5, this.x[4], 6, -145523070);
        n5 = MD5.II(n5, n2, n3, n4, this.x[11], 10, -1120210379);
        n4 = MD5.II(n4, n5, n2, n3, this.x[2], 15, 718787259);
        n3 = MD5.II(n3, n4, n5, n2, this.x[9], 21, -343485551);
        this.state0 += n2;
        this.state1 += n3;
        this.state2 += n4;
        this.state3 += n5;
    }

    public final void reset() {
        this.count = 0L;
        this.state0 = 1732584193;
        this.state1 = -271733879;
        this.state2 = -1732584194;
        this.state3 = 271733878;
        for (int i = 0; i < 16; ++i) {
            this.x[i] = 0;
        }
    }

    public final void update(byte by) {
        int n = 64 - (int)(this.count & 0x3FL);
        ++this.count;
        this.block[64 - n] = by;
        if (n == 1) {
            this.transform(this.block, 0);
        }
    }

    public final void update(byte[] byArray, int n, int n2) {
        int n3 = 64 - (int)(this.count & 0x3FL);
        this.count += (long)n2;
        while (n2 > 0) {
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.block, 64 - n3, n2);
                break;
            }
            if (n3 == 64) {
                this.transform(byArray, n);
            } else {
                System.arraycopy(byArray, n, this.block, 64 - n3, n3);
                this.transform(this.block, 0);
            }
            n += n3;
            n2 -= n3;
            n3 = 64;
        }
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void digest(byte[] byArray, int n) {
        byte[] byArray2 = new byte[8];
        MD5.encode(byArray2, 0, (int)(this.count << 3));
        MD5.encode(byArray2, 4, (int)(this.count >> 29));
        int n2 = (int)this.count & 0x3F;
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        this.update(padding, 0, n3);
        this.update(byArray2, 0, 8);
        MD5.encode(byArray, n, this.state0);
        MD5.encode(byArray, n + 4, this.state1);
        MD5.encode(byArray, n + 8, this.state2);
        MD5.encode(byArray, n + 12, this.state3);
        this.reset();
    }

    public final void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public final int getDigestLength() {
        return 16;
    }
}

