/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public final class SHA1
implements Digest {
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private final int[] w = new int[80];
    private int currentPos;
    private long currentLen;

    public SHA1() {
        this.reset();
    }

    public final int getDigestLength() {
        return 20;
    }

    public final void reset() {
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.currentPos = 0;
        this.currentLen = 0L;
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 >= 4) {
            n3 = this.currentPos >> 2;
            switch (this.currentPos & 3) {
                case 0: {
                    this.w[n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    n2 -= 4;
                    this.currentPos += 4;
                    this.currentLen += 32L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 1: {
                    this.w[n3] = this.w[n3] << 24 | ((byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    n2 -= 3;
                    this.currentPos += 3;
                    this.currentLen += 24L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 2: {
                    this.w[n3] = this.w[n3] << 16 | ((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    n2 -= 2;
                    this.currentPos += 2;
                    this.currentLen += 16L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 3: {
                    this.w[n3] = this.w[n3] << 8 | byArray[n++] & 0xFF;
                    --n2;
                    ++this.currentPos;
                    this.currentLen += 8L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                }
            }
            while (n2 >= 8) {
                this.w[this.currentPos >> 2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                this.currentPos += 4;
                if (this.currentPos == 64) {
                    this.perform();
                    this.currentPos = 0;
                }
                this.w[this.currentPos >> 2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                this.currentPos += 4;
                if (this.currentPos == 64) {
                    this.perform();
                    this.currentPos = 0;
                }
                this.currentLen += 64L;
                n2 -= 8;
            }
            while (n2 < 0) {
                this.w[this.currentPos >> 2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                n2 -= 4;
                this.currentPos += 4;
                this.currentLen += 32L;
                if (this.currentPos != 64) continue;
                this.perform();
                this.currentPos = 0;
            }
        }
        while (n2 > 0) {
            n3 = this.currentPos >> 2;
            this.w[n3] = this.w[n3] << 8 | byArray[n++] & 0xFF;
            this.currentLen += 8L;
            ++this.currentPos;
            if (this.currentPos == 64) {
                this.perform();
                this.currentPos = 0;
            }
            --n2;
        }
    }

    public final void update(byte by) {
        int n = this.currentPos >> 2;
        this.w[n] = this.w[n] << 8 | by & 0xFF;
        this.currentLen += 8L;
        ++this.currentPos;
        if (this.currentPos == 64) {
            this.perform();
            this.currentPos = 0;
        }
    }

    private final void putInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public final void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public final void digest(byte[] byArray, int n) {
        int n2 = this.currentPos >> 2;
        this.w[n2] = (this.w[n2] << 8 | 0x80) << (3 - (this.currentPos & 3) << 3);
        this.currentPos = (this.currentPos & 0xFFFFFFFC) + 4;
        if (this.currentPos == 64) {
            this.currentPos = 0;
            this.perform();
        } else if (this.currentPos == 60) {
            this.currentPos = 0;
            this.w[15] = 0;
            this.perform();
        }
        for (int i = this.currentPos >> 2; i < 14; ++i) {
            this.w[i] = 0;
        }
        this.w[14] = (int)(this.currentLen >> 32);
        this.w[15] = (int)this.currentLen;
        this.perform();
        this.putInt(byArray, n, this.H0);
        this.putInt(byArray, n + 4, this.H1);
        this.putInt(byArray, n + 8, this.H2);
        this.putInt(byArray, n + 12, this.H3);
        this.putInt(byArray, n + 16, this.H4);
        this.reset();
    }

    private final void perform() {
        int n;
        int n2;
        for (n2 = 16; n2 < 80; ++n2) {
            n = this.w[n2 - 3] ^ this.w[n2 - 8] ^ this.w[n2 - 14] ^ this.w[n2 - 16];
            this.w[n2] = n << 1 | n >>> 31;
        }
        n2 = this.H0;
        n = this.H1;
        int n3 = this.H2;
        int n4 = this.H3;
        int n5 = this.H4;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | ~n & n4) + this.w[0] + 1518500249;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | ~n2 & n3) + this.w[1] + 1518500249;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | ~n5 & n) + this.w[2] + 1518500249;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n2) + this.w[3] + 1518500249;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | ~n3 & n5) + this.w[4] + 1518500249;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | ~n & n4) + this.w[5] + 1518500249;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | ~n2 & n3) + this.w[6] + 1518500249;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | ~n5 & n) + this.w[7] + 1518500249;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n2) + this.w[8] + 1518500249;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | ~n3 & n5) + this.w[9] + 1518500249;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | ~n & n4) + this.w[10] + 1518500249;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | ~n2 & n3) + this.w[11] + 1518500249;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | ~n5 & n) + this.w[12] + 1518500249;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n2) + this.w[13] + 1518500249;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | ~n3 & n5) + this.w[14] + 1518500249;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | ~n & n4) + this.w[15] + 1518500249;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | ~n2 & n3) + this.w[16] + 1518500249;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | ~n5 & n) + this.w[17] + 1518500249;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n2) + this.w[18] + 1518500249;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | ~n3 & n5) + this.w[19] + 1518500249;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[20] + 1859775393;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[21] + 1859775393;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[22] + 1859775393;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[23] + 1859775393;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[24] + 1859775393;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[25] + 1859775393;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[26] + 1859775393;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[27] + 1859775393;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[28] + 1859775393;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[29] + 1859775393;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[30] + 1859775393;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[31] + 1859775393;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[32] + 1859775393;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[33] + 1859775393;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[34] + 1859775393;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[35] + 1859775393;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[36] + 1859775393;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[37] + 1859775393;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[38] + 1859775393;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[39] + 1859775393;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | n & n4 | n3 & n4) + this.w[40] + -1894007588;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | n2 & n3 | n & n3) + this.w[41] + -1894007588;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | n5 & n | n2 & n) + this.w[42] + -1894007588;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n2 | n5 & n2) + this.w[43] + -1894007588;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | n3 & n5 | n4 & n5) + this.w[44] + -1894007588;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | n & n4 | n3 & n4) + this.w[45] + -1894007588;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | n2 & n3 | n & n3) + this.w[46] + -1894007588;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | n5 & n | n2 & n) + this.w[47] + -1894007588;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n2 | n5 & n2) + this.w[48] + -1894007588;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | n3 & n5 | n4 & n5) + this.w[49] + -1894007588;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n & n3 | n & n4 | n3 & n4) + this.w[50] + -1894007588;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | n2 & n3 | n & n3) + this.w[51] + -1894007588;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | n5 & n | n2 & n) + this.w[52] + -1894007588;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n2 | n5 & n2) + this.w[53] + -1894007588;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | n3 & n5 | n4 & n5) + this.w[54] + -1894007588;
        n3 = n3 << 30 | n3 >>> 2;
        n5 = n5 + (n2 << 5 | n2 >>> 27) + (n & n3 | n & n4 | n3 & n4) + this.w[55] + -1894007588;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 & n | n2 & n3 | n & n3) + this.w[56] + -1894007588;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 & n2 | n5 & n | n2 & n) + this.w[57] + -1894007588;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n2 | n5 & n2) + this.w[58] + -1894007588;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 & n4 | n3 & n5 | n4 & n5) + this.w[59] + -1894007588;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[60] + -899497514;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[61] + -899497514;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[62] + -899497514;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[63] + -899497514;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[64] + -899497514;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[65] + -899497514;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[66] + -899497514;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[67] + -899497514;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[68] + -899497514;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[69] + -899497514;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[70] + -899497514;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[71] + -899497514;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[72] + -899497514;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[73] + -899497514;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[74] + -899497514;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n2 << 5 | n2 >>> 27) + (n ^ n3 ^ n4) + this.w[75] + -899497514;
        n = n << 30 | n >>> 2;
        n4 += (n5 << 5 | n5 >>> 27) + (n2 ^ n ^ n3) + this.w[76] + -899497514;
        n2 = n2 << 30 | n2 >>> 2;
        n3 += (n4 << 5 | n4 >>> 27) + (n5 ^ n2 ^ n) + this.w[77] + -899497514;
        n5 = n5 << 30 | n5 >>> 2;
        n += (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n2) + this.w[78] + -899497514;
        n4 = n4 << 30 | n4 >>> 2;
        n2 += (n << 5 | n >>> 27) + (n3 ^ n4 ^ n5) + this.w[79] + -899497514;
        n3 = n3 << 30 | n3 >>> 2;
        this.H0 += n2;
        this.H1 += n;
        this.H2 += n3;
        this.H3 += n4;
        this.H4 += n5;
    }

    private static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        sHA1.update("abc".getBytes());
        sHA1.digest(byArray);
        sHA1.update("abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq".getBytes());
        sHA1.digest(byArray2);
        for (int i = 0; i < 1000000; ++i) {
            sHA1.update((byte)97);
        }
        sHA1.digest(byArray3);
        String string = SHA1.toHexString(byArray);
        String string2 = SHA1.toHexString(byArray2);
        String string3 = SHA1.toHexString(byArray3);
        String string4 = "A9993E364706816ABA3E25717850C26C9CD0D89D";
        String string5 = "84983E441C3BD26EBAAE4AA1F95129E5E54670F1";
        String string6 = "34AA973CD4C4DAA4F61EEB2BDBAD27316534016F";
        if (string.equals(string4)) {
            System.out.println("SHA-1 Test 1 OK.");
        } else {
            System.out.println("SHA-1 Test 1 FAILED.");
        }
        if (string2.equals(string5)) {
            System.out.println("SHA-1 Test 2 OK.");
        } else {
            System.out.println("SHA-1 Test 2 FAILED.");
        }
        if (string3.equals(string6)) {
            System.out.println("SHA-1 Test 3 OK.");
        } else {
            System.out.println("SHA-1 Test 3 FAILED.");
        }
        if (string3.equals(string6)) {
            System.out.println("SHA-1 Test 3 OK.");
        } else {
            System.out.println("SHA-1 Test 3 FAILED.");
        }
    }
}

