/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketUserauthBanner {
    byte[] payload;
    String message;
    String language;

    public PacketUserauthBanner(String string, String string2) {
        this.message = string;
        this.language = string2;
    }

    public String getBanner() {
        return this.message;
    }

    public PacketUserauthBanner(byte[] byArray, int n, int n2) throws IOException {
        this.payload = new byte[n2];
        System.arraycopy(byArray, n, this.payload, 0, n2);
        TypesReader typesReader = new TypesReader(byArray, n, n2);
        int n3 = typesReader.readByte();
        if (n3 != 53) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_BANNER! (" + n3 + ")");
        }
        this.message = typesReader.readString("UTF-8");
        this.language = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_USERAUTH_REQUEST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(53);
            typesWriter.writeString(this.message);
            typesWriter.writeString(this.language);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

