/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.util.StringEncoder;
import ch.ethz.ssh2.util.Tokenizer;
import java.io.IOException;
import java.math.BigInteger;

public class TypesReader {
    byte[] arr;
    int pos = 0;
    int max = 0;

    public TypesReader(byte[] byArray) {
        this.arr = byArray;
        this.pos = 0;
        this.max = byArray.length;
    }

    public TypesReader(byte[] byArray, int n) {
        this.arr = byArray;
        this.pos = n;
        this.max = byArray.length;
        if (this.pos < 0 || this.pos > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
    }

    public TypesReader(byte[] byArray, int n, int n2) {
        this.arr = byArray;
        this.pos = n;
        this.max = n + n2;
        if (this.pos < 0 || this.pos > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
        if (this.max < 0 || this.max > byArray.length) {
            throw new IllegalArgumentException("Illegal length.");
        }
    }

    public int readByte() throws IOException {
        if (this.pos >= this.max) {
            throw new IOException("Packet too short.");
        }
        return this.arr[this.pos++] & 0xFF;
    }

    public byte[] readBytes(int n) throws IOException {
        if (this.pos + n > this.max) {
            throw new IOException("Packet too short.");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.arr, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos + n2 > this.max) {
            throw new IOException("Packet too short.");
        }
        System.arraycopy(this.arr, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public boolean readBoolean() throws IOException {
        if (this.pos >= this.max) {
            throw new IOException("Packet too short.");
        }
        return this.arr[this.pos++] != 0;
    }

    public int readUINT32() throws IOException {
        if (this.pos + 4 > this.max) {
            throw new IOException("Packet too short.");
        }
        return (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
    }

    public long readUINT64() throws IOException {
        if (this.pos + 8 > this.max) {
            throw new IOException("Packet too short.");
        }
        long l = (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
        long l2 = (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public BigInteger readMPINT() throws IOException {
        byte[] byArray = this.readByteString();
        BigInteger bigInteger = byArray.length == 0 ? BigInteger.ZERO : new BigInteger(byArray);
        return bigInteger;
    }

    public byte[] readByteString() throws IOException {
        int n = this.readUINT32();
        if (n + this.pos > this.max) {
            throw new IOException("Malformed SSH byte string.");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.arr, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    public String readString(String string) throws IOException {
        int n = this.readUINT32();
        if (n + this.pos > this.max) {
            throw new IOException("Malformed SSH string.");
        }
        String string2 = string == null ? new String(this.arr, this.pos, n) : new String(this.arr, this.pos, n, string);
        this.pos += n;
        return string2;
    }

    public String readString() throws IOException {
        int n = this.readUINT32();
        if (n + this.pos > this.max) {
            throw new IOException("Malformed SSH string.");
        }
        String string = StringEncoder.GetString(this.arr, this.pos, n);
        this.pos += n;
        return string;
    }

    public String[] readNameList() throws IOException {
        return Tokenizer.parseTokens(this.readString(), ',');
    }

    public int remain() {
        return this.max - this.pos;
    }
}

