/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.signature;

import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASHA1Verify {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$signature$DSASHA1Verify == null ? (class$ch$ethz$ssh2$signature$DSASHA1Verify = DSASHA1Verify.class$("ch.ethz.ssh2.signature.DSASHA1Verify")) : class$ch$ethz$ssh2$signature$DSASHA1Verify);
    static /* synthetic */ Class class$ch$ethz$ssh2$signature$DSASHA1Verify;

    public static DSAPublicKey decodeSSHDSAPublicKey(byte[] byArray) throws IOException {
        TypesReader typesReader = new TypesReader(byArray);
        String string = typesReader.readString();
        if (!string.equals("ssh-dss")) {
            throw new IllegalArgumentException("This is not a ssh-dss public key!");
        }
        BigInteger bigInteger = typesReader.readMPINT();
        BigInteger bigInteger2 = typesReader.readMPINT();
        BigInteger bigInteger3 = typesReader.readMPINT();
        BigInteger bigInteger4 = typesReader.readMPINT();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in DSA public key!");
        }
        return new DSAPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public static byte[] encodeSSHDSAPublicKey(DSAPublicKey dSAPublicKey) throws IOException {
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString("ssh-dss");
        typesWriter.writeMPInt(dSAPublicKey.getP());
        typesWriter.writeMPInt(dSAPublicKey.getQ());
        typesWriter.writeMPInt(dSAPublicKey.getG());
        typesWriter.writeMPInt(dSAPublicKey.getY());
        return typesWriter.getBytes();
    }

    public static byte[] encodeSSHDSASignature(DSASignature dSASignature) {
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString("ssh-dss");
        byte[] byArray = dSASignature.getR().toByteArray();
        byte[] byArray2 = dSASignature.getS().toByteArray();
        byte[] byArray3 = new byte[40];
        int n = byArray.length < 20 ? byArray.length : 20;
        int n2 = byArray2.length < 20 ? byArray2.length : 20;
        System.arraycopy(byArray, byArray.length - n, byArray3, 20 - n, n);
        System.arraycopy(byArray2, byArray2.length - n2, byArray3, 40 - n2, n2);
        typesWriter.writeString(byArray3, 0, 40);
        return typesWriter.getBytes();
    }

    public static DSASignature decodeSSHDSASignature(byte[] byArray) throws IOException {
        Object object;
        Object object2;
        byte[] byArray2;
        if (byArray.length == 40) {
            byArray2 = byArray;
        } else {
            object2 = new TypesReader(byArray);
            object = ((TypesReader)object2).readString();
            if (!((String)object).equals("ssh-dss")) {
                throw new IOException("Peer sent wrong signature format");
            }
            byArray2 = ((TypesReader)object2).readByteString();
            if (byArray2.length != 40) {
                throw new IOException("Peer sent corrupt signature");
            }
            if (((TypesReader)object2).remain() != 0) {
                throw new IOException("Padding in DSA signature!");
            }
        }
        object2 = new byte[20];
        System.arraycopy(byArray2, 0, object2, 0, 20);
        object = new BigInteger(1, (byte[])object2);
        System.arraycopy(byArray2, 20, object2, 0, 20);
        BigInteger bigInteger = new BigInteger(1, (byte[])object2);
        if (log.isEnabled()) {
            log.log(30, "decoded ssh-dss signature: first bytes r(" + (byArray2[0] & 0xFF) + "), s(" + (byArray2[20] & 0xFF) + ")");
        }
        return new DSASignature((BigInteger)object, bigInteger);
    }

    public static boolean verifySignature(byte[] byArray, DSASignature dSASignature, DSAPublicKey dSAPublicKey) throws IOException {
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray);
        byte[] byArray2 = new byte[sHA1.getDigestLength()];
        sHA1.digest(byArray2);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = dSASignature.getR();
        BigInteger bigInteger3 = dSASignature.getS();
        BigInteger bigInteger4 = dSAPublicKey.getG();
        BigInteger bigInteger5 = dSAPublicKey.getP();
        BigInteger bigInteger6 = dSAPublicKey.getQ();
        BigInteger bigInteger7 = dSAPublicKey.getY();
        BigInteger bigInteger8 = BigInteger.ZERO;
        if (log.isEnabled()) {
            log.log(60, "ssh-dss signature: m: " + bigInteger.toString(16));
            log.log(60, "ssh-dss signature: r: " + bigInteger2.toString(16));
            log.log(60, "ssh-dss signature: s: " + bigInteger3.toString(16));
            log.log(60, "ssh-dss signature: g: " + bigInteger4.toString(16));
            log.log(60, "ssh-dss signature: p: " + bigInteger5.toString(16));
            log.log(60, "ssh-dss signature: q: " + bigInteger6.toString(16));
            log.log(60, "ssh-dss signature: y: " + bigInteger7.toString(16));
        }
        if (bigInteger8.compareTo(bigInteger2) >= 0 || bigInteger6.compareTo(bigInteger2) <= 0) {
            log.log(20, "ssh-dss signature: zero.compareTo(r) >= 0 || q.compareTo(r) <= 0");
            return false;
        }
        if (bigInteger8.compareTo(bigInteger3) >= 0 || bigInteger6.compareTo(bigInteger3) <= 0) {
            log.log(20, "ssh-dss signature: zero.compareTo(s) >= 0 || q.compareTo(s) <= 0");
            return false;
        }
        BigInteger bigInteger9 = bigInteger3.modInverse(bigInteger6);
        BigInteger bigInteger10 = bigInteger.multiply(bigInteger9).mod(bigInteger6);
        BigInteger bigInteger11 = bigInteger2.multiply(bigInteger9).mod(bigInteger6);
        bigInteger10 = bigInteger4.modPow(bigInteger10, bigInteger5);
        bigInteger11 = bigInteger7.modPow(bigInteger11, bigInteger5);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11).mod(bigInteger5).mod(bigInteger6);
        return bigInteger12.equals(bigInteger2);
    }

    public static DSASignature generateSignature(byte[] byArray, DSAPrivateKey dSAPrivateKey, SecureRandom secureRandom) {
        BigInteger bigInteger;
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray);
        byte[] byArray2 = new byte[sHA1.getDigestLength()];
        sHA1.digest(byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        int n = dSAPrivateKey.getQ().bitLength();
        while ((bigInteger = new BigInteger(n, secureRandom)).compareTo(dSAPrivateKey.getQ()) >= 0) {
        }
        BigInteger bigInteger3 = dSAPrivateKey.getG().modPow(bigInteger, dSAPrivateKey.getP()).mod(dSAPrivateKey.getQ());
        bigInteger = bigInteger.modInverse(dSAPrivateKey.getQ()).multiply(bigInteger2.add(dSAPrivateKey.getX().multiply(bigInteger3)));
        BigInteger bigInteger4 = bigInteger.mod(dSAPrivateKey.getQ());
        return new DSASignature(bigInteger3, bigInteger4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

