/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.util;

import ch.ethz.ssh2.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;

public class TimeoutService {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$util$TimeoutService == null ? (class$ch$ethz$ssh2$util$TimeoutService = TimeoutService.class$("ch.ethz.ssh2.util.TimeoutService")) : class$ch$ethz$ssh2$util$TimeoutService);
    private static final LinkedList todolist = new LinkedList();
    private static Thread timeoutThread = null;
    static /* synthetic */ Class class$ch$ethz$ssh2$util$TimeoutService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TimeoutToken addTimeoutHandler(long l, Runnable runnable) {
        TimeoutToken timeoutToken = new TimeoutToken(l, runnable);
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.add(timeoutToken);
            Collections.sort(todolist);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            } else {
                timeoutThread = new TimeoutThread();
                timeoutThread.setDaemon(true);
                timeoutThread.start();
            }
        }
        return timeoutToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cancelTimeoutHandler(TimeoutToken timeoutToken) {
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.remove(timeoutToken);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        public void run() {
            LinkedList linkedList = todolist;
            synchronized (linkedList) {
                while (true) {
                    if (todolist.size() == 0) {
                        timeoutThread = null;
                        return;
                    }
                    long l = System.currentTimeMillis();
                    TimeoutToken timeoutToken = (TimeoutToken)todolist.getFirst();
                    if (timeoutToken.runTime > l) {
                        try {
                            todolist.wait(timeoutToken.runTime - l);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    todolist.removeFirst();
                    try {
                        timeoutToken.handler.run();
                    }
                    catch (Exception exception) {
                        StringWriter stringWriter = new StringWriter();
                        exception.printStackTrace(new PrintWriter(stringWriter));
                        log.log(20, "Exeception in Timeout handler:" + exception.getMessage() + "(" + stringWriter.toString() + ")");
                    }
                }
            }
        }
    }

    public static class TimeoutToken
    implements Comparable {
        private long runTime;
        private Runnable handler;

        private TimeoutToken(long l, Runnable runnable) {
            this.runTime = l;
            this.handler = runnable;
        }

        public int compareTo(Object object) {
            TimeoutToken timeoutToken = (TimeoutToken)object;
            if (this.runTime > timeoutToken.runTime) {
                return 1;
            }
            if (this.runTime == timeoutToken.runTime) {
                return 0;
            }
            return -1;
        }
    }
}

