/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.netconf;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.juniper.netconf.CommitException;
import net.juniper.netconf.LoadException;
import net.juniper.netconf.NetconfException;
import net.juniper.netconf.NetconfSession;
import net.juniper.netconf.XML;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Device {
    private String hostName;
    private String userName;
    private String password;
    private String helloRpc;
    private String pemKeyFile;
    private boolean connectionOpen;
    private boolean keyBasedAuthentication;
    private Connection NetconfConn;
    private int port;
    private int timeout;
    private DocumentBuilder builder;
    private NetconfSession defaultSession;

    public Device() throws ParserConfigurationException {
        this.keyBasedAuthentication = false;
        this.connectionOpen = false;
        this.helloRpc = this.defaultHelloRPC();
        this.port = 830;
        this.timeout = 5000;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    public Device(String string, String string2, String string3, String string4) throws NetconfException, ParserConfigurationException {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.pemKeyFile = string4;
        this.keyBasedAuthentication = string4 != null;
        this.connectionOpen = false;
        this.helloRpc = this.defaultHelloRPC();
        this.port = 830;
        this.timeout = 5000;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    public Device(String string, String string2, String string3, String string4, int n) throws NetconfException, ParserConfigurationException {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.pemKeyFile = string4;
        this.keyBasedAuthentication = string4 != null;
        this.connectionOpen = false;
        this.helloRpc = this.defaultHelloRPC();
        this.port = n;
        this.timeout = 5000;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    public Device(String string, String string2, String string3, String string4, ArrayList arrayList) throws NetconfException, ParserConfigurationException {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.pemKeyFile = string4;
        this.keyBasedAuthentication = string4 != null;
        this.connectionOpen = false;
        this.helloRpc = this.createHelloRPC(arrayList);
        this.port = 830;
        this.timeout = 5000;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    public Device(String string, String string2, String string3, String string4, int n, ArrayList arrayList) throws NetconfException, ParserConfigurationException {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.pemKeyFile = string4;
        this.keyBasedAuthentication = string4 != null;
        this.connectionOpen = false;
        this.helloRpc = this.createHelloRPC(arrayList);
        this.port = n;
        this.timeout = 5000;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    private String defaultHelloRPC() {
        ArrayList arrayList = this.getDefaultClientCapabilities();
        return this.createHelloRPC(arrayList);
    }

    private String createHelloRPC(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<hello>\n");
        stringBuffer.append("<capabilities>\n");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("<capability>" + string + "</capability>\n");
        }
        stringBuffer.append("</capabilities>\n");
        stringBuffer.append("</hello>\n");
        stringBuffer.append("]]>]]>\n");
        return stringBuffer.toString();
    }

    public void connect() throws NetconfException {
        if (this.hostName == null || this.userName == null || this.password == null && this.pemKeyFile == null) {
            throw new NetconfException("Login parameters of Device can't be null.");
        }
        this.defaultSession = this.createNetconfSession();
    }

    public void setTimeOut(int n) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change timeout on a live device.Close the device first.");
        }
        this.timeout = n;
    }

    public void setHostname(String string) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change hostname on a live device.Close the device first.");
        }
        this.hostName = string;
    }

    public void setUserName(String string) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change username on a live device.Close the device first.");
        }
        this.userName = string;
    }

    public void setPassword(String string) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change password on a live device.Close the device first.");
        }
        this.password = string;
    }

    public void setPemKeyFile(String string) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change private key on a live device.Close the device first.");
        }
        this.pemKeyFile = string;
        this.keyBasedAuthentication = true;
    }

    public void setCapabilities(ArrayList arrayList) throws NetconfException {
        if (arrayList == null) {
            throw new IllegalArgumentException("Client capabilities cannot be null");
        }
        if (this.connectionOpen) {
            throw new NetconfException("Can't change client capabilities on a live device.Close the device first.");
        }
        this.helloRpc = this.createHelloRPC(arrayList);
    }

    public void setPort(int n) throws NetconfException {
        if (this.connectionOpen) {
            throw new NetconfException("Can't change port number on a live device.Close the device first.");
        }
        this.port = n;
    }

    public String gethostName() {
        return this.hostName;
    }

    public NetconfSession createNetconfSession() throws NetconfException {
        NetconfSession netconfSession;
        if (!this.connectionOpen) {
            try {
                this.NetconfConn = new Connection(this.hostName, this.port);
                this.NetconfConn.connect(null, this.timeout, 0);
            }
            catch (Exception exception) {
                throw new NetconfException(exception.getMessage());
            }
            boolean bl = true;
            try {
                if (this.keyBasedAuthentication) {
                    File file = new File(this.pemKeyFile);
                    bl = this.NetconfConn.authenticateWithPublicKey(this.userName, file, this.password);
                } else {
                    bl = this.NetconfConn.authenticateWithPassword(this.userName, this.password);
                }
            }
            catch (IOException iOException) {
                throw new NetconfException("Authentication failed:" + iOException.getMessage());
            }
            if (!bl) {
                throw new NetconfException("Authentication failed.");
            }
            this.connectionOpen = true;
        }
        try {
            Session session = this.NetconfConn.openSession();
            session.startSubSystem("netconf");
            netconfSession = new NetconfSession(session, this.helloRpc, this.builder);
        }
        catch (IOException iOException) {
            throw new NetconfException("Failed to create Netconf session:" + iOException.getMessage());
        }
        return netconfSession;
    }

    public String reboot() throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.reboot();
    }

    public void close() {
        if (!this.connectionOpen) {
            return;
        }
        this.NetconfConn.close();
        this.connectionOpen = false;
    }

    public String runShellCommand(String string) throws IOException {
        if (!this.connectionOpen) {
            return "Could not find open connection.";
        }
        Session session = this.NetconfConn.openSession();
        session.execCommand(string);
        StreamGobbler streamGobbler = new StreamGobbler(session.getStdout());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(streamGobbler));
        String string2 = "";
        while (true) {
            String string3 = "";
            try {
                string3 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                throw new NetconfException(exception.getMessage());
            }
            if (string3 == null || string3.equals("")) break;
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    public BufferedReader runShellCommandRunning(String string) throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Could not find open connection");
        }
        Session session = this.NetconfConn.openSession();
        session.execCommand(string);
        StreamGobbler streamGobbler = new StreamGobbler(session.getStdout());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(streamGobbler));
        return bufferedReader;
    }

    public ArrayList getDefaultClientCapabilities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("urn:ietf:params:xml:ns:netconf:base:1.0");
        arrayList.add("urn:ietf:params:xml:ns:netconf:base:1.0#candidate");
        arrayList.add("urn:ietf:params:xml:ns:netconf:base:1.0#confirmed-commit");
        arrayList.add("urn:ietf:params:xml:ns:netconf:base:1.0#validate");
        arrayList.add("urn:ietf:params:xml:ns:netconf:base:1.0#url?protocol=http,ftp,file");
        return arrayList;
    }

    public XML executeRPC(String string) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPC(string);
    }

    public XML executeRPC(XML xML) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPC(xML);
    }

    public XML executeRPC(Document document) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPC(document);
    }

    public BufferedReader executeRPCRunning(String string) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPCRunning(string);
    }

    public BufferedReader executeRPCRunning(XML xML) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPCRunning(xML);
    }

    public BufferedReader executeRPCRunning(Document document) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.executeRPCRunning(document);
    }

    public String getSessionId() {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot get session ID, you need to establish a connection first.");
        }
        return this.defaultSession.getSessionId();
    }

    public boolean hasError() throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("No RPC executed yet, you need to establish a connection first.");
        }
        return this.defaultSession.hasError();
    }

    public boolean hasWarning() throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("No RPC executed yet, you need to establish a connection first.");
        }
        return this.defaultSession.hasWarning();
    }

    public boolean isOK() {
        if (this.defaultSession == null) {
            throw new IllegalStateException("No RPC executed yet, you need to establish a connection first.");
        }
        return this.defaultSession.isOK();
    }

    public boolean lockConfig() throws IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.lockConfig();
    }

    public boolean unlockConfig() throws IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.unlockConfig();
    }

    public void loadXMLConfiguration(String string, String string2) throws LoadException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadXMLConfiguration(string, string2);
    }

    public void loadTextConfiguration(String string, String string2) throws LoadException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadTextConfiguration(string, string2);
    }

    public void loadSetConfiguration(String string) throws LoadException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadSetConfiguration(string);
    }

    public void loadXMLFile(String string, String string2) throws LoadException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadXMLFile(string, string2);
    }

    public void loadTextFile(String string, String string2) throws LoadException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadTextFile(string, string2);
    }

    public void loadSetFile(String string) throws IOException, LoadException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.loadSetFile(string);
    }

    public void commit() throws CommitException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.commit();
    }

    public void commitConfirm(long l) throws CommitException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.commitConfirm(l);
    }

    public void commitThisConfiguration(String string, String string2) throws LoadException, CommitException, IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.commitThisConfiguration(string, string2);
    }

    public XML getCandidateConfig(String string) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.getCandidateConfig(string);
    }

    public XML getRunningConfig(String string) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.getRunningConfig(string);
    }

    public XML getCandidateConfig() throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.getCandidateConfig();
    }

    public XML getRunningConfig() throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.getRunningConfig();
    }

    public boolean validate() throws IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.validate();
    }

    public String runCliCommand(String string) throws IOException, SAXException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.runCliCommand(string);
    }

    public BufferedReader runCliCommandRunning(String string) throws SAXException, IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        return this.defaultSession.runCliCommandRunning(string);
    }

    public void openConfiguration(String string) throws IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.openConfiguration(string);
    }

    public void closeConfiguration() throws IOException {
        if (this.defaultSession == null) {
            throw new IllegalStateException("Cannot execute RPC, you need to establish a connection first.");
        }
        this.defaultSession.closeConfiguration();
    }

    public String getLastRPCReply() {
        return this.defaultSession.getLastRPCReply();
    }
}

