/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.netconf;

import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import net.juniper.netconf.CommitException;
import net.juniper.netconf.LoadException;
import net.juniper.netconf.NetconfException;
import net.juniper.netconf.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NetconfSession {
    private Session netconfSession;
    private String serverCapability;
    private InputStream stdout;
    private BufferedReader bufferReader;
    private String lastRpcReply;
    private DocumentBuilder builder;

    protected NetconfSession(Session session, String string, DocumentBuilder documentBuilder) throws NetconfException, IOException {
        this.netconfSession = session;
        this.builder = documentBuilder;
        this.stdout = new StreamGobbler(session.getStdout());
        this.bufferReader = new BufferedReader(new InputStreamReader(this.stdout));
        this.sendHello(string);
    }

    private XML convertToXML(String string) throws SAXException, IOException {
        Document document = this.builder.parse(new InputSource(new StringReader(string)));
        Element element = document.getDocumentElement();
        return new XML(element);
    }

    private void sendHello(String string) throws IOException {
        String string2;
        this.serverCapability = string2 = this.getRpcReply(string);
        this.lastRpcReply = string2;
    }

    private String getRpcReply(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.netconfSession.getStdin().write(byArray);
        String string2 = "";
        while (true) {
            String string3 = "";
            string3 = this.bufferReader.readLine();
            if (string3 == null || string3.equals("]]>]]>")) break;
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    private BufferedReader getRpcReplyRunning(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.netconfSession.getStdin().write(byArray);
        return this.bufferReader;
    }

    private void loadXMLConfiguration(String string, String string2, String string3) throws LoadException, IOException, SAXException {
        String string4;
        if (!(string2 = string2.trim()).startsWith("<configuration")) {
            string2 = "<configuration>" + string2 + "</configuration>";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<edit-config>");
        stringBuffer.append("<target>");
        stringBuffer.append("<" + string + "/>");
        stringBuffer.append("</target>");
        stringBuffer.append("<default-operation>");
        stringBuffer.append(string3);
        stringBuffer.append("</default-operation>");
        stringBuffer.append("<config>");
        stringBuffer.append(string2);
        stringBuffer.append("</config>");
        stringBuffer.append("</edit-config>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string4 = this.getRpcReply(stringBuffer.toString());
        if (this.hasError() || !this.isOK()) {
            throw new LoadException("Load operation returned error.");
        }
    }

    private void loadTextConfiguration(String string, String string2, String string3) throws LoadException, IOException, SAXException {
        String string4;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<edit-config>");
        stringBuffer.append("<target>");
        stringBuffer.append("<" + string + "/>");
        stringBuffer.append("</target>");
        stringBuffer.append("<default-operation>");
        stringBuffer.append(string3);
        stringBuffer.append("</default-operation>");
        stringBuffer.append("<config-text>");
        stringBuffer.append("<configuration-text>");
        stringBuffer.append(string2);
        stringBuffer.append("</configuration-text>");
        stringBuffer.append("</config-text>");
        stringBuffer.append("</edit-config>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string4 = this.getRpcReply(stringBuffer.toString());
        if (this.hasError() || !this.isOK()) {
            throw new LoadException("Load operation returned error");
        }
    }

    private String getConfig(String string, String string2) throws IOException {
        String string3;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<get-config>");
        stringBuffer.append("<source>");
        stringBuffer.append("<" + string + "/>");
        stringBuffer.append("</source>");
        stringBuffer.append("<filter type=\"subtree\">");
        stringBuffer.append(string2);
        stringBuffer.append("</filter>");
        stringBuffer.append("</get-config>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string3 = this.getRpcReply(stringBuffer.toString());
        return this.lastRpcReply;
    }

    private String readFile(String string) throws FileNotFoundException, IOException {
        String string2 = "";
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        string2 = new String(byArray);
        return string2;
    }

    public String getServerCapability() {
        return this.serverCapability;
    }

    public XML executeRPC(String string) throws SAXException, IOException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Null RPC");
        }
        if (!(string = string.trim()).startsWith("<rpc>") && !string.equals("<rpc/>")) {
            string = string.startsWith("<") ? "<rpc>" + string + "</rpc>" : "<rpc><" + string + "/>" + "</rpc>";
        }
        string = string + "]]>]]>";
        this.lastRpcReply = string2 = this.getRpcReply(string);
        return this.convertToXML(string2);
    }

    public XML executeRPC(XML xML) throws SAXException, IOException {
        return this.executeRPC(xML.toString());
    }

    public XML executeRPC(Document document) throws SAXException, IOException {
        Element element = document.getDocumentElement();
        XML xML = new XML(element);
        return this.executeRPC(xML);
    }

    public BufferedReader executeRPCRunning(String string) throws IOException, SAXException {
        if (string == null) {
            throw new IllegalArgumentException("Null RPC");
        }
        if (!(string = string.trim()).startsWith("<rpc>") && !string.equals("<rpc/>")) {
            string = string.startsWith("<") ? "<rpc>" + string + "</rpc>" : "<rpc><" + string + "/>" + "</rpc>";
        }
        string = string + "]]>]]>";
        return this.getRpcReplyRunning(string);
    }

    public BufferedReader executeRPCRunning(XML xML) throws IOException, SAXException {
        return this.executeRPCRunning(xML.toString());
    }

    public BufferedReader executeRPCRunning(Document document) throws IOException, SAXException {
        Element element = document.getDocumentElement();
        XML xML = new XML(element);
        return this.executeRPCRunning(xML);
    }

    public String getSessionId() {
        String[] stringArray = this.serverCapability.split("<session-id>");
        if (stringArray.length != 2) {
            return null;
        }
        String[] stringArray2 = stringArray[1].split("</session-id>");
        if (stringArray2.length != 2) {
            return null;
        }
        return stringArray2[0];
    }

    public void close() throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<close-session/>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        this.netconfSession.close();
    }

    public boolean hasError() throws SAXException, IOException {
        if (this.lastRpcReply == null || this.lastRpcReply.indexOf("<rpc-error>") < 0) {
            return false;
        }
        XML xML = this.convertToXML(this.lastRpcReply);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rpc-error");
        arrayList.add("error-severity");
        String string = xML.findValue(arrayList);
        return string != null && string.equals("error");
    }

    public boolean hasWarning() throws SAXException, IOException {
        if (this.lastRpcReply == null || this.lastRpcReply.indexOf("<rpc-error>") < 0) {
            return false;
        }
        XML xML = this.convertToXML(this.lastRpcReply);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rpc-error");
        arrayList.add("error-severity");
        String string = xML.findValue(arrayList);
        return string != null && string.equals("warning");
    }

    public boolean isOK() {
        return this.lastRpcReply != null && this.lastRpcReply.indexOf("<ok/>") >= 0;
    }

    public boolean lockConfig() throws IOException, SAXException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<lock>");
        stringBuffer.append("<target>");
        stringBuffer.append("<candidate/>");
        stringBuffer.append("</target>");
        stringBuffer.append("</lock>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        return !this.hasError() && this.isOK();
    }

    public boolean unlockConfig() throws IOException, SAXException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<unlock>");
        stringBuffer.append("<target>");
        stringBuffer.append("<candidate/>");
        stringBuffer.append("</target>");
        stringBuffer.append("</unlock>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        return !this.hasError() && this.isOK();
    }

    public void loadXMLConfiguration(String string, String string2) throws LoadException, IOException, SAXException {
        if (string2 == null || !string2.equals("merge") && !string2.equals("replace")) {
            throw new IllegalArgumentException("'loadType' argument must be merge|replace");
        }
        this.loadXMLConfiguration("candidate", string, string2);
    }

    public void loadTextConfiguration(String string, String string2) throws LoadException, IOException, SAXException {
        if (string2 == null || !string2.equals("merge") && !string2.equals("replace")) {
            throw new IllegalArgumentException("'loadType' argument must be merge|replace");
        }
        this.loadTextConfiguration("candidate", string, string2);
    }

    public void loadSetConfiguration(String string) throws LoadException, IOException, SAXException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<load-configuration action=\"set\">");
        stringBuffer.append("<configuration-set>");
        stringBuffer.append(string);
        stringBuffer.append("</configuration-set>");
        stringBuffer.append("</load-configuration>");
        stringBuffer.append("</rpc>");
        this.lastRpcReply = string2 = this.getRpcReply(stringBuffer.toString());
        if (this.hasError() || !this.isOK()) {
            throw new LoadException("Load operation returned error");
        }
    }

    public void loadXMLFile(String string, String string2) throws LoadException, IOException, SAXException {
        String string3 = "";
        try {
            string3 = this.readFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("The system cannot find the configuration file specified: " + string);
        }
        if (string2 == null || !string2.equals("merge") && !string2.equals("replace")) {
            throw new IllegalArgumentException("'loadType' argument must be merge|replace");
        }
        this.loadXMLConfiguration(string3, string2);
    }

    public void loadTextFile(String string, String string2) throws LoadException, IOException, SAXException {
        String string3 = "";
        try {
            string3 = this.readFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("The system cannot find the configuration file specified: " + string);
        }
        if (string2 == null || !string2.equals("merge") && !string2.equals("replace")) {
            throw new IllegalArgumentException("'loadType' argument must be merge|replace");
        }
        this.loadTextConfiguration(string3, string2);
    }

    public void loadSetFile(String string) throws IOException, LoadException, SAXException {
        String string2 = "";
        try {
            string2 = this.readFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("The system cannot find the configuration file specified: " + string);
        }
        this.loadSetConfiguration(string2);
    }

    public void commitThisConfiguration(String string, String string2) throws LoadException, CommitException, IOException, SAXException {
        String string3 = "";
        try {
            string3 = this.readFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("The system cannot find the configuration file specified: " + string);
        }
        string3 = string3.trim();
        if (this.lockConfig()) {
            if (string3.startsWith("<")) {
                this.loadXMLConfiguration(string3, string2);
            } else if (string3.startsWith("set")) {
                this.loadSetConfiguration(string3);
            } else {
                this.loadTextConfiguration(string3, string2);
            }
        } else {
            throw new IOException("Unclean lock operation. Cannot proceed further.");
        }
        this.commit();
        this.unlockConfig();
    }

    public void commit() throws CommitException, IOException, SAXException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<commit/>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        if (this.hasError() || !this.isOK()) {
            throw new CommitException("Commit operation returned error.");
        }
    }

    public void commitConfirm(long l) throws CommitException, IOException, SAXException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<commit>");
        stringBuffer.append("<confirmed/>");
        stringBuffer.append("<confirm-timeout>" + l + "</confirm-timeout>");
        stringBuffer.append("</commit>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        if (this.hasError() || !this.isOK()) {
            throw new CommitException("Commit operation returned error.");
        }
    }

    public XML getCandidateConfig(String string) throws SAXException, IOException {
        return this.convertToXML(this.getConfig("candidate", string));
    }

    public XML getRunningConfig(String string) throws SAXException, IOException {
        return this.convertToXML(this.getConfig("running", string));
    }

    public XML getCandidateConfig() throws SAXException, IOException {
        return this.convertToXML(this.getConfig("candidate", "<configuration></configuration>"));
    }

    public XML getRunningConfig() throws SAXException, IOException {
        return this.convertToXML(this.getConfig("running", "<configuration></configuration>"));
    }

    public boolean validate() throws IOException, SAXException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<validate>");
        stringBuffer.append("<source>");
        stringBuffer.append("<candidate/>");
        stringBuffer.append("</source>");
        stringBuffer.append("</validate>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
        return !this.hasError() && this.isOK();
    }

    public String reboot() throws SAXException, IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<request-reboot/>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        String string = this.getRpcReply(stringBuffer.toString());
        return string;
    }

    public String runCliCommand(String string) throws IOException, SAXException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<command format=\"text\">");
        stringBuffer.append(string);
        stringBuffer.append("</command>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string2 = this.getRpcReply(stringBuffer.toString());
        XML xML = this.convertToXML(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("output");
        String string3 = xML.findValue(arrayList);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public BufferedReader runCliCommandRunning(String string) throws SAXException, IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<command format=\"text\">");
        stringBuffer.append(string);
        stringBuffer.append("</command>");
        BufferedReader bufferedReader = this.executeRPCRunning(stringBuffer.toString());
        return bufferedReader;
    }

    public void openConfiguration(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<open-configuration>");
        stringBuffer.append(string);
        stringBuffer.append("</open-configuration>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string2 = this.getRpcReply(stringBuffer.toString());
    }

    public void closeConfiguration() throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<rpc>");
        stringBuffer.append("<close-configuration/>");
        stringBuffer.append("</rpc>");
        stringBuffer.append("]]>]]>");
        this.lastRpcReply = string = this.getRpcReply(stringBuffer.toString());
    }

    public String getLastRPCReply() {
        return this.lastRpcReply;
    }
}

