/*
 * Decompiled with CFR 0.152.
 */
package net.juniper.netconf;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XML {
    private Element activeElement;
    private Document ownerDoc;

    protected XML(Element element) {
        this.activeElement = element;
        this.ownerDoc = element.getOwnerDocument();
    }

    private String trim(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\n")) {
            string2 = string2.substring(string2.indexOf("\n") + 1);
        }
        if (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.lastIndexOf("\n"));
        }
        return string2;
    }

    public Document getOwnerDocument() {
        return this.ownerDoc;
    }

    public XML append(String string) {
        Element element = this.ownerDoc.createElement(string);
        this.activeElement.appendChild(element);
        return new XML(element);
    }

    public XML append(String string, String string2) {
        Element element = this.ownerDoc.createElement(string);
        Text text = this.ownerDoc.createTextNode(string2);
        element.appendChild(text);
        this.activeElement.appendChild(element);
        return new XML(element);
    }

    public void append(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Element element = this.ownerDoc.createElement(string);
            Text text = this.ownerDoc.createTextNode(stringArray[i]);
            element.appendChild(text);
            this.activeElement.appendChild(element);
        }
    }

    public void append(HashMap hashMap) {
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            String string = (String)e;
            String string2 = (String)hashMap.get(e);
            this.append(string, string2);
        }
    }

    public XML append(String string, HashMap hashMap) {
        Element element = this.ownerDoc.createElement(string);
        this.activeElement.appendChild(element);
        XML xML = new XML(element);
        xML.append(hashMap);
        return xML;
    }

    public void addSibling(String string) {
        Element element = this.ownerDoc.createElement(string);
        Node node = this.activeElement.getParentNode();
        node.appendChild(element);
    }

    public void addSibling(String string, String string2) {
        Element element = this.ownerDoc.createElement(string);
        Text text = this.ownerDoc.createTextNode(string2);
        element.appendChild(text);
        Node node = this.activeElement.getParentNode();
        node.appendChild(element);
    }

    public void addSiblings(String string, String[] stringArray) {
        Node node = this.activeElement.getParentNode();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element = this.ownerDoc.createElement(string);
            Text text = this.ownerDoc.createTextNode(stringArray[i]);
            element.appendChild(text);
            node.appendChild(element);
        }
    }

    public void addSiblings(HashMap hashMap) {
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Node node = this.activeElement.getParentNode();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            String string = (String)e;
            String string2 = (String)hashMap.get(e);
            this.append(string, string2);
        }
    }

    public XML addPath(String string) {
        String[] stringArray = string.split("/");
        Element element = null;
        for (int i = 0; i < stringArray.length; ++i) {
            element = this.ownerDoc.createElement(stringArray[i]);
            this.activeElement.appendChild(element);
        }
        return new XML(element);
    }

    public void setAttribute(String string, String string2) {
        this.activeElement.setAttribute(string, string2);
    }

    public void setText(String string) throws ParserConfigurationException {
        Node node = this.activeElement.getFirstChild();
        if (node == null || node.getNodeType() != 3) {
            Text text = this.ownerDoc.createTextNode(string);
            this.activeElement.appendChild(text);
        } else {
            node.setNodeValue(string);
        }
    }

    public void junosDelete() {
        this.activeElement.setAttribute("delete", "delete");
    }

    public void junosActivate() {
        this.activeElement.setAttribute("active", "active");
    }

    public void junosDeactivate() {
        this.activeElement.setAttribute("inactive", "inactive");
    }

    public void junosRename(String string, String string2) {
        this.activeElement.setAttribute("rename", string);
        this.activeElement.setAttribute("name", string2);
    }

    public void junosInsert(String string, String string2) {
        this.activeElement.setAttribute("insert", string);
        this.activeElement.setAttribute("name", string2);
    }

    public String findValue(List list) {
        Element element;
        Element element2 = element = this.ownerDoc.getDocumentElement();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            bl = false;
            String string = (String)list.get(i);
            if (string.indexOf("~") >= 0) continue;
            try {
                NodeList nodeList = element2.getElementsByTagName(string);
                String string2 = null;
                if (i < list.size() - 1) {
                    string2 = (String)list.get(i + 1);
                }
                if (string2 != null && string2.indexOf("~") >= 0) {
                    String string3 = string2.substring(string2.indexOf("~") + 1);
                    String string4 = string2.substring(0, string2.indexOf("~"));
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        element2 = (Element)nodeList.item(j);
                        Element element3 = (Element)element2.getElementsByTagName(string4).item(0);
                        String string5 = element3.getFirstChild().getNodeValue();
                        if ((string5 = this.trim(string5)) == null || !string5.equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return null;
                }
                element2 = (Element)nodeList.item(0);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        if (element2 == null) {
            return null;
        }
        String string = element2.getFirstChild().getNodeValue();
        if (string == null) {
            return null;
        }
        return this.trim(string);
    }

    public List findNodes(List list) {
        Object object;
        Object object2;
        String string;
        Element element;
        Element element2 = element = this.ownerDoc.getDocumentElement();
        boolean bl = false;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            bl = false;
            string = (String)list.get(i);
            if (string.indexOf("~") >= 0) continue;
            try {
                object2 = element2.getElementsByTagName(string);
                object = null;
                if (i < list.size() - 1) {
                    object = (String)list.get(i + 1);
                }
                if (object != null && ((String)object).indexOf("~") >= 0) {
                    String string2 = ((String)object).substring(((String)object).indexOf("~") + 1);
                    String string3 = ((String)object).substring(0, ((String)object).indexOf("~"));
                    for (int j = 0; j < object2.getLength(); ++j) {
                        element2 = (Element)object2.item(j);
                        Element element3 = (Element)element2.getElementsByTagName(string3).item(0);
                        String string4 = element3.getFirstChild().getNodeValue();
                        if ((string4 = this.trim(string4)) == null || !string4.equals(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return null;
                }
                element2 = (Element)object2.item(0);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        if (element2 == null) {
            return null;
        }
        String string5 = element2.getNodeName();
        string = (String)list.get(list.size() - 1);
        if (string.indexOf("~") >= 0) {
            arrayList.add(element2);
            return arrayList;
        }
        object2 = (Element)element2.getParentNode();
        object = object2.getElementsByTagName(string5);
        for (int i = 0; i < object.getLength(); ++i) {
            arrayList.add(object.item(i));
        }
        return arrayList;
    }

    public String toString() {
        String string = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            Element element = this.ownerDoc.getDocumentElement();
            transformer.transform(new DOMSource(element), new StreamResult(stringWriter));
            string = stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            string = "Could not transform: Transformer exception";
        }
        return string;
    }
}

