(upgrade_osversion
	:transitions (
		# the rule allows for 5.0IDP -> 5.4 transition of isg devices
		: ("5.0IDP1"
			: ("5.1"
				:allow-unsupported-platforms (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		# this is the 5.3TMAV -> 5.4 transition
		: ("5.3TMAV"
			: ("5.4")
		)
		# the next 3 rules allow for the 5.1SSG -> 5.4 transition of SSG devices.
		# no need to specify exceptions because 5.2 & 5.3 will not support ssg devices
		: ("5.1SSG"
			: ("5.2"
				:allow-unsupported-platforms (
					: ("SSG520")
					: ("SSG550")				
				)
			)
		)
		: ("5.2"
			: ("5.3"
				:allow-unsupported-platforms (
					: ("SSG520")
					: ("SSG550")				
				)
			)
		)
		: ("5.3"
			: ("5.3TMAV"
				:allow-unsupported-platforms (
					: ("SSG520")
					: ("SSG550")				
				)
			)
		)		
	)
	:major_exceptions (
		# only allow from 5.0IDP1 -> 5.4
		: ("5.0IDP1"
			: ("5.1")
			: ("5.2")
			: ("5.3")
			: ("5.3TMAV")					
		)	
		: ("5.0"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.01483"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)   
		: ("5.0ADSL"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0DSLW"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0FIPS"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0GPRS"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0L2V"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0NSGP"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		: ("5.0WLAN"
			: ("5.4"
				:platform_exceptions (
					: ("nsISG2000")
					: ("nsISG1000")
				)
			)
		)
		:minor_exceptions (
			# list minor release src->dcf dst pairs which are not allowed
			: ("5\.0\.0r[1-9]\.[^~]*"
				: ("5.4")
			)
			: ("5\.0\.0r[1-9]\..*~adsl"
				: ("5.4")
			)
			: ("5\.0\.0r[1-9]\..*~dslw"
				: ("5.4")
			)
			: ("5\.0\.0r[1-9]\..*~gprs"
				: ("5.4")
			)
			: ("5\.0\.0r[1-9]\..*~nsgp"
				: ("5.4")
			)
			: ("5\.0\.0r[1-9]\..*~wlan"
				: ("5.4")
			)
		)
	)
)
