#!/bin/sh

nsdir='/usr/netscreen/'
zd='/var/be/dm/0-day/patches'
var='/var'
gtarget=${nsdir}'GuiSvr'
dtarget=${nsdir}'DevSvr'
ANSWER="n"
SHARED_DISK="n"
loginid=`who am i | cut -d" " -f1`
if [ -d /usr/netscreen/GuiSvr ]; then
	gui_user=`grep setuid /usr/netscreen/GuiSvr/var/guiSvr.cfg | awk -F" " '{ print $2 }'`
fi
if [ -d /usr/netscreen/DevSvr ]; then
	dev_user=`grep setuid /usr/netscreen/DevSvr/var/devSvr.cfg | awk -F" " '{ print $2 }'`
fi

copy_files()
{
if [ -d $nsdir ]
then
	if [ -w $nsdir ]
	then
		for target in "$gtarget" "$dtarget"; do
			if [ -d "$target" ]; then
				if [ -w "$target" ]; then
					echo "Files are being added to $target"
					/bin/rm -rf ${target}${zd}/* 1>/dev/null 2>&1
					/bin/cp -r payload/* ${target}${zd} 1>/dev/null 2>&1
					/bin/rm -rf ${target}${zd}/*/initVar 1>/dev/null 2>&1
					/bin/cp -r payload/*/initVar/* ${gtarget}${var} 1>/dev/null 2>&1
				else
					echo "$target is not a directory or you do not have write permissions. Login as the root user to execute this script."
				fi
			fi
		done
	fi
else
	echo "$nsdir is not found - please make sure you have root privilege and NSM is installed before running this script."
fi    
}

start_services()
{
if [ -d $nsdir ]; then
	for target in "$gtarget" "$dtarget"; do
		if [ $ANSWER = "y" ] || [ $ANSWER = "Y" ]; then
			echo "Stopping HA Server Processes...."
			$nsdir/HaSvr/bin/haSvr.sh start
		else
			if [ "$target" = "$gtarget" ]; then
				echo "Stopping GUI Server Processes...."
				${gtarget}/bin/guiSvr.sh start
			else
				echo "Stopping Device Server Processes...."
				${dtarget}/bin/devSvr.sh start
			fi
		fi
	done
else
	echo "$nsdir is not found - please make sure you have root privilege and NSM is installed before running this script."
fi    
}

stop_services()
{
if [ -d $nsdir ]; then
	for target in "$gtarget" "$dtarget"; do
		if [ $ANSWER = "y" ] || [ $ANSWER = "Y" ]; then
			echo "Stopping HA Server Processes...."
			$nsdir/HaSvr/bin/haSvr.sh stop
		else
			if [ "$target" = "$gtarget" ]; then
				echo "Stopping GUI Server Processes...."
				${gtarget}/bin/guiSvr.sh stop
			else
				echo "Stopping Device Server Processes...."
				${dtarget}/bin/devSvr.sh stop
			fi
		fi
	done
else
	echo "$nsdir is not found - please make sure you have root privilege and NSM is installed before running this script."
fi    
}

# Check if Processea are ON
check_processes()
{
if [ -d /usr/netscreen/GuiSvr ]; then
	GUISVR_PROCESS=`/etc/init.d/guiSvr status | head -2 | tail -1 | grep ON`
	if [ ! -z "$GUISVR_PROCESS"  ]; then
		echo "Stop all GuiSvr NSM processes, mount the /var/netscreen directory & execute the script"
	exit 0
	fi
	if [ ! -f /usr/netscreen/GuiSvr/var/guiSvr.cfg ]; then
		echo "GUI Server Shared Directory is not mounted. Mount the directory & execute this script"
		exit 0
	fi
fi
if [ -d /usr/netscreen/DevSvr ]; then
	DEVSVR_PROCESS=`/etc/init.d/devSvr status | head -2 | tail -1 | grep ON`
	if [ ! -z "$DEVSVR_PROCESS"  ]; then
		echo "Stop all DevSvr NSM processes, mount the /var/netscreen directory & execute the script"
	exit 0
	fi
	if [ ! -f /usr/netscreen/DevSvr/var/devSvr.cfg ]; then
		echo "Device Server Shared Directory is not mounted. Mount the directory & execute this script"
		exit 0
	fi
fi
}

set_permissions()
{
	if test "$gui_user" = "nsm"; then
		sh /usr/netscreen/GuiSvr/utils/setperms.sh GuiSvr
	fi
	if test "$dev_user" = "nsm"; then
		sh /usr/netscreen/DevSvr/utils/setperms.sh DevSvr
	fi
}

#Check to see if root user is used & payload directory is present
if test "$loginid" != "root"; then
	echo "Login as the root user & execute this script"
	exit
fi
if [ ! -d payload ]; then
	echo "payload directory not found"
	echo "Execute this script from the directory where the Forward Support Update was unzipped"
	exit
fi
	
# Is it HA config
echo "Is NSM installed in a HA mode Y/(N)"
read ANSWER
echo
if [ $ANSWER = "y" ] || [ $ANSWER = "Y" ]; then
	echo "Continue only if the NSM HA Server Processes is stopped on the Standby Server "
	echo
fi

# Is Shared Disk being used
echo "Is NSM installed on a Shared Disk Y/(N)"
read SHARED_DISK
echo

if [ $SHARED_DISK = "y" ] || [ $SHARED_DISK = "Y" ]; then
	check_processes;
	copy_files; 
	set_permissions;
	echo "Starting NSM HA Server Process"
#	/etc/init.d/haSvr restart 
else 	if [ $SHARED_DISK = "n" ] || [ $SHARED_DISK = "N" ]; then
		stop_services;
		copy_files;
		set_permissions;
		start_services;
	fi
fi

