require(['models/left_stnmenu'], function () {
   //define product model
   var left_Menu = Backbone.Model.extend({
      defaults: {
         name: ""
      }
   });

   //define directory collection
   var left_menuCollection = Backbone.Collection.extend({
      model: left_Menu
   });

   //define individual contact view
   var left_DirectoryView = Backbone.View.extend({
      tagName: "ul",
      className: "nav nav-list nav-stn",
      template: Handlebars.compile($("#stnDirectoryTemplate").html()),

      render: function () {
         var dir_tmp = this.template;

         $(this.el).html(dir_tmp(this.model.toJSON()));
         return this;
      }
   });

   var left_MenuView = Backbone.View.extend({
      tagName: "li",
      className: "pgm",
      template: Handlebars.compile($("#stnProgramsTemplate").html()),

      render: function () {
         var pgms_tmp = this.template;

         $(this.el).html(pgms_tmp(eval(this.model)));
         return this;
      }
   });

   //define master view
   var left_pgmDirectoriesView = Backbone.View.extend({
      el: $(".custom_span_menu"),

      initialize: function () {
         debug_mode.flag && console.log(" left_pgmDirectoriesView...");
         this.collection = new left_menuCollection(left_stn_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function (item) {
            item.set({
               index: i
            });

            that.renderDirectory(item);

            i++;
         }, this);
         
         $(document).trigger("stn_menu_ready");
      },

      renderDirectory: function (item) {
         var left_directoryView = new left_DirectoryView({
            model: item
         });
         this.$el.append(left_directoryView.render().el);
      }
   });

   pgm_dir_view = new left_pgmDirectoriesView();
   pgm_dir_view.render();

   var left_pgmMenuListView = Backbone.View.extend({
      initialize: function () {
         this.collection = new left_menuCollection(left_stn_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function () {
            this.setElement('.custom_span_menu ul');

            _.each(this.collection.models[i].attributes.children, function (item) {
               if (item.auth) {
                  that.renderProgram(item);
               }
            }, this);

            i++;
         }, this);
      },

      renderProgram: function (item) {
         var left_menuView = new left_MenuView({
            model: item
         });
         this.$el.append(left_menuView.render().el);
      }
   });

   pgm_menuList_view = new left_pgmMenuListView();
   _.each(pgm_menuList_view.collection.models, function (item) {
      _.each(item.attributes.children, function (child) {
         if (pgm_info[child.num]) {
            child.auth = pgm_info[child.num].auth;
         } else {
            debug_mode.flag && console.log("Don't find pgm" + child.num + "(" + child.name + ")!!");
         }
      }, this);
   }, this);

   pgm_menuList_view.render();
});