/*
 * jQuery File Upload File Processing Plugin 1.2
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2012, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */

/*jslint nomen: true, unparam: true, regexp: true */
/*global define, window, document */

(function(factory){'use strict';if(typeof define==='function'&&define.amd){define(['jquery','load-image','canvas-to-blob','./jquery.fileupload'],factory)}else{factory(window.jQuery,window.loadImage)}}(function($,loadImage){'use strict';$.widget('blueimp.fileupload',$.blueimp.fileupload,{options:{process:[],add:function(e,data){$(this).fileupload('process',data).done(function(){data.submit()})}},processActions:{load:function(data,options){var that=this,file=data.files[data.index],dfd=$.Deferred();if(window.HTMLCanvasElement&&window.HTMLCanvasElement.prototype.toBlob&&($.type(options.maxFileSize)!=='number'||file.size<options.maxFileSize)&&(!options.fileTypes||options.fileTypes.test(file.type))){loadImage(file,function(img){data.img=img;dfd.resolveWith(that,[data])})}else{dfd.rejectWith(that,[data])}return dfd.promise()},resize:function(data,options){var img=data.img,canvas;options=$.extend({canvas:true},options);if(img){canvas=loadImage.scale(img,options);if(canvas.width!==img.width||canvas.height!==img.height){data.canvas=canvas}}return data},save:function(data,options){if(!data.canvas){return data}var that=this,file=data.files[data.index],name=file.name,dfd=$.Deferred(),callback=function(blob){if(!blob.name){if(file.type===blob.type){blob.name=file.name}else if(file.name){blob.name=file.name.replace(/\..+$/,'.'+blob.type.substr(6))}}data.files[data.index]=blob;dfd.resolveWith(that,[data])};if(data.canvas.mozGetAsFile){callback(data.canvas.mozGetAsFile((/^image\/(jpeg|png)$/.test(file.type)&&name)||((name&&name.replace(/\..+$/,''))||'blob')+'.png',file.type))}else{data.canvas.toBlob(callback,file.type)}return dfd.promise()}},_processFile:function(files,index,options){var that=this,dfd=$.Deferred().resolveWith(that,[{files:files,index:index}]),chain=dfd.promise();that._processing+=1;$.each(options.process,function(i,settings){chain=chain.pipe(function(data){return that.processActions[settings.action].call(this,data,settings)})});chain.always(function(){that._processing-=1;if(that._processing===0){that.element.removeClass('fileupload-processing')}});if(that._processing===1){that.element.addClass('fileupload-processing')}return chain},process:function(data){var that=this,options=$.extend({},this.options,data);if(options.process&&options.process.length&&this._isXHRUpload(options)){$.each(data.files,function(index,file){that._processingQueue=that._processingQueue.pipe(function(){var dfd=$.Deferred();that._processFile(data.files,index,options).always(function(){dfd.resolveWith(that)});return dfd.promise()})})}return this._processingQueue},_create:function(){this._super();this._processing=0;this._processingQueue=$.Deferred().resolveWith(this).promise()}})}));