/*
 * jQuery File Upload User Interface Plugin 6.11
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */

/*jslint nomen: true, unparam: true, regexp: true */
/*global define, window, URL, webkitURL, FileReader */

!function(e){"use strict";"function"==typeof define&&define.amd?define(["jquery","tmpl","load-image","./jquery.fileupload-fp"],e):e(window.jQuery,window.tmpl,window.loadImage)}(function(e,t,i){"use strict";e.widget("blueimp.fileupload",e.blueimp.fileupload,{options:{autoUpload:!1,maxNumberOfFiles:void 0,maxFileSize:void 0,minFileSize:void 0,acceptFileTypes:/.+$/i,previewSourceFileTypes:/^image\/(gif|jpeg|png)$/,previewSourceMaxFileSize:5e6,previewMaxWidth:80,previewMaxHeight:80,previewAsCanvas:!0,uploadTemplateId:"template-upload",downloadTemplateId:"template-download",filesContainer:void 0,prependFiles:!1,dataType:"json",add:function(t,i){var n=e(this).data("fileupload"),o=n.options,a=i.files;e(this).fileupload("process",i).done(function(){if("iPECS eMG80"!=info.SYSTEM_ID){var s=a[0].name;if("pgm76"==ap.render_pgm){if("UCP_MOH"!=s.replace(/\..+$/,"")){if(13!=s.length||0==s.length)return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(s.match(/\s/g))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(!s.match(/^[gG][sS]|^[cC][sS]|^[iI][sS]|^[gG][rR]|^[fF][rR]|^[sS][pP]|^[iI][tT]|^[dD][mM]|^[sS][wW]|^[nN][wW]|^[pP][lL]|^[gG][mM]|^[aA][sS]|^[kK][rR]|^[cC][nN]|^[tT][kK]|^[jJ][pP]|^[tT][hH]|^[jJ][dD]|^[pP][tT]/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","nation")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if("96W"!=s.substr(2,3)&&"96w"!=s.substr(2,3))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","device")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1}if(!s.match(/\.[rR][oO][mM]$/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1}else if("pgm77"==ap.render_pgm||"pgm80"==ap.render_pgm){if((s.length<5||s.length>8)&&"pgm77"==ap.render_pgm)return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if((s.length<5||s.length>7)&&"pgm80"==ap.render_pgm)return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(s.match(/\s/g))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(s.match(/^0/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("error_msg","start_zero")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(isNaN(s.replace(/\..+$/,"")))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("error_msg","isnan")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(!s.match(/\.[wW][aA][vV]$/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1}else if("pgm83"==ap.render_pgm){if(11!=s.length||0==s.length)return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(s.match(/\s/g))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(!s.match(/^[sS][gG][tT][yY][pP][eE][1-6]/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" (SGTYPE1~6.rom)").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1;if(!s.match(/\.[rR][oO][mM]$/))return e("<div />").html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:!0,closeOnEscape:!1,title:langs.getText("common","notification"),open:function(t,i){e(".ui-dialog-titlebar-close").hide()},buttons:[{text:langs.getText("common","simple_okay"),click:function(){e(this).dialog("destroy")}}]}),!1}}n._adjustMaxNumberOfFiles(-a.length),i.maxNumberOfFilesAdjusted=!0,i.files.valid=i.isValidated=n._validate(a),i.context=n._renderUpload(a).data("data",i),o.filesContainer[o.prependFiles?"prepend":"append"](i.context),n._renderPreviews(a,i.context),n._forceReflow(i.context),n._transition(i.context).done(function(){n._trigger("added",t,i)!==!1&&(o.autoUpload||i.autoUpload)&&i.autoUpload!==!1&&i.isValidated&&i.submit()})})},send:function(t,i){var n=e(this).data("fileupload");return i.isValidated||(i.maxNumberOfFilesAdjusted||(n._adjustMaxNumberOfFiles(-i.files.length),i.maxNumberOfFilesAdjusted=!0),n._validate(i.files))?(i.context&&i.dataType&&"iframe"===i.dataType.substr(0,6)&&i.context.find(".progress").addClass(!e.support.transition&&"progress-animated").attr("aria-valuenow",100).find(".progress-bar").css("width","100%"),n._trigger("sent",t,i)):!1},done:function(t,i){var n,o=e(this).data("fileupload");o._adjustMaxNumberOfFiles(1),i.context?i.context.each(function(a){var s=e.isArray(i.result)&&i.result[a]||{error:"Empty file upload result"};s.error&&o._adjustMaxNumberOfFiles(1),o._transition(e(this)).done(function(){var a=e(this);n=o._renderDownload([s]).replaceAll(a),o._forceReflow(n),o._transition(n).done(function(){i.context=e(this),o._trigger("completed",t,i)})})}):(e.isArray(i.result)&&(e.each(i.result,function(e,t){i.maxNumberOfFilesAdjusted&&t.error?o._adjustMaxNumberOfFiles(1):i.maxNumberOfFilesAdjusted||t.error||o._adjustMaxNumberOfFiles(-1)}),i.maxNumberOfFilesAdjusted=!0),n=o._renderDownload(i.result).appendTo(o.options.filesContainer),o._forceReflow(n),o._transition(n).done(function(){i.context=e(this),o._trigger("completed",t,i)}))},fail:function(t,i){var n,o=e(this).data("fileupload");i.maxNumberOfFilesAdjusted&&o._adjustMaxNumberOfFiles(i.files.length),i.context?i.context.each(function(a){if("abort"!==i.errorThrown){var s=i.files[a];s.error=s.error||i.errorThrown||!0,o._transition(e(this)).done(function(){var a=e(this);n=o._renderDownload([s]).replaceAll(a),o._forceReflow(n),o._transition(n).done(function(){i.context=e(this),o._trigger("failed",t,i)})})}else o._transition(e(this)).done(function(){e(this).remove(),o._trigger("failed",t,i)})}):"abort"!==i.errorThrown?(i.context=o._renderUpload(i.files).appendTo(o.options.filesContainer).data("data",i),o._forceReflow(i.context),o._transition(i.context).done(function(){i.context=e(this),o._trigger("failed",t,i)})):o._trigger("failed",t,i)},progress:function(e,t){if(t.context){var i=parseInt(t.loaded/t.total*100,10);t.context.find(".progress").attr("aria-valuenow",i).find(".progress-bar").css("width",i+"%")}},progressall:function(t,i){var n=e(this),o=parseInt(i.loaded/i.total*100,10),a=n.find(".fileupload-progress"),s=a.find(".progress-extended");s.length&&s.html(n.data("fileupload")._renderExtendedProgress(i)),a.find(".progress").attr("aria-valuenow",o).find(".progress-bar").css("width",o+"%")},start:function(t){var i=e(this).data("fileupload");i._transition(e(this).find(".fileupload-progress")).done(function(){i._trigger("started",t)})},stop:function(t){var i=e(this).data("fileupload");i._transition(e(this).find(".fileupload-progress")).done(function(){e(this).find(".progress").attr("aria-valuenow","0").find(".progress-bar").css("width","0%"),e(this).find(".progress-extended").html("&nbsp;"),i._trigger("stopped",t)})},destroy:function(t,i){var n=e(this).data("fileupload");i.url&&(e.ajax(i),n._adjustMaxNumberOfFiles(1)),n._transition(i.context).done(function(){e(this).remove(),n._trigger("destroyed",t,i)})}},_enableDragToDesktop:function(){var t=e(this),i=t.prop("href"),n=t.prop("download"),o="application/octet-stream";t.bind("dragstart",function(e){try{e.originalEvent.dataTransfer.setData("DownloadURL",[o,n,i].join(":"))}catch(t){}})},_adjustMaxNumberOfFiles:function(e){"number"==typeof this.options.maxNumberOfFiles&&(this.options.maxNumberOfFiles+=e,this.options.maxNumberOfFiles<1?this._disableFileInputButton():this._enableFileInputButton())},_formatFileSize:function(e){return"number"!=typeof e?"":e>=1e9?(e/1e9).toFixed(2)+" GB":e>=1e6?(e/1e6).toFixed(2)+" MB":(e/1e3).toFixed(2)+" KB"},_formatBitrate:function(e){return"number"!=typeof e?"":e>=1e9?(e/1e9).toFixed(2)+" Gbit/s":e>=1e6?(e/1e6).toFixed(2)+" Mbit/s":e>=1e3?(e/1e3).toFixed(2)+" kbit/s":e+" bit/s"},_formatTime:function(e){var t=new Date(1e3*e),i=parseInt(e/86400,10);return i=i?i+"d ":"",i+("0"+t.getUTCHours()).slice(-2)+":"+("0"+t.getUTCMinutes()).slice(-2)+":"+("0"+t.getUTCSeconds()).slice(-2)},_formatPercentage:function(e){return(100*e).toFixed(2)+" %"},_renderExtendedProgress:function(e){return this._formatBitrate(e.bitrate)+" | "+this._formatTime(8*(e.total-e.loaded)/e.bitrate)+" | "+this._formatPercentage(e.loaded/e.total)+" | "+this._formatFileSize(e.loaded)+" / "+this._formatFileSize(e.total)},_hasError:function(e){return e.error?e.error:this.options.maxNumberOfFiles<0?"Maximum number of files exceeded":this.options.acceptFileTypes.test(e.type)||this.options.acceptFileTypes.test(e.name)?this.options.maxFileSize&&e.size>this.options.maxFileSize?"File is too big":"number"==typeof e.size&&e.size<this.options.minFileSize?"File is too small":null:"Filetype not allowed"},_validate:function(t){var i=this,n=!!t.length;return e.each(t,function(e,t){t.error=i._hasError(t),t.error&&(n=!1)}),n},_renderTemplate:function(t,i){if(!t)return e();var n=t({files:i,formatFileSize:this._formatFileSize,options:this.options});return n instanceof e?n:e(this.options.templatesContainer).html(n).children()},_renderPreview:function(t,n){var o=this,a=this.options,s=e.Deferred();return(i&&i(t,function(t){n.append(t),o._forceReflow(n),o._transition(n).done(function(){s.resolveWith(n)}),e.contains(o.document[0].body,n[0])||s.resolveWith(n)},{maxWidth:a.previewMaxWidth,maxHeight:a.previewMaxHeight,canvas:a.previewAsCanvas})||s.resolveWith(n))&&s},_renderPreviews:function(t,i){var n=this,o=this.options;return i.find(".preview span").each(function(i,a){var s=t[i];o.previewSourceFileTypes.test(s.type)&&("number"!==e.type(o.previewSourceMaxFileSize)||s.size<o.previewSourceMaxFileSize)&&(n._processingQueue=n._processingQueue.pipe(function(){var t=e.Deferred();return n._renderPreview(s,e(a)).done(function(){t.resolveWith(n)}),t.promise()}))}),this._processingQueue},_renderUpload:function(e){return this._renderTemplate(this.options.uploadTemplate,e)},_renderDownload:function(e){return this._renderTemplate(this.options.downloadTemplate,e).find("a[download]").each(this._enableDragToDesktop).end()},_startHandler:function(t){t.preventDefault();var i=e(t.currentTarget),n=i.closest(".template-upload"),o=n.data("data");o&&o.submit&&!o.jqXHR&&o.submit()&&i.prop("disabled",!0)},_cancelHandler:function(t){t.preventDefault();var i=e(t.currentTarget).closest(".template-upload"),n=i.data("data")||{};n.jqXHR?n.jqXHR.abort():(n.errorThrown="abort",this._trigger("fail",t,n))},_deleteHandler:function(t){t.preventDefault();var i=e(t.currentTarget);this._trigger("destroy",t,e.extend({context:i.closest(".template-download"),type:"DELETE",dataType:this.options.dataType},i.data()))},_forceReflow:function(t){return e.support.transition&&t.length&&t[0].offsetWidth},_transition:function(t){var i=e.Deferred();return t.toggleClass("in"),i.resolveWith(t),i},_initButtonBarEventHandlers:function(){var t=this.element.find(".fileupload-buttonbar"),i=this.options.filesContainer;this._on(t.find(".start"),{click:function(e){e.preventDefault(),i.find(".start button").click()}}),this._on(t.find(".cancel"),{click:function(e){e.preventDefault(),i.find(".cancel button").click()}}),this._on(t.find(".delete"),{click:function(e){e.preventDefault(),i.find(".delete input:checked").siblings("button").click(),t.find(".toggle").prop("checked",!1)}}),this._on(t.find(".toggle"),{change:function(t){i.find(".delete input").prop("checked",e(t.currentTarget).is(":checked"))}})},_destroyButtonBarEventHandlers:function(){this._off(this.element.find(".fileupload-buttonbar button"),"click"),this._off(this.element.find(".fileupload-buttonbar .toggle"),"change.")},_initEventHandlers:function(){this._super(),this._on(this.options.filesContainer,{"click .start button":this._startHandler,"click .cancel button":this._cancelHandler,"click .delete button":this._deleteHandler}),this._initButtonBarEventHandlers()},_destroyEventHandlers:function(){this._destroyButtonBarEventHandlers(),this._off(this.options.filesContainer,"click"),this._super()},_enableFileInputButton:function(){this.element.find(".fileinput-button input").prop("disabled",!1).parent().removeClass("disabled")},_disableFileInputButton:function(){this.element.find(".fileinput-button input").prop("disabled",!0).parent().addClass("disabled")},_initTemplates:function(){var e=this.options;e.templatesContainer=this.document[0].createElement(e.filesContainer.prop("nodeName")),t&&(e.uploadTemplateId&&(e.uploadTemplate=t(e.uploadTemplateId)),e.downloadTemplateId&&(e.downloadTemplate=t(e.downloadTemplateId)))},_initFilesContainer:function(){var t=this.options;void 0===t.filesContainer?t.filesContainer=this.element.find(".files"):t.filesContainer instanceof e||(t.filesContainer=e(t.filesContainer))},_stringToRegExp:function(e){var t=e.split("/"),i=t.pop();return t.shift(),new RegExp(t.join("/"),i)},_initRegExpOptions:function(){var t=this.options;"string"===e.type(t.acceptFileTypes)&&(t.acceptFileTypes=this._stringToRegExp(t.acceptFileTypes)),"string"===e.type(t.previewSourceFileTypes)&&(t.previewSourceFileTypes=this._stringToRegExp(t.previewSourceFileTypes))},_initSpecialOptions:function(){this._super(),this._initFilesContainer(),this._initTemplates(),this._initRegExpOptions()},_create:function(){this._super(),this._refreshOptionsList.push("filesContainer","uploadTemplateId","downloadTemplateId"),this._processingQueue||(this._processingQueue=e.Deferred().resolveWith(this).promise(),this.process=function(){return this._processingQueue})},enable:function(){var e=!1;this.options.disabled&&(e=!0),this._super(),e&&(this.element.find("input, button").prop("disabled",!1),this._enableFileInputButton())},disable:function(){this.options.disabled||(this.element.find("input, button").prop("disabled",!0),this._disableFileInputButton()),this._super()}})});
