var chkall_flag;

(function ($) {
  "use strict";

  /**
   * Handsontable DeleteChkbox extension.
   */
  
  Handsontable.PluginHooks.add('beforeInitWalkontable', function (walkontableConfig) {
    var instance = this;
    var baseRowHeaders = walkontableConfig.rowHeaders;
    walkontableConfig.outsideChkboxPlugin = Boolean(instance.getSettings().outsideChkboxPlugin);
    walkontableConfig.rowHeaders = function () {
      var pluginEnabled = Boolean(instance.getSettings().outsideChkboxPlugin);

      var newRowHeader = function (row, elem) {
        var child
          , chkbox;
        while (child = elem.lastChild) {
          elem.removeChild(child);
        }
        elem.className = 'htNoFrame htOutsideChkbox';
        chkbox = document.createElement('input');
        chkbox.type = 'checkbox';
        if (row == -1) {
			 chkbox.className = 'chk_outsideCheckall';
			 chkbox.title = langs.getText('toolTip','tip_outsideCheckall');
			 
			 if (chkall_flag == true) {
			 	chkbox.checked = true;
			}
        } else {
			 chkbox.className = 'chk_outsideCheck';
			 if (chkall_flag == true) {
				chkbox.checked = true;
			 }
        }
        elem.appendChild(chkbox);
      };

      return pluginEnabled ? Array.prototype.concat.call([], newRowHeader, baseRowHeaders()) : baseRowHeaders();
    };
  });
})(jQuery);