require(['models/left_menu'], function () {

   //define product model
   var left_Menu = Backbone.Model.extend({
      defaults: {
         name: ""
      }
   });

   //define directory collection
   var left_menuCollection = Backbone.Collection.extend({
      model: left_Menu
   });

   //define individual contact view
   var left_DirectoryView = Backbone.View.extend({
      className: "panel panel-default",
      template: Handlebars.compile($("#directoryTemplate").html()),

      render: function () {
         var dir_tmp = this.template;

         $(this.el).html(dir_tmp(this.model.toJSON()));
         return this;
      }
   });

   var left_MenuView = Backbone.View.extend({
      tagName: "li",
      className: "pgm",
      template: Handlebars.compile($("#programsTemplate").html()),

      render: function () {
         var pgms_tmp = this.template;

         $(this.el).html(pgms_tmp(eval(this.model)));
         return this;
      }
   });
   
   var left_fMenuView = Backbone.View.extend({
      tagName: "li",
      className: "pgm",
      template: Handlebars.compile($("#functionsTemplate").html()),

      render: function () {
         var pgms_tmp = this.template;

         $(this.el).html(pgms_tmp(eval(this.model)));
         return this;
      }
   });

   //define master view
   var left_pgmDirectoriesView = Backbone.View.extend({
      el: $("#accordion"),

      initialize: function () {
         debug_mode.flag && console.log(" left_pgmDirectoriesView...");
         this.collection = new left_menuCollection(left_pgm_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function (item) {
            item.set({
               index: i
            });

            that.renderDirectory(item);

            i++;
         }, this);
      },

      renderDirectory: function (item) {
         var left_directoryView = new left_DirectoryView({
            model: item
         });
         this.$el.append(left_directoryView.render().el);
      }
   });

   var left_funcDirectoriesView = Backbone.View.extend({
      el: $("#accordion"),

      initialize: function () {
         debug_mode.flag && console.log(" left_funcDirectoriesView...");
         this.collection = new left_menuCollection(left_function_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function (item) {
            item.set({
               index: i
            });

            that.renderDirectory(item);

            i++;
         }, this);
      },

      renderDirectory: function (item) {
         var left_directoryView = new left_DirectoryView({
            model: item
         });
         this.$el.append(left_directoryView.render().el);
      }
   });

   var left_mntDirectoriesView = Backbone.View.extend({
      el: $("#accordion"),

      initialize: function () {
         debug_mode.flag && console.log(" left_mntDirectoriesView...");
         this.collection = new left_menuCollection(left_maint_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function (item) {
            item.set({
               index: i
            });

            that.renderDirectory(item);

            i++;
         }, this);
      },

      renderDirectory: function (item) {
         var left_directoryView = new left_DirectoryView({
            model: item
         });
         this.$el.append(left_directoryView.render().el);
      }
   });

   pgm_dir_view = new left_pgmDirectoriesView();
   func_dir_view = new left_funcDirectoriesView();
   mnt_dir_view = new left_mntDirectoriesView();
   pgm_dir_view.render();

   var left_pgmMenuListView = Backbone.View.extend({
      initialize: function () {
         this.collection = new left_menuCollection(left_pgm_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function () {
            this.setElement('#collapse' + i + ' div ul');

            _.each(this.collection.models[i].attributes.children, function (item) {
               /* to enable attribute search in Add Function PGM List
					if (active_base == "tab_maintenance") {
						if (item.num == 1030 || item.num == 1400 || item.num == 1900 || item.num == 1920 || item.num == 2600 || item.num == 1330 || item.num == 12601 || item.num == 12602 || item.num == 3220 || item.num == 3240 || item.num == 4360 || item.num == 4390 || item.num == 309 || item.num == 3110 || item.num == 3130 || item.num == 189 || item.num == 1891) {
							return true;	//	Skip Overviews in Add Function PGM List (In case of each, 'Return true' means 'continue')
						}
					}
					*/
            
               if (item.auth) {
                  that.renderProgram(item);
               }
            }, this);

            i++;
         }, this);

         for (var j = 0; j < $('.custom_span_menu #accordion .panel-default').length; j++) {
            if ($('.custom_span_menu #accordion .panel-default:eq(' + j + ') .nav-list li').length == 0) {
               $('.custom_span_menu #accordion .panel-default:eq(' + j + ')').remove();
               j = -1;
            }
         }
      },

      renderProgram: function (item) {
         var left_menuView = new left_MenuView({
            model: item
         });
         this.$el.append(left_menuView.render().el);
      }
   });

   var left_funcMenuListView = Backbone.View.extend({
      initialize: function () {
			for(var i=0; i<left_function_menuList.length; i++) {
				left_function_menuList[i].children.sort(function (a, b) {
					return a.name < b.name ? -1 : a.name > b.name ? 1 : 0;
				});
			}
         this.collection = new left_menuCollection(left_function_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function () {
            this.setElement('#collapse' + i + ' div ul');

            _.each(this.collection.models[i].attributes.children, function (item) {
               that.renderProgram(item);
            }, this);

            i++;
         }, this);
      },

      renderProgram: function (item) {
         var left_menuView = new left_fMenuView({
            model: item
         });
         this.$el.append(left_menuView.render().el);
      }
   });

   var left_mntMenuListView = Backbone.View.extend({
      initialize: function () {
         this.collection = new left_menuCollection(left_maint_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function () {
            this.setElement('#collapse' + i + ' div ul');

            _.each(this.collection.models[i].attributes.children, function (item) {
               if (item.auth) {
                  that.renderProgram(item);
               }
            }, this);

            i++;
         }, this);

         for (var j = 0; j < $('.custom_span_menu #accordion .panel-default').length; j++) {
            if ($('.custom_span_menu #accordion .panel-default:eq(' + j + ') .nav-list li').length == 0) {
               $('.custom_span_menu #accordion .panel-default:eq(' + j + ')').remove();
               j = -1;
            }
         }
      },

      renderProgram: function (item) {
         var left_menuView = new left_MenuView({
            model: item
         });
         this.$el.append(left_menuView.render().el);
      }
   });

   pgm_menuList_view = new left_pgmMenuListView();
   _.each(pgm_menuList_view.collection.models, function (item) {
      _.each(item.attributes.children, function (child) {
         if (pgm_info[child.num]) {
            child.auth = pgm_info[child.num].auth;
         } else {
            debug_mode.flag && console.log("Don't find pgm" + child.num + "(" + child.name + ")!!");
         }
         
         try {
				if (favorite_pgmlist[child.num]) {
					child.fav = favorite_pgmlist[child.num];
				}
         } catch (e) {
				debug_mode.flag && console.log("user.profile.js read error!!");
         }
      }, this);
   }, this);
   
   func_menuList_view = new left_funcMenuListView();
   _.each(func_menuList_view.collection.models, function (item) {
      _.each(item.attributes.children, function (child) {
			try {
				if (favorite_funclist[child.num]) {
					child.fav = favorite_funclist[child.num];
				}
         } catch (e) {
				debug_mode.flag && console.log("user.profile.js read error!!");
         }
      }, this);
   }, this);
   
   mnt_menuList_view = new left_mntMenuListView();
   _.each(mnt_menuList_view.collection.models, function (item) {
      _.each(item.attributes.children, function (child) {
         if (pgm_info[child.num]) {
            child.auth = pgm_info[child.num].auth;
         } else {
            debug_mode.flag && console.log("Don't find pgm" + child.num + "(" + child.name + ")!!");
         }
      }, this);
   }, this);

   pgm_menuList_view.render();
});