/*
 * jQuery File Upload Plugin JS Example 6.11
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */
/*jslint nomen: true, unparam: true, regexp: true */
/*global $, window, document */

function make_file_upload_pgm() {
   'use strict';

   if (ap.render_pgm == "pgm51" || ap.render_pgm == "iw001") {
      // Initialize the jQuery File Upload widget:
      $('#fileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#fileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#fileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$|(\.|\/)(admgz)$|(\.|\/)(admgzu)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$|\/(admgz)$|\/(admgzu)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#fileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#fileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#fileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm55") {
      // Initialize the jQuery File Upload widget:
      $('#dbfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#dbfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#dbfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(admgz)$|(\.|\/)(admgzu)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(admgz)$|\/(admgzu)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#dbfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#dbfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#dbfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm56") {
      // Initialize the jQuery File Upload widget:
      $('#mlfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#mlfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#mlfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(csv)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(csv)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#dbfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#mlfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#mlfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm76") {
      // Initialize the jQuery File Upload widget:
      $('#vsfprmtfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#vsfprmtfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#vsfprmtfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#vsfprmtfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#vsfprmtfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#vsfprmtfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm77") {
      // Initialize the jQuery File Upload widget:
      $('#indivfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#indivfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#indivfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#indivfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#indivfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#indivfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm80") {
      // Initialize the jQuery File Upload widget:
      $('#sgindivfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#sgindivfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#sgindivfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#sgindivfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#sgindivfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#sgindivfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm782") {
      // Initialize the jQuery File Upload widget:
      $('#mohindivfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#mohindivfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#mohindivfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#mohindivfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#mohindivfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#mohindivfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm83") {
      // Initialize the jQuery File Upload widget:
      $('#vsfsgfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#vsfsgfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#vsfsgfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(rom)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(rom)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#vsfsgfileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#vsfsgfileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#vsfsgfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   } else if (ap.render_pgm == "pgm89" || ap.render_pgm == "iw007") {
      // Initialize the jQuery File Upload widget:
      $('#licenseupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#licenseupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#licenseupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(ucp)$|(\.|\/)(uvm)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(ucp)$|\/(uvm)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#fileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#fileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#licenseupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
  } else if (ap.render_pgm == "pgm46") {
      // Initialize the jQuery File Upload widget:
      $('#usrgrtfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#usrgrtfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#usrgrtfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(tgz)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(tgz)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#fileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#fileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#usrgrtfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
  } else if (ap.render_pgm == "pgm48") {
      // Initialize the jQuery File Upload widget:
      $('#cdnfileupload').fileupload({
         // Uncomment the following to send cross-domain cookies:
         //xhrFields: {withCredentials: true},
         //url: 'server/php/'
         maxNumberOfFiles: 1
      });

      // Enable iframe cross-domain access via redirect option:
      $('#cdnfileupload').fileupload('option', 'redirect', window.location.href.replace(/\/[^\/]*$/, '/cors/result.html?%s'));

      if (window.location.hostname === "") {
         // Demo settings:
         $('#cdnfileupload').fileupload('option', {
            //url: '//jquery-file-upload.appspot.com/',
            maxFileSize: 5000000,
            acceptFileTypes: /(\.|\/)(tgz)$/i,
            process: [{
               action: 'load',
               fileTypes: /\/(tgz)$/,
               maxFileSize: 20000000 // 20MB
            }, {
               action: 'resize',
               maxWidth: 1440,
               maxHeight: 900
            }, {
               action: 'save'
            }]
         });
         // Upload server status check for browsers with CORS support:
         if ($.support.cors) {
            $.ajax({
               //url: '//jquery-file-upload.appspot.com/',
               type: 'HEAD'
            }).fail(function () {
               $('<span class="alert alert-error"/>').text('Upload server currently unavailable - ' + new Date()).appendTo('#fileupload');
            });
         }
      } else {
         // Load existing files:
         $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            //url: $('#fileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#cdnfileupload')[0]
         }).done(function (result) {
            if (result && result.length) {
               $(this).fileupload('option', 'done').call(this, null, {
                  result: result
               });
            }
         });
      }
   }
}
