﻿if (info.SYSTEM_ID == "iPECS eMG80" || info.SYSTEM_ID == "iPECS eMG800") {
	if (info.BOARD_ID == 2) {
		if (info.SYSTEM_ID == "iPECS eMG800") {
			$('div[name=system_id]').text("Vertical Summit 800");
		} else {
			$('div[name=system_id]').text("Vertical Summit");
		}
		$('img[name=brand]').hide();
	} else if (info.BOARD_ID == 3) {
		if (info.SYSTEM_ID == "iPECS eMG800") {
			$('div[name=system_id]').text("Aria IP 800");
		} else {
			$('div[name=system_id]').text("Aria IP 100");
		}
		$('img[name=brand]').hide();
	} else {
		if (info.NCODE == "TKM") {
			$('div[name=system_id]').text("OptiCon eMG");
		} else {
			$('div[name=system_id]').text(info.SYSTEM_ID);
		}
	}
} else {
	$('div[name=system_id]').text("iPECS "+info.SYSTEM_ID);
}

$('input[name=login_id]').focus();
$('div[name=site_name]').text(info.SITE_NAME);
$('input[name=login_id]').attr("placeholder", langs.getText("login","userid"));
$('input[name=login_pw]').attr("placeholder", langs.getText("login","passwd"));
$('.btn_login').text(langs.getText("login","submit"));
$('a[name=usr_guide_link]').text(langs.getText("common","ug_title"));

if (err_code == 1) {
	$('div[name="error_container"]').show();
   $('div[name=error_msg]').text(langs.getText("login","err_fail"));
   blink_div('div[name="error_container"]');
} else if (err_code == 2) {
	$('div[name="error_container"]').show();
   $('div[name=error_msg]').text(langs.getText("login","err_online"));
   blink_div('div[name="error_container"]');
} else if (err_code == 3) {
	$('div[name="error_container"]').show();
   $('div[name=error_msg]').text(langs.getText("login","err_blocked"));
   blink_div('div[name="error_container"]');
} else if (err_code == 4) {
	$('div[name="error_container"]').show();
   $('div[name=error_msg]').text(langs.getText("login","err_authfull"));
   blink_div('div[name="error_container"]');
} else if (err_code == 5) {
	$('div[name="error_container"]').show();
   $('div[name=error_msg]').text(langs.getText("login","err_chkinfo"));
   blink_div('div[name="error_container"]');
}

if (info.SYSTEM_ID == "iPECS eMG80" || info.SYSTEM_ID == "iPECS eMG800") {
	if (info.SITE_NAME) {
		if (info.BOARD_ID == 2) {
			if (info.SYSTEM_ID == "iPECS eMG800") {
				$('title').text('Vertical Summit 800 (' + info.SITE_NAME + ')');
			} else {
				$('title').text('Vertical Summit (' + info.SITE_NAME + ')');
			}
		} else if (info.BOARD_ID == 3) {
			if (info.SYSTEM_ID == "iPECS eMG800") {
				$('title').text('Aria IP 800 (' + info.SITE_NAME + ')');
			} else {
				$('title').text('Aria IP 100 (' + info.SITE_NAME + ')');
			}
		} else {
			if (info.NCODE == "TKM") {
				$('title').text('OptiCon eMG (' + info.SITE_NAME + ')');
			} else {
				$('title').text('iPECS (' + info.SITE_NAME + ')');
			}
		}
	} else {
		if (info.BOARD_ID == 2) {
			if (info.SYSTEM_ID == "iPECS eMG800") {
				$('title').text("Vertical Summit 800 " + langs.getText("common","adm_title"));
			} else {
				$('title').text("Vertical Summit " + langs.getText("common","adm_title"));
			}
		} else if (info.BOARD_ID == 3) {
			if (info.SYSTEM_ID == "iPECS eMG800") {
				$('title').text("Aria IP 800 " + langs.getText("common","adm_title"));
			} else {
				$('title').text("Aria IP 100 " + langs.getText("common","adm_title"));
			}
		} else {
			if (info.NCODE == "TKM") {
				$('title').text("OptiCon eMG " + langs.getText("common","adm_title"));
			} else {
				$('title').text(info.SYSTEM_ID + " " + langs.getText("common","adm_title"));
			}
		}
	}
} else {
	if (info.SITE_NAME) {
		$('title').text('iPECS (' + info.SITE_NAME + ')');
	} else {
		$('title').text(info.SYSTEM_ID + " " + langs.getText("common","adm_title"));
	}
}

$('.input_login').keypress(function (evt) {
   if (evt.keyCode === 13) {
      sendit();
   }
});

$('.btn_login').click(function () {
   sendit();
});

function sendit() {
	$('div[name="error_container"]').hide();
   $('div[name=error_msg]').html("");

   if ($('input[name=login_id]').val() === "") {
		$('div[name="error_container"]').show();
      $('div[name=error_msg]').text(langs.getText("login","err_chkinfo"));
      $('input[name=login_id]').focus();
      blink_div('div[name="error_container"]');
      return;
   } else if ($('input[name=login_pw]').val() === "") {
		$('div[name="error_container"]').show();
      $('div[name=error_msg]').text(langs.getText("login","err_chkinfo"));
      $('input[name=login_pw]').focus();
      blink_div('div[name="error_container"]');
      return;
   }

   var id_data, pwd_data, enc_id_data, enc_pwd_data;
   var $pem = public_key;
   var $key = RSA.getPublicKey($pem);
   id_data = $('input[name=login_id]').val();
   pwd_data = $('input[name=login_pw]').val();
   if(!offline_mode)
   {
       enc_id_data = RSA.encrypt(id_data, $key);
       enc_pwd_data = RSA.encrypt(pwd_data, $key);
   }
   else
   {
       enc_id_data = id_data;
       enc_pwd_data = pwd_data;
   }
   if (enc_id_data == "" || enc_pwd_data == "") {
      console.log("Error : Log-in failure");
      return;
   }

   $('input[name=ID]').val(enc_id_data);
   $('input[name=PWD]').val(enc_pwd_data);

   $('form[name=LOGIN_FORM]').submit();
}

function blink_div (sel) {
	$(sel).fadeOut('slow', function(){
		$(this).fadeIn('slow', function(){
			blink_div(this);
		});
	});
}

allLoadComplete = true;
console.log("all load complete!!");