require(['models/up_hotkey_list'], function () {
});

$(".up_hotkey_pane").draggable({handle: ".up_hotkey_topbar", containment: ".up_hotkey_overlay"});

function make_hotkey_list (packet) {
	var pgm = "pgmup001";

	if (!pgm_views[pgm]) {
		require(['models/' + pgm + "_model"], function (model) {
         debug_mode.flag && console.log(pgm + " required...");
         pgm_models[pgm] = model;
         var tmp_pgm_model = $.extend(true, {}, pgm_models[pgm]);

         pgm_views[pgm] = new pgmup_ModelsView(tmp_pgm_model);

         pgm_name_maps.make_map(pgm);
         pgm_key_maps.make_map(pgm);
		});
	}
	
	if (pgm_views[pgm]) {
		sendMsg(packet.main, pgm, packet.type, packet.range, packet.msg);
		
		$(document).unbind("Stand_by");
		$(document).bind("Stand_by", function () {
			var source = $("#upHotkeyListTemplate").html();
			var template = Handlebars.compile(source);
			var hotkey_html;

			$(".up_hotkey_list").html("<table class='up_hotkey_table'></table>");
			
			_.each(up_hotkey_list, function (item) {
				_.each(item.hotkey, function  (key) {
					if (key.options) {
						key.value = pgm_name_maps[pgm][key.name].value;
					}
				});
			
				hotkey_html = template(item);
			}, this);
			
			if ($('.up_main_menu .pgm.active').children().attr("href").replace("#", "") == "pgmup001") {
				pgm_views[pgm].render();
				debug_mode.flag && console.log("this pgm : " + pgm + " render event received");
			}
		});
	} else {
		return false;
	}
}