require(['models/up_menu'], function () {
   //define product model
   var top_Menu = Backbone.Model.extend({
      defaults: {
         name: ""
      }
   });

   //define directory collection
   var top_menuCollection = Backbone.Collection.extend({
      model: top_Menu
   });

   var top_MenuView = Backbone.View.extend({
      tagName: "div",
      className: "pgm",
      template: Handlebars.compile($("#upMenuTemplate").html()),

      render: function () {
         var pgms_tmp = this.template;

         $(this.el).html(pgms_tmp(eval(this.model)));
         return this;
      }
   });

   var top_pgmMenuListView = Backbone.View.extend({
      initialize: function () {
         this.collection = new top_menuCollection(up_menuList);
      },

      render: function () {
         var that = this;
         var i = 0;

         _.each(this.collection.models, function () {
            this.setElement('.up_main_menu');

            _.each(this.collection.models[i].attributes.list, function (item) {
               that.renderProgram(item);
            }, this);

            i++;
         }, this);
      },

      renderProgram: function (item) {
         var top_menuView = new top_MenuView({
            model: item
         });
         this.$el.append(top_menuView.render().el);
      }
   });

   pgm_menuList_view = new top_pgmMenuListView();
   pgm_menuList_view.render();
});