var pgmup_Model = Backbone.Model.extend({
   defaults: {
      name: ""
   }
});

var pgmup_Collection = Backbone.Collection.extend({
   model: pgmup_Model
});

var pgmup_ModelsView = Backbone.View.extend({
   template: Handlebars.compile($("#pgmupTemplate").html()),

   initialize: function (col) {
      this.collection = new pgmup_Collection(col);
   },

   render: function (sel) {
      var that = this;

		$(".up_pgm_pane").html("");
		$(".up_pgm_header").html("");
		
      _.each(this.collection.models[0].attributes.elements, function (items) {
         _.each(items.tab, function (item, i) {
            that.renderModel(item);
         }, this);
      }, this);
      
		$(".up_pgm_pane table").filter(
			function() {
				if ($(this).find('td').length == 0) {
					return ($(this));
				}
			}
		).hide();
		
		$(".up_pgm_pane table tr").filter(
			function() {
				if ($(this).find('th, td').length) {
					return ($(this).find('th, td:visible').length == $(this).find('th:empty, td:visible:empty').length);
				}
			}
		).hide();
		
		$(".up_pgm_pane table.table_striped tr").filter(
			function() {
				if ($(this).find('th').length) {
					return $(this);
				}
			}
		).css('background-color','#ffffff');
		
		if ($('.pgm.active a').attr('href').replace("#", "").trim() == "pgmup001") {
			if ($('.up_pgm_pane [name=PSM_MSG]').length) {
				switch (pgm_name_maps["pgmup001"]["PSM_MSG"].value.trim()) {
					case "2":
						$('.up_pgm_pane [name=PSM_VAL_2]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_time"));
						break;
					case "3":
						$('.up_pgm_pane [name=PSM_VAL_3]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_date"));
						break;
					case "4":
						$('.up_pgm_pane [name=PSM_VAL_4]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_time"));
						break;
					case "5":
						$('.up_pgm_pane [name=PSM_VAL_5]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_date"));
						break;
					case "7":
						$('.up_pgm_pane [name=PSM_VAL_7]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_num"));
						break;
					case "8":
						$('.up_pgm_pane [name=PSM_VAL_8]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_num"));
						break;
					case "9":
						$('.up_pgm_pane [name=PSM_VAL_9]').parents('td').siblings('td').eq(0).text(langs.getText("up001","psm_val_time"));
						break;
					default:
						break;
				}
			}
			
			if ((info.ATD_ENABLE == "1") && ($('.up_pgm_pane [name=ARM_MODE]').length) && (pgm_name_maps["pgmup001"]["ARM_MODE"].value != "4")) {
				$('.up_pgm_pane [name=ARM_MODE]').parents('tr').next().hide();
			}
		} else if ($('.pgm.active a').attr('href').replace("#", "").trim() == "pgmup005") {
			if ($(window).width() >= 568) {
				$('.up_sel_search_priority .btn_txt').text(langs.getText("up005","system"));
			} else {
				$('.up_sel_search_priority .btn_txt').text("S");
			}
		
			$(".btn_clickcall").filter(
				function() {
					if ($(this).parents('td').text().trim().length == 0) {
						return $(this);
					}
				}
			).hide();
		}
		
      _.each($(".up_pgm_pane table td"), function (item) {
         if ($(item).find('.chk_checkall').length) {
				$(item).css('width','1%');
         } else {
				if ($(item).parents('tr').find('.chk_checkall').length) {
					$(item).css('width',(100 / ($(item).parents('tr').children('td').length - 1)) + '%');
				} else {
					$(item).css('width',(100 / $(item).parents('tr').children('td').length) + '%');
				}
         }
      }, this);
		
      _.each($(".up_pgm_pane table select"), function (item) {
         if (item.offsetWidth > 96) {
				item.style.width = '200px';
         } else {
				item.style.width = '96px';
         }
      }, this);
		
      _.each($(".up_pgm_pane table .chk_checkall"), function (item) {
			if (!item.checked) {
				$(item).parents('tr').find('input, select').not(item).addClass('dont_save');
				
				if ($(item).parents('td').attr('rowspan')) {
					var end_idx = eval($(item).parents('td').attr('rowspan'));
				
					for (var i=0; i<end_idx-1; i++) {
						$(item).parents('tr').nextAll().eq(i).find('input, select').not(item).addClass('dont_save');
					}
				}
         }
      }, this);
      
      if (!$('.up_hotkey_btn').hasClass('active')) {
			$('.up_pgm_pane').scrollTop(0);
      }
   },

   renderModel: function (item) {
      var pgmup_tmp = this.template;

      pgmup_tmp(eval(item));
   }
});
