/*
 * jQuery File Upload User Interface Plugin 6.11
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */

/*jslint nomen: true, unparam: true, regexp: true */
/*global define, window, URL, webkitURL, FileReader */

(function(factory){'use strict';if(typeof define==='function'&&define.amd){define(['jquery','tmpl','load-image','./jquery.fileupload-fp'],factory)}else{factory(window.jQuery,window.tmpl,window.loadImage)}}(function($,tmpl,loadImage){'use strict';$.widget('blueimp.fileupload',$.blueimp.fileupload,{options:{autoUpload:false,maxNumberOfFiles:undefined,maxFileSize:undefined,minFileSize:undefined,acceptFileTypes:/.+$/i,previewSourceFileTypes:/^image\/(gif|jpeg|png)$/,previewSourceMaxFileSize:5000000,previewMaxWidth:80,previewMaxHeight:80,previewAsCanvas:true,uploadTemplateId:'template-upload',downloadTemplateId:'template-download',filesContainer:undefined,prependFiles:false,dataType:'json',add:function(e,data){var that=$(this).data('fileupload'),options=that.options,files=data.files;$(this).fileupload('process',data).done(function(){if(info.SYSTEM_ID!="iPECS eMG80"){var tmp_fileName=files[0].name;if(ap.render_pgm=="pgm76"){if(tmp_fileName.replace(/\..+$/,'')!="UCP_MOH"){if((tmp_fileName.length!=13)||(tmp_fileName.length==0)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(tmp_fileName.match(/\s/g)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(!tmp_fileName.match(/^[gG][sS]|^[cC][sS]|^[iI][sS]|^[gG][rR]|^[fF][rR]|^[sS][pP]|^[iI][tT]|^[dD][mM]|^[sS][wW]|^[nN][wW]|^[pP][lL]|^[gG][mM]|^[aA][sS]|^[kK][rR]|^[cC][nN]|^[tT][kK]|^[jJ][pP]|^[tT][hH]/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","nation")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if((tmp_fileName.substr(2,3)!="96W")&&(tmp_fileName.substr(2,3)!="96w")){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","device")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}}if(!tmp_fileName.match(/\.[rR][oO][mM]$/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}}else if((ap.render_pgm=="pgm77")||(ap.render_pgm=="pgm80")){if(((tmp_fileName.length<5)||(tmp_fileName.length>8))&&(ap.render_pgm=="pgm77")){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(((tmp_fileName.length<5)||(tmp_fileName.length>7))&&(ap.render_pgm=="pgm80")){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(tmp_fileName.match(/\s/g)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(tmp_fileName.match(/^0/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("error_msg","start_zero")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(isNaN(tmp_fileName.replace(/\..+$/,''))){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("error_msg","isnan")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(!tmp_fileName.match(/\.[wW][aA][vV]$/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}}else if(ap.render_pgm=="pgm83"){if((tmp_fileName.length!=11)||(tmp_fileName.length==0)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","length")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(tmp_fileName.match(/\s/g)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","contain_space")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(!tmp_fileName.match(/^[sS][gG][tT][yY][pP][eE][1-6]/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" (SGTYPE1~6.rom)").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}if(!tmp_fileName.match(/\.[rR][oO][mM]$/)){$('<div />').html(langs.getText("error_msg","invalid_fn")+" ("+langs.getText("common","extension")+")").dialog({modal:true,closeOnEscape:false,title:langs.getText("common","notification"),open:function(event,ui){$(".ui-dialog-titlebar-close").hide()},buttons:{Ok:function(){$(this).dialog("destroy")}}});return false}}}that._adjustMaxNumberOfFiles(-files.length);data.maxNumberOfFilesAdjusted=true;data.files.valid=data.isValidated=that._validate(files);data.context=that._renderUpload(files).data('data',data);options.filesContainer[options.prependFiles?'prepend':'append'](data.context);that._renderPreviews(files,data.context);that._forceReflow(data.context);that._transition(data.context).done(function(){if((that._trigger('added',e,data)!==false)&&(options.autoUpload||data.autoUpload)&&data.autoUpload!==false&&data.isValidated){data.submit()}})})},send:function(e,data){var that=$(this).data('fileupload');if(!data.isValidated){if(!data.maxNumberOfFilesAdjusted){that._adjustMaxNumberOfFiles(-data.files.length);data.maxNumberOfFilesAdjusted=true}if(!that._validate(data.files)){return false}}if(data.context&&data.dataType&&data.dataType.substr(0,6)==='iframe'){data.context.find('.progress').addClass(!$.support.transition&&'progress-animated').attr('aria-valuenow',100).find('.bar').css('width','100%')}return that._trigger('sent',e,data)},done:function(e,data){var that=$(this).data('fileupload'),template;that._adjustMaxNumberOfFiles(1);if(data.context){data.context.each(function(index){var file=($.isArray(data.result)&&data.result[index])||{error:'Empty file upload result'};if(file.error){that._adjustMaxNumberOfFiles(1)}that._transition($(this)).done(function(){var node=$(this);template=that._renderDownload([file]).replaceAll(node);that._forceReflow(template);that._transition(template).done(function(){data.context=$(this);that._trigger('completed',e,data)})})})}else{if($.isArray(data.result)){$.each(data.result,function(index,file){if(data.maxNumberOfFilesAdjusted&&file.error){that._adjustMaxNumberOfFiles(1)}else if(!data.maxNumberOfFilesAdjusted&&!file.error){that._adjustMaxNumberOfFiles(-1)}});data.maxNumberOfFilesAdjusted=true}template=that._renderDownload(data.result).appendTo(that.options.filesContainer);that._forceReflow(template);that._transition(template).done(function(){data.context=$(this);that._trigger('completed',e,data)})}},fail:function(e,data){var that=$(this).data('fileupload'),template;if(data.maxNumberOfFilesAdjusted){that._adjustMaxNumberOfFiles(data.files.length)}if(data.context){data.context.each(function(index){if(data.errorThrown!=='abort'){var file=data.files[index];file.error=file.error||data.errorThrown||true;that._transition($(this)).done(function(){var node=$(this);template=that._renderDownload([file]).replaceAll(node);that._forceReflow(template);that._transition(template).done(function(){data.context=$(this);that._trigger('failed',e,data)})})}else{that._transition($(this)).done(function(){$(this).remove();that._trigger('failed',e,data)})}})}else if(data.errorThrown!=='abort'){data.context=that._renderUpload(data.files).appendTo(that.options.filesContainer).data('data',data);that._forceReflow(data.context);that._transition(data.context).done(function(){data.context=$(this);that._trigger('failed',e,data)})}else{that._trigger('failed',e,data)}},progress:function(e,data){if(data.context){var progress=parseInt(data.loaded/data.total*100,10);data.context.find('.progress').attr('aria-valuenow',progress).find('.bar').css('width',progress+'%')}},progressall:function(e,data){var $this=$(this),progress=parseInt(data.loaded/data.total*100,10),globalProgressNode=$this.find('.fileupload-progress'),extendedProgressNode=globalProgressNode.find('.progress-extended');if(extendedProgressNode.length){extendedProgressNode.html($this.data('fileupload')._renderExtendedProgress(data))}globalProgressNode.find('.progress').attr('aria-valuenow',progress).find('.bar').css('width',progress+'%')},start:function(e){var that=$(this).data('fileupload');that._transition($(this).find('.fileupload-progress')).done(function(){that._trigger('started',e)})},stop:function(e){var that=$(this).data('fileupload');that._transition($(this).find('.fileupload-progress')).done(function(){$(this).find('.progress').attr('aria-valuenow','0').find('.bar').css('width','0%');$(this).find('.progress-extended').html('&nbsp;');that._trigger('stopped',e)})},destroy:function(e,data){var that=$(this).data('fileupload');if(data.url){$.ajax(data);that._adjustMaxNumberOfFiles(1)}that._transition(data.context).done(function(){$(this).remove();that._trigger('destroyed',e,data)})}},_enableDragToDesktop:function(){var link=$(this),url=link.prop('href'),name=link.prop('download'),type='application/octet-stream';link.bind('dragstart',function(e){try{e.originalEvent.dataTransfer.setData('DownloadURL',[type,name,url].join(':'))}catch(err){}})},_adjustMaxNumberOfFiles:function(operand){if(typeof this.options.maxNumberOfFiles==='number'){this.options.maxNumberOfFiles+=operand;if(this.options.maxNumberOfFiles<1){this._disableFileInputButton()}else{this._enableFileInputButton()}}},_formatFileSize:function(bytes){if(typeof bytes!=='number'){return''}if(bytes>=1000000000){return(bytes/1000000000).toFixed(2)+' GB'}if(bytes>=1000000){return(bytes/1000000).toFixed(2)+' MB'}return(bytes/1000).toFixed(2)+' KB'},_formatBitrate:function(bits){if(typeof bits!=='number'){return''}if(bits>=1000000000){return(bits/1000000000).toFixed(2)+' Gbit/s'}if(bits>=1000000){return(bits/1000000).toFixed(2)+' Mbit/s'}if(bits>=1000){return(bits/1000).toFixed(2)+' kbit/s'}return bits+' bit/s'},_formatTime:function(seconds){var date=new Date(seconds*1000),days=parseInt(seconds/86400,10);days=days?days+'d ':'';return days+('0'+date.getUTCHours()).slice(-2)+':'+('0'+date.getUTCMinutes()).slice(-2)+':'+('0'+date.getUTCSeconds()).slice(-2)},_formatPercentage:function(floatValue){return(floatValue*100).toFixed(2)+' %'},_renderExtendedProgress:function(data){return this._formatBitrate(data.bitrate)+' | '+this._formatTime((data.total-data.loaded)*8/data.bitrate)+' | '+this._formatPercentage(data.loaded/data.total)+' | '+this._formatFileSize(data.loaded)+' / '+this._formatFileSize(data.total)},_hasError:function(file){if(file.error){return file.error}if(this.options.maxNumberOfFiles<0){return'Maximum number of files exceeded'}if(!(this.options.acceptFileTypes.test(file.type)||this.options.acceptFileTypes.test(file.name))){return'Filetype not allowed'}if(this.options.maxFileSize&&file.size>this.options.maxFileSize){return'File is too big'}if(typeof file.size==='number'&&file.size<this.options.minFileSize){return'File is too small'}return null},_validate:function(files){var that=this,valid=!!files.length;$.each(files,function(index,file){file.error=that._hasError(file);if(file.error){valid=false}});return valid},_renderTemplate:function(func,files){if(!func){return $()}var result=func({files:files,formatFileSize:this._formatFileSize,options:this.options});if(result instanceof $){return result}return $(this.options.templatesContainer).html(result).children()},_renderPreview:function(file,node){var that=this,options=this.options,dfd=$.Deferred();return((loadImage&&loadImage(file,function(img){node.append(img);that._forceReflow(node);that._transition(node).done(function(){dfd.resolveWith(node)});if(!$.contains(that.document[0].body,node[0])){dfd.resolveWith(node)}},{maxWidth:options.previewMaxWidth,maxHeight:options.previewMaxHeight,canvas:options.previewAsCanvas}))||dfd.resolveWith(node))&&dfd},_renderPreviews:function(files,nodes){var that=this,options=this.options;nodes.find('.preview span').each(function(index,element){var file=files[index];if(options.previewSourceFileTypes.test(file.type)&&($.type(options.previewSourceMaxFileSize)!=='number'||file.size<options.previewSourceMaxFileSize)){that._processingQueue=that._processingQueue.pipe(function(){var dfd=$.Deferred();that._renderPreview(file,$(element)).done(function(){dfd.resolveWith(that)});return dfd.promise()})}});return this._processingQueue},_renderUpload:function(files){return this._renderTemplate(this.options.uploadTemplate,files)},_renderDownload:function(files){return this._renderTemplate(this.options.downloadTemplate,files).find('a[download]').each(this._enableDragToDesktop).end()},_startHandler:function(e){e.preventDefault();var button=$(e.currentTarget),template=button.closest('.template-upload'),data=template.data('data');if(data&&data.submit&&!data.jqXHR&&data.submit()){button.prop('disabled',true)}},_cancelHandler:function(e){e.preventDefault();var template=$(e.currentTarget).closest('.template-upload'),data=template.data('data')||{};if(!data.jqXHR){data.errorThrown='abort';this._trigger('fail',e,data)}else{data.jqXHR.abort()}},_deleteHandler:function(e){e.preventDefault();var button=$(e.currentTarget);this._trigger('destroy',e,$.extend({context:button.closest('.template-download'),type:'DELETE',dataType:this.options.dataType},button.data()))},_forceReflow:function(node){return $.support.transition&&node.length&&node[0].offsetWidth},_transition:function(node){var dfd=$.Deferred();node.toggleClass('in');dfd.resolveWith(node);return dfd},_initButtonBarEventHandlers:function(){var fileUploadButtonBar=this.element.find('.fileupload-buttonbar'),filesList=this.options.filesContainer;this._on(fileUploadButtonBar.find('.start'),{click:function(e){e.preventDefault();filesList.find('.start button').click()}});this._on(fileUploadButtonBar.find('.cancel'),{click:function(e){e.preventDefault();filesList.find('.cancel button').click()}});this._on(fileUploadButtonBar.find('.delete'),{click:function(e){e.preventDefault();filesList.find('.delete input:checked').siblings('button').click();fileUploadButtonBar.find('.toggle').prop('checked',false)}});this._on(fileUploadButtonBar.find('.toggle'),{change:function(e){filesList.find('.delete input').prop('checked',$(e.currentTarget).is(':checked'))}})},_destroyButtonBarEventHandlers:function(){this._off(this.element.find('.fileupload-buttonbar button'),'click');this._off(this.element.find('.fileupload-buttonbar .toggle'),'change.')},_initEventHandlers:function(){this._super();this._on(this.options.filesContainer,{'click .start button':this._startHandler,'click .cancel button':this._cancelHandler,'click .delete button':this._deleteHandler});this._initButtonBarEventHandlers()},_destroyEventHandlers:function(){this._destroyButtonBarEventHandlers();this._off(this.options.filesContainer,'click');this._super()},_enableFileInputButton:function(){this.element.find('.fileinput-button input').prop('disabled',false).parent().removeClass('disabled')},_disableFileInputButton:function(){this.element.find('.fileinput-button input').prop('disabled',true).parent().addClass('disabled')},_initTemplates:function(){var options=this.options;options.templatesContainer=this.document[0].createElement(options.filesContainer.prop('nodeName'));if(tmpl){if(options.uploadTemplateId){options.uploadTemplate=tmpl(options.uploadTemplateId)}if(options.downloadTemplateId){options.downloadTemplate=tmpl(options.downloadTemplateId)}}},_initFilesContainer:function(){var options=this.options;if(options.filesContainer===undefined){options.filesContainer=this.element.find('.files')}else if(!(options.filesContainer instanceof $)){options.filesContainer=$(options.filesContainer)}},_stringToRegExp:function(str){var parts=str.split('/'),modifiers=parts.pop();parts.shift();return new RegExp(parts.join('/'),modifiers)},_initRegExpOptions:function(){var options=this.options;if($.type(options.acceptFileTypes)==='string'){options.acceptFileTypes=this._stringToRegExp(options.acceptFileTypes)}if($.type(options.previewSourceFileTypes)==='string'){options.previewSourceFileTypes=this._stringToRegExp(options.previewSourceFileTypes)}},_initSpecialOptions:function(){this._super();this._initFilesContainer();this._initTemplates();this._initRegExpOptions()},_create:function(){this._super();this._refreshOptionsList.push('filesContainer','uploadTemplateId','downloadTemplateId');if(!this._processingQueue){this._processingQueue=$.Deferred().resolveWith(this).promise();this.process=function(){return this._processingQueue}}},enable:function(){var wasDisabled=false;if(this.options.disabled){wasDisabled=true}this._super();if(wasDisabled){this.element.find('input, button').prop('disabled',false);this._enableFileInputButton()}},disable:function(){if(!this.options.disabled){this.element.find('input, button').prop('disabled',true);this._disableFileInputButton()}this._super()}})}));