import os
from azure.identity import DefaultAzureCredential
from azure.storage.queue import QueueServiceClient, QueueClient, QueueMessage
from azure.cosmos import CosmosClient
from dotenv import load_dotenv
import json
import uuid
import time
load_dotenv()
while True:
    try:
        # AUTH
        print("Azure Queue storage message CONSUMER running")

        queue_name = "microqueue"

        account_url = "https://microqueue.queue.core.windows.net"
        default_credential = DefaultAzureCredential(
            exclude_environment_credential=True)

        # Queue client
        queue_client = QueueClient(
            account_url, queue_name=queue_name, credential=default_credential)
        # Cosmos client
        endpoint = os.environ["COSMOS_ENDPOINT"]
        DATABASE_NAME = "store"
        CONTAINER_NAME = "sessions"

        cosmos_client = CosmosClient(
            url=endpoint, credential=default_credential)
        # PEEKING
        print("\nPeek at the messages in the queue...")
        peeked_messages = queue_client.peek_messages(max_messages=5)

        for peeked_message in peeked_messages:
            print("Message: " + peeked_message.content)

        # GETTING
        print("\nGetting messages from the queue...")
        messages = queue_client.receive_messages(messages_per_page=5)
        for msg in messages:
            print("Message: " + msg.content)
            print("Message ID: " + msg.id)
            print("Pop Receipt: " + msg.pop_receipt)
            print("Insertion Time: " + str(msg.inserted_on))
            print("Expiration Time: " + str(msg.expires_on))
            print("Time Next Visible: " + str(msg.next_visible_on))
            print("Dequeue Count: " + str(msg.dequeue_count))
            print("\n")
            msg_cntnt = json.loads(msg.content)
            msg_cntnt["id"] = uuid.uuid4().hex
            msg_cntnt["sessionId"] = str(uuid.uuid4().hex)
            # Write to cosmosdb
            print("Writing to CosmosDB...")
            container = cosmos_client.get_database_client(
                DATABASE_NAME).get_container_client(CONTAINER_NAME)
            print("upserting item...")

            container.upsert_item(msg_cntnt)
            # DELETING
            print("\nDeleting messages from the queue...")
            queue_client.delete_message(msg)
            time.sleep(5)
    except Exception as ex:
        print('Exception:')
        print(ex)
