import names
from random import randint
from datetime import datetime
from azure.identity import DefaultAzureCredential
from azure.storage.queue import QueueServiceClient, QueueClient, QueueMessage
import json
import time
while True:
    try:
        # AUTH
        print("Azure Queue storage message producer running")

        account_url = "https://microqueue.queue.core.windows.net"

        queue_name = "microqueue"
        default_credential = DefaultAzureCredential(
            exclude_environment_credential=True)

        queue_client = QueueClient(
            account_url, queue_name=queue_name, credential=default_credential)

        print("\nAdding messages to the queue...")

        message = {"customer_id": f"cust-{str(randint(0, 1000000))}",
                   "record_create_date": f"{datetime.now().strftime('%Y-%m-%d %H:%M:%S')}",
                   "name": names.get_full_name(),
                   "sale_price": randint(0, 1000000),
                   "quantity": randint(0, 1000000)
                   }
        queue_client.send_message(json.dumps(message))
        time.sleep(5)
    except Exception as ex:
        print('Exception:')
        print(ex)
