import pefile, sys

dll_names = ['kernel32.dll', 'ws2_32.dll', 'ole32.dll', 'user32.dll', 'advapi32.dll', 'shell32.dll', 'urlmon.dll', 'wininet.dll']
print('api_names = [')
first = True
for dll in sys.argv[1:]:
    try:
        pe = pefile.PE(dll)
        try:
            for exp in pe.DIRECTORY_ENTRY_EXPORT.symbols:
                if exp.name:
                    name = exp.name.decode('utf-8')
                    if not first:
                        print(',',end='')
                    first = False
                    print(f'"{name}"', end='')
        except:
            pass
    except:
        pass
print(']')
