#!/usr/bin/python3

# Task 6
# - multiple decryption calls
# - tracking arguments of the decryption function
# - reconstructing a homebrew xor algorithm

from decoder_core import *
from capstone import *
from capstone.x86 import *

class Decoder(TrainingDecoder):
    def __init__(self):
        # MD5 hash of the correctly decrypted file
        self.already_done = []
        super().__init__()

    def on_function_call(self, src_va, dst_va):
        # This function is called by the framework every time a CALL instruction 
        # is identified in the code
        # src_va is the virtual address of the CALL instruction
        # dst_va is the virtual address of the function that is called

        if dst_va == None : # <-- 1. Insert the virtual address of Coder::decryptString() 
            string_va = self.reg_read(X86_REG_RSI)
            self.decrypt_string(string_va, self.reg_read(X86_REG_RDX))
			

    def decrypt_string(self, string_va, string_len):
        if string_va in self.already_done:
            return
        # The string may be referenced many times, but has to 
        # be decrypted only once
        self.already_done.append(string_va)

        # 2. Set the proper length of the decryption key
        key_len = None
        # 3. Set the proper virtual address of the decryption key
        key_va = None

        key_offset = self.format.VAToRaw(key_va)
        key = self.data[key_offset:key_offset+key_len]

        string_offset = self.format.VAToRaw(string_va)
        if string_offset == 0:
            return
        if string_offset+string_len>len(self.data):
            return

        for i in range(0,string_len):
            self.data[string_offset+i] = None # <--- 4. Replace with a dynamic expression, reversed from the code

    def decode(self):
        # Check if the results are correct
        self.check_results()

# Create the decryptor object. Automation happens in __init__()
Decoder()

