#!/usr/bin/python3

# Task 7
# - multiple decryption routines
# - each string decrypted separately
# - reconstructing homebrew xor algorithms
# - operating on different item sizes

from decoder_core import *

class Decoder(TrainingDecoder):
    def __init__(self):
        self.already_done = []
        super().__init__()

    def on_function_call(self, src_va, dst_va):
        # This function is called by the framework every time a CALL instruction 
        # is identified in the code
        # src_va is the virtual address of the CALL instruction
        # dst_va is the virtual address of the function that is called

        if dst_va == 0x11524: 
            # Decrypt wide strings
            string_va = self.stack_read(4) # [esp+4] -> second parameter on stack
            if string_va in self.already_done:
                return
            self.already_done.append(string_va)

            string_offset = self.format.VAToRaw(string_va)
            if string_offset <= 0 or string_offset > len(self.data):
                return
            # 1. Insert the seed value here
            seed = REPLACE_WITH_THE_SOLUTION
            i = 0
            while True:
                seed = None # <-- 2. Replace None with a dynamic expression to calculate the seed
                val = struct.unpack("<H", self.data[string_offset+i:string_offset+i+2])[0]
                if val == 0:
                    break
                val = ( val ^ ( ( seed >> 16 ) | 0x8000 ) ) & 0xFFFF
                self.data[string_offset+i:string_offset+i+2] = struct.pack("<H", val)
                i = i + 2

        elif dst_va == 0x11582:
            # Decrypt 1-byte strings
            string_va = self.stack_read(4) # [esp+4] -> second parameter on stack
            if string_va in self.already_done:
                return
            self.already_done.append(string_va)

            string_offset = self.format.VAToRaw(string_va)
            if string_offset <= 0 or string_offset > len(self.data):
                return
            # 3. Insert the seed value here
            seed = REPLACE_WITH_THE_SOLUTION
            i = 0
            while True:
                seed = None # <-- 4. Replace None with a dynamic expression to calculate the seed
                val = self.data[string_offset+i]
                if val == 0:
                    break
                val = ( val ^ ( ( seed >> 16 ) | 0x80 ) ) & 0xFF
                self.data[string_offset+i] = val
                i = i + 1

        elif dst_va == 0x12416:
            # Decrypt wide strings, a different type of them
            string_va = self.stack_read(0) # [esp] -> first parameter on stack
            if string_va in self.already_done:
                return
            self.already_done.append(string_va)
 
            string_offset = self.format.VAToRaw(string_va)
            if string_offset <= 0 or string_offset > len(self.data):
                return
            i = 0
            while True:
                val = struct.unpack("<H", self.data[string_offset+i:string_offset+i+2])[0]
                if val == 0:
                    break
                val = val ^ 0 # <-- 5.  Replace 0 with a correct decryption key
                self.data[string_offset+i:string_offset+i+2] = struct.pack("<H", val)
                i = i + 2

    def decode(self):
        # Check if the results are correct
        self.check_results()

# Create the decryptor object. Automation happens in __init__()
Decoder()

