#!/usr/bin/python3

import api_names
import ida_idaapi, ida_bytes, ida_ua, ida_ida

def calc_api_hash(name):
    result = 0
    # 1. Fill in the missing hash calculation to make the script work for the sample
    return result

print('Calculating API hashes...')
api_hashes={}
for name in api_names.api_names:
    api_hashes[calc_api_hash(name)] = name

print('Checking the code...')
ea = ida_ida.cvar.inf.min_ea
while True:
    ea = ida_bytes.next_head(ea, ida_ida.cvar.inf.max_ea)
    if ea == ida_idaapi.BADADDR:
        break
    if ida_bytes.is_code(ida_bytes.get_flags(ea)):
        ins = ida_ua.insn_t()
        if ida_ua.decode_insn(ins, ea):
            for op in ins.ops:
                if op.type == ida_ua.o_imm:
                    v = op.value
                    if op.value in api_hashes:
                        ida_bytes.set_cmt(ea, api_hashes[op.value], False)
