#!/usr/bin/python3

import api_names_task12, ida_bytes, ida_name

def calc_api_hash(name):
    result = 0
    for c in name:
        result = (( result >> 0xD ) | ( result << (32-0xD) ) ) & 0xFFFFFFFF
        result = ( result + ord(c) ) & 0xFFFFFFFF
    return result

print('Calculating API hashes...')
api_hashes={}
for name in api_names_task12.api_names:
    api_hashes[calc_api_hash(name)] = name

print('Checking the data...')
# 1. Set the range to the offsets of the API hash DWORD array,
# then load this script in IDA (File->Script file)
for ea in range(None,None,None):
    h = ida_bytes.get_dword(ea)
    if not h in api_hashes:
        raise Exception("Hash is not resolved")
    print(f"hex({h}) = {api_hashes[h]}")
    ida_bytes.set_cmt(ea, api_hashes[h], False)
    ida_name.set_name(ea, api_hashes[h])

