#!/usr/bin/python3

from decoder_core import *
import struct

class Decoder(TrainingDecoder):
    def decode(self):
        dw_8DB4 = struct.unpack("<L", self.data[0x8db4:0x8db4+4])[0]
        dw_8DB8 = struct.unpack("<L", self.data[0x8db8:0x8db8+4])[0]
        dw_8DBC = struct.unpack("<L", self.data[0x8dbc:0x8dbc+4])[0]

        payload_len = dw_8DB4 + dw_8DB8 + dw_8DBC
        payload = self.data[0x8DC0:0x8DC0+payload_len]
        for i in range(payload_len-1, -1, -1):
            payload[i] = None # <---- 1. Replace None with a dynamic expression to decrypt the payload

        for i in range(0x100, -1, -1):
            tmp = payload[dw_8DBC+i*2 - 2]
            # 2. Complete the for loop to unscramble the payload
        
        self.data = payload[dw_8DBC:dw_8DBC+dw_8DB4]

        # 3 (optional). Also, extract the decoy document      
        self.check_results()

Decoder()

