//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using System;
using System.IO;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using EditorCore;
//using ModelSystem;
using Rendering;

// 
// This source code was auto-generated by xsd, Version=2.0.50727.42.
// 


namespace ModelSystem
{
   public enum RenderModeMask
   {
      Model = 0x0001,
      PlayerColor = 0x0002,
      Skeleton = 0x0004,
      BoneAxis = 0x0008,
      BoneNames = 0x0010,
      BoundingBox = 0x0020,
      MeshBoxes = 0x0040,
      Markers = 0x0080,
      StatsInfo = 0x0100,
   }


   public abstract class XMLVisualNode
   {
      public virtual void copy(XMLVisualNode node) {}
      public abstract XMLVisualNode clone(bool deepCopy);


      public virtual bool canAdd(XMLVisualNode node) { return false; }
      public virtual bool addChild(XMLVisualNode node) { return false; }
      public virtual bool insertChild(int index, XMLVisualNode node) { return false; }
      public virtual bool removeChild(XMLVisualNode node) { return false; }
      public virtual int indexOf(XMLVisualNode node) { return -1; }

      public virtual void resort() {}

      public abstract bool isNodeValid();
      public abstract bool isBranchValid();

      public abstract TreeNode   createTreeNode();
      public abstract void       updateTreeNodeText(TreeNode node);
   }

   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   [System.Xml.Serialization.XmlRootAttribute(Namespace = "", IsNullable = false)]
   public partial class visual : XMLVisualNode
   {

      private List<visualModel> modelField = new List<visualModel>();

      private string defaultmodelField = "Default";

      private visualLogic logicField;

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("model")]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public List<visualModel> model
      {
         get { return this.modelField; }
         set { this.modelField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string defaultmodel
      {
         get { return this.defaultmodelField; }
         set { this.defaultmodelField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualLogic logic
      {
         get { return this.logicField; }
         set { this.logicField = value; }
      }


      private BBoundingBox m_boundingBox = new BBoundingBox();

      [System.Xml.Serialization.XmlIgnore]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public BBoundingBox boundingBox
      {
         get { return this.m_boundingBox; }
      }


      [System.Xml.Serialization.XmlIgnore]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public static BRenderDebugCubeHighlight s_renderCubeHighlight = null;
      public static BRenderDebugDiamond s_renderAttackMarker = null;
      public static BRenderDebugDiamond s_renderParticleMarker = null;
      public static BRenderDebugDiamond s_renderTerrainEffectMarker = null;
      public static BRenderDebugDiamond s_renderPointMarker = null;
      public static BRenderDebugDiamond s_renderSoundMarker = null;
      public static BRenderDebugDiamond s_renderLightMarker = null;
      public static BRenderDebugDiamond s_renderGroundIKMarker = null;
      public static BRenderDebugDiamond s_renderAttachTargetMarker = null;
      public static BRenderDebugDiamond s_renderSweetSpotMarker = null;


      public visual()
      {
         if (s_renderParticleMarker == null)
         {
            float width_over_two = 0.5f;
            s_renderCubeHighlight = new BRenderDebugCubeHighlight(new Vector3(-width_over_two, -width_over_two, -width_over_two),
                                                                new Vector3(width_over_two, width_over_two, width_over_two), Color.Yellow.ToArgb(), 0.1f);

            s_renderAttackMarker = new BRenderDebugDiamond(0.2f, Color.Red.ToArgb(), true);
            s_renderParticleMarker = new BRenderDebugDiamond(0.2f, Color.Orange.ToArgb(), true);
            s_renderTerrainEffectMarker = new BRenderDebugDiamond(0.2f, Color.Brown.ToArgb(), true);
            s_renderPointMarker = new BRenderDebugDiamond(0.2f, Color.Aqua.ToArgb(), true);
            s_renderSoundMarker = new BRenderDebugDiamond(0.2f, Color.Green.ToArgb(), true);
            s_renderLightMarker = new BRenderDebugDiamond(0.2f, Color.White.ToArgb(), true);
            s_renderGroundIKMarker = new BRenderDebugDiamond(0.2f, Color.Magenta.ToArgb(), true);
            s_renderAttachTargetMarker = new BRenderDebugDiamond(0.2f, Color.Blue.ToArgb(), true);
            s_renderSweetSpotMarker = new BRenderDebugDiamond(0.2f, Color.Yellow.ToArgb(), true);
         }
      }

      ~visual()
      {
         destroy();
      
      }
       
      public static void destoyStatics()
      {
         if (s_renderCubeHighlight != null)
         {
            s_renderCubeHighlight.destroy();
            s_renderCubeHighlight = null;
         }
         if (s_renderAttackMarker != null)
         {
            s_renderAttackMarker.destroy();
            s_renderAttackMarker = null;
         }
         if (s_renderParticleMarker != null)
         {
            s_renderParticleMarker.destroy();
            s_renderParticleMarker = null;
         }
         if (s_renderTerrainEffectMarker != null)
         {
            s_renderTerrainEffectMarker.destroy();
            s_renderTerrainEffectMarker = null;
         }
         if (s_renderPointMarker != null)
         {
            s_renderPointMarker.destroy();
            s_renderPointMarker = null;
         }
         if (s_renderSoundMarker != null)
         {
            s_renderSoundMarker.destroy();
            s_renderSoundMarker = null;
         }
         if (s_renderLightMarker != null)
         {
            s_renderLightMarker.destroy();
            s_renderLightMarker = null;
         }
         if (s_renderGroundIKMarker != null)
         {
            s_renderGroundIKMarker.destroy();
            s_renderGroundIKMarker = null;
         }
         if (s_renderAttachTargetMarker != null)
         {
            s_renderAttachTargetMarker.destroy();
            s_renderAttachTargetMarker = null;
         }
         if (s_renderSweetSpotMarker != null)
         {
            s_renderSweetSpotMarker.destroy();
            s_renderSweetSpotMarker = null;
         }
         if (s_renderCubeHighlight != null)
         {
            s_renderCubeHighlight.destroy();
            s_renderCubeHighlight = null;
         }
      }
      public void destroy()
      {
        
         
      }

      public void render(TreeNode selectedNode, RenderModeMask renderMode)
      {
         object selectedObject = selectedNode.Tag;

         // If visual
         visual visual = selectedObject as visual;
         if (visual != null)
         {
            render(renderMode);
         }

         // If model
         visualModel model = selectedObject as visualModel;
         if (model != null)
         {
            renderModel(model, renderMode);
         }

         // If component
         visualModelComponent component = selectedObject as visualModelComponent;
         if (component != null)
         {
            renderComponent(component, renderMode, selectedNode.Parent.Tag as visualModel);
         }

         // If attachment
         visualModelComponentOrAnimAttach attach = selectedObject as visualModelComponentOrAnimAttach;
         if (attach != null)
         {
            // render model
            render(selectedNode.Parent, renderMode);

            // render highlight over attachment
            visualModel vmodel = null;
            vmodel = selectedNode.Parent.Parent.Tag as visualModel;
            renderAttachment(attach, renderMode, vmodel, true);
         }

         // If point
         visualModelComponentPoint point = selectedObject as visualModelComponentPoint;
         if (point != null)
         {
            // render model
            render(selectedNode.Parent, renderMode);

            // render highlight over point
            visualModel vmodel = null;
            vmodel = selectedNode.Parent.Parent.Tag as visualModel;
            renderPoint(point, renderMode, vmodel, true);
         }

         // If anim
         visualModelAnim anim = selectedObject as visualModelAnim;
         if (anim != null)
         {
            // render model
            render(selectedNode.Parent, renderMode);

            // render extra attachments
            foreach(visualModelComponentOrAnimAttach curAttach in anim.attach)
            {
               renderAttachment(curAttach, renderMode, selectedNode.Parent.Tag as visualModel, false);
            }
         }

         // If anim asset
         visualModelAnimAsset animAsset = selectedObject as visualModelAnimAsset;
         if (animAsset != null)
         {
            // render model
            render(selectedNode.Parent, renderMode);

            // render all tags
            foreach (visualModelAnimAssetTag curTag in animAsset.tag)
            {
               renderAnimTag(curTag, renderMode, selectedNode.Parent.Parent.Tag as visualModel, animAsset, false);
            }
         }

         // If anim asset tag
         visualModelAnimAssetTag animAssetTag = selectedObject as visualModelAnimAssetTag;
         if (animAssetTag != null)
         {
            // render anim
            render(selectedNode.Parent, renderMode);

            visualModel vmodel = null;
            vmodel = selectedNode.Parent.Parent.Parent.Tag as visualModel;
            renderAnimTag(animAssetTag, renderMode, vmodel, selectedNode.Parent.Tag as visualModelAnimAsset, true);
         }

         // If asset
         visualModelComponentAsset compAsset = selectedObject as visualModelComponentAsset;
         if (compAsset != null)
         {
            renderComponentAsset(compAsset, renderMode);
         }

         // If logic data
         visualLogic logic = selectedObject as visualLogic;
         if (logic != null)
         {
            renderLogic(logic, renderMode);
         }

         // If logic data
         visualLogicData logicData = selectedObject as visualLogicData;
         if (logicData != null)
         {
            renderLogicData(logicData, renderMode);
         }


         // Render bounding box if necessary
         if ((renderMode & RenderModeMask.BoundingBox) != 0)
         {
            // Enable AA
            BRenderDevice.getDevice().SetRenderState(RenderStates.AlphaBlendEnable, true);
            BRenderDevice.getDevice().SetRenderState(RenderStates.AntialiasedLineEnable, true);

            BRenderDebugCube box = new BRenderDebugCube(m_boundingBox.min, m_boundingBox.max, Color.Yellow.ToArgb(), false);
            box.render();

            // Disable AA
            BRenderDevice.getDevice().SetRenderState(RenderStates.AlphaBlendEnable, false);
            BRenderDevice.getDevice().SetRenderState(RenderStates.AntialiasedLineEnable, false);
         }
      }

      public void render(RenderModeMask renderMode)
      {
         foreach (visualModel curModel in modelField)
         {
            if(string.Compare(defaultmodelField, curModel.name, true) == 0)
            {
               renderModel(curModel, renderMode);
            }
         }
      }

      public void renderModel(visualModel curModel, RenderModeMask renderMode)
      {
         if (curModel.component != null)
         {
            renderComponent(curModel.component, renderMode, curModel);
         }
      }

      public void renderComponent(visualModelComponent curComponent, RenderModeMask renderMode, visualModel curModel)
      {
         // Render component asset
         if (curComponent.asset != null)
         {
            renderComponentAsset(curComponent.asset, renderMode);
         }
         else if(curComponent.logic != null)
         {
            renderLogic(curComponent.logic, renderMode);
         }


         // Render attachments
         foreach (visualModelComponentOrAnimAttach curAttachment in curComponent.attach)
         {
            renderAttachment(curAttachment, renderMode, curModel, false);
         }

         // Render points
         foreach (visualModelComponentPoint curPoint in curComponent.point)
         {
            renderPoint(curPoint, renderMode, curModel, false);
         }
      }

      public void renderComponentAsset(visualModelComponentAsset curCompAsset, RenderModeMask renderMode)
      {
         // Render component asset
         switch(curCompAsset.type)
         {
            case visualModelComponentAsset.ComponentAssetType.Model:
               {
                  if (curCompAsset.mInstance != null)
                  {
                     if ((renderMode & RenderModeMask.Model) != 0)
                     {
                        if ((renderMode & RenderModeMask.PlayerColor) != 0)
                           curCompAsset.mInstance.render(new Vector3(0.0f, 0.0f, 1.0f), true);
                        else
                           curCompAsset.mInstance.render();
                     }

                     if ((renderMode & RenderModeMask.Skeleton) != 0)
                        curCompAsset.mInstance.renderSkeleton();

                     if ((renderMode & RenderModeMask.BoneAxis) != 0)
                        curCompAsset.mInstance.renderBoneAxis();

                     if ((renderMode & RenderModeMask.BoneNames) != 0)
                        curCompAsset.mInstance.renderBoneNames();
                     
                     if ((renderMode & RenderModeMask.MeshBoxes) != 0)
                        curCompAsset.mInstance.renderMeshBoxes();
                     
                     if ((renderMode & RenderModeMask.StatsInfo) != 0)
                        curCompAsset.mInstance.renderStatsInfo();
                  }
               }
               break;

            case visualModelComponentAsset.ComponentAssetType.Light:
               {
                  if ((renderMode & RenderModeMask.Markers) != 0)
                  {
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                     visual.s_renderLightMarker.render();
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                  }
               }
               break;

            case visualModelComponentAsset.ComponentAssetType.Particle:
               {
                  if ((renderMode & RenderModeMask.Markers) != 0)
                  {
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                     visual.s_renderParticleMarker.render();
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                  }
               }
               break;
         }
      }

      public void renderAttachment(visualModelComponentOrAnimAttach curAttachment, RenderModeMask renderMode, visualModel curModel, bool bHighlight)
      {
         // Saved world matrix
         Matrix savedWorldMat = BRenderDevice.getDevice().GetTransform(TransformType.World);
         
         // Apply world transform first
         Matrix worldMat;
         Matrix toMat = Matrix.Identity;
         Matrix fromMat = Matrix.Identity;


         // Get model we are attaching to
         ModelSystem.GrannyInstance attachedToInstance = null;

         if((curModel != null) && (curModel.component != null))
         {
            if (curModel.component.asset != null)
            {
               attachedToInstance = curModel.component.asset.mInstance;
            }
            else if ((curModel.component.logic != null) &&
                     (curModel.component.logic.type == visualLogic.LogicType.Variation) &&
                     (curModel.component.logic.logicdata.Count > curModel.component.logic.selectedItem))
            {
               visualLogicData curLogicData = curModel.component.logic.logicdata[curModel.component.logic.selectedItem];
               if (curLogicData.asset != null)
               {
                  attachedToInstance = curLogicData.asset.mInstance;
               }
            }
         }


         // Get model that is being attached
         ModelSystem.GrannyInstance attachmentInstance = null;

         // If dealing with a modelref get get instance for it, else use attachment instance
         if (curAttachment.type == visualModelComponentOrAnimAttach.AttachType.ModelRef)
         {
            foreach (visualModel curRefModel in model)
            {
               if (string.Compare(curRefModel.name, curAttachment.name, true) == 0)
               {
                  if ((curRefModel.component != null) && (curRefModel.component.asset != null))
                  {
                     attachmentInstance = curRefModel.component.asset.mInstance;
                  }
               }
            }
         }
         else
         {
            attachmentInstance = curAttachment.mInstance;
         }


         if ((attachedToInstance != null) && (attachedToInstance.getBone(curAttachment.tobone, ref toMat)))
         {
            if ((attachmentInstance != null) && (attachmentInstance.getBone(curAttachment.frombone, ref fromMat)))
            {
               fromMat.Invert();
               worldMat = Matrix.Multiply(fromMat, toMat);
            }
            else
               worldMat = toMat;
         }
         else
         {
            if ((attachmentInstance != null) && (attachmentInstance.getBone(curAttachment.frombone, ref fromMat)))
            {
               fromMat.Invert();
               worldMat = fromMat;
            }
            else
               worldMat = Matrix.Identity;
         }

         if(curAttachment.disregardorient)
         {
            worldMat.M11 = 1.0f; worldMat.M12 = 0.0f; worldMat.M13 = 0.0f;
            worldMat.M21 = 0.0f; worldMat.M22 = 1.0f; worldMat.M23 = 0.0f;
            worldMat.M31 = 0.0f; worldMat.M32 = 0.0f; worldMat.M33 = 1.0f;
         }

         worldMat.Multiply(savedWorldMat);
         BRenderDevice.getDevice().SetTransform(TransformType.World, worldMat);


         if (!bHighlight)
         {

            // Render
            switch (curAttachment.type)
            {
               case visualModelComponentOrAnimAttach.AttachType.ModelFile:
                  {
                     if (curAttachment.mInstance != null)
                     {
                        if ((renderMode & RenderModeMask.Model) != 0)
                        {
                           if ((renderMode & RenderModeMask.PlayerColor) != 0)
                              curAttachment.mInstance.render(new Vector3(0.0f, 0.0f, 1.0f), true);
                           else
                              curAttachment.mInstance.render();
                        }

                        if ((renderMode & RenderModeMask.Skeleton) != 0)
                           curAttachment.mInstance.renderSkeleton();

                        if ((renderMode & RenderModeMask.BoneAxis) != 0)
                           curAttachment.mInstance.renderBoneAxis();

                        if ((renderMode & RenderModeMask.BoneNames) != 0)
                           curAttachment.mInstance.renderBoneNames();

                        if ((renderMode & RenderModeMask.MeshBoxes) != 0)
                           curAttachment.mInstance.renderMeshBoxes();

                        if ((renderMode & RenderModeMask.StatsInfo) != 0)
                           curAttachment.mInstance.renderStatsInfo();
                     }
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.ParticleFile:
                  {
                     if ((renderMode & RenderModeMask.Markers) != 0)
                     {
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                        visual.s_renderParticleMarker.render();
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                     }
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.TerrainEffect:
                  {
                     if ((renderMode & RenderModeMask.Markers) != 0)
                     {
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                        visual.s_renderTerrainEffectMarker.render();
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                     }
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.ModelRef:
                  {
                     foreach (visualModel curRefModel in model)
                     {
                        if (string.Compare(curRefModel.name, curAttachment.name, true) == 0)
                        {
                           renderModel(curRefModel, renderMode);
                        }
                     }
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.LightFile:
                  {
                     if ((renderMode & RenderModeMask.Markers) != 0)
                     {
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                        visual.s_renderLightMarker.render();
                        BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                     }
                  }
                  break;
            }
         }
         else
         {
            BBoundingBox box = new BBoundingBox();
            box.empty();

            // Render
            switch (curAttachment.type)
            {
               case visualModelComponentOrAnimAttach.AttachType.ModelFile:
                  {
                     if (curAttachment.mInstance != null)
                     {
                        box.addBox(curAttachment.mInstance.mStaticBoundingBox);
                     }
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.ParticleFile:
               case visualModelComponentOrAnimAttach.AttachType.LightFile:
               case visualModelComponentOrAnimAttach.AttachType.TerrainEffect:
                  {
                     box.max = new Vector3(0.2f, 0.2f, 0.2f);
                     box.min = new Vector3(-0.2f, -0.2f, -0.2f);
                  }
                  break;

               case visualModelComponentOrAnimAttach.AttachType.ModelRef:
                  {
                     foreach (visualModel curRefModel in model)
                     {
                        if (string.Compare(curRefModel.name, curAttachment.name, true) == 0)
                        {
                           if((curRefModel.component != null) && (curRefModel.component.asset != null) &&(curRefModel.component.asset.mInstance != null))
                           {
                              box.addBox(curRefModel.component.asset.mInstance.mStaticBoundingBox);
                           }
                           break;
                        }
                     }
                  }
                  break;
            }

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);

            visual.s_renderCubeHighlight = new BRenderDebugCubeHighlight(box.min, box.max, Color.Yellow.ToArgb(), 0.1f);
            visual.s_renderCubeHighlight.render();

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
         }


         BRenderDevice.getDevice().SetTransform(TransformType.World, savedWorldMat);
      }

      public void renderPoint(visualModelComponentPoint curPoint, RenderModeMask renderMode, visualModel curModel, bool bHighLight)
      {
         // Saved world matrix
         Matrix savedWorldMat = BRenderDevice.getDevice().GetTransform(TransformType.World);


         // Apply world transform first
         Matrix worldMat;
         Matrix toMat = Matrix.Identity;


         // Get model we are attaching to
         ModelSystem.GrannyInstance attachedToInstance = null;

         if ((curModel != null) && (curModel.component != null))
         {
            if (curModel.component.asset != null)
            {
               attachedToInstance = curModel.component.asset.mInstance;
            }
            else if ((curModel.component.logic != null) &&
                     (curModel.component.logic.type == visualLogic.LogicType.Variation) &&
                     (curModel.component.logic.logicdata.Count > curModel.component.logic.selectedItem))
            {
               visualLogicData curLogicData = curModel.component.logic.logicdata[curModel.component.logic.selectedItem];
               if (curLogicData.asset != null)
               {
                  attachedToInstance = curLogicData.asset.mInstance;
               }
            }
         }

         if ((attachedToInstance != null) && (attachedToInstance.getBone(curPoint.bone, ref toMat)))
         {
            worldMat = toMat;
         }
         else
         {
            worldMat = Matrix.Identity;
         }

         worldMat.Multiply(savedWorldMat);

         // remove scaling and orientation
         worldMat.M11 = 1.0f;
         worldMat.M12 = 0.0f;
         worldMat.M13 = 0.0f;
         worldMat.M21 = 0.0f;
         worldMat.M22 = 1.0f;
         worldMat.M23 = 0.0f;
         worldMat.M31 = 0.0f;
         worldMat.M32 = 0.0f;
         worldMat.M33 = 1.0f;


         BRenderDevice.getDevice().SetTransform(TransformType.World, worldMat);


         // Render
         if (!bHighLight)
         {
            switch (curPoint.pointType)
            {
               case visualModelComponentPoint.ComponentPointType.HitpointBar:
               case visualModelComponentPoint.ComponentPointType.Impact:
               case visualModelComponentPoint.ComponentPointType.Launch:
               case visualModelComponentPoint.ComponentPointType.Cover:
                  if ((renderMode & RenderModeMask.Markers) != 0)
                  {
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);
                     visual.s_renderPointMarker.render();
                     BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
                  }
                  break;
            }
         }
         else
         {
            BBoundingBox box = new BBoundingBox();
            box.empty();

            box.max = new Vector3(0.2f, 0.2f, 0.2f);
            box.min = new Vector3(-0.2f, -0.2f, -0.2f);

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);

            visual.s_renderCubeHighlight = new BRenderDebugCubeHighlight(box.min, box.max, Color.Yellow.ToArgb(), 0.1f);
            visual.s_renderCubeHighlight.render();

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
         }


         BRenderDevice.getDevice().SetTransform(TransformType.World, savedWorldMat);
      }

      public void renderAnimTag(visualModelAnimAssetTag curTag, RenderModeMask renderMode, visualModel curModel, visualModelAnimAsset curAnimAsset, bool bHighLight)
      {
         // Only render if dealing with a particle or sound or light or ground IK or attach target or sweet spot or kill&throw tag
         if ((curTag.type != visualModelAnimAssetTag.TagType.Attack) &&
             (curTag.type != visualModelAnimAssetTag.TagType.Particle) && 
             (curTag.type != visualModelAnimAssetTag.TagType.TerrainEffect) &&
             (curTag.type != visualModelAnimAssetTag.TagType.Sound) &&
             (curTag.type != visualModelAnimAssetTag.TagType.Light) &&
             (curTag.type != visualModelAnimAssetTag.TagType.GroundIK) &&
             (curTag.type != visualModelAnimAssetTag.TagType.AttachTarget) &&
             (curTag.type != visualModelAnimAssetTag.TagType.SweetSpot) &&
             (curTag.type != visualModelAnimAssetTag.TagType.KillAndThrow) &&
             (curTag.type != visualModelAnimAssetTag.TagType.PhysicsImpulse))
            return;

         // Saved world matrix
         Matrix savedWorldMat = BRenderDevice.getDevice().GetTransform(TransformType.World);


         // Apply world transform first
         Matrix worldMat;
         Matrix toMat = Matrix.Identity;


         // Get model we are attaching to
         ModelSystem.GrannyInstance attachedToInstance = null;

         if ((curModel != null) && (curModel.component != null))
         {
            if (curModel.component.asset != null)
            {
               attachedToInstance = curModel.component.asset.mInstance;
            }
            else if ((curModel.component.logic != null) &&
                     (curModel.component.logic.type == visualLogic.LogicType.Variation) &&
                     (curModel.component.logic.logicdata.Count > curModel.component.logic.selectedItem))
            {
               visualLogicData curLogicData = curModel.component.logic.logicdata[curModel.component.logic.selectedItem];
               if (curLogicData.asset != null)
               {
                  attachedToInstance = curLogicData.asset.mInstance;
               }
            }
         }

         if ((attachedToInstance != null) && (attachedToInstance.getBone(curTag.tobone, ref toMat)))
         {
            worldMat = toMat;
         }
         else
         {
            worldMat = Matrix.Identity;
         }

         if (curTag.disregardorient)
         {
            worldMat.M11 = 1.0f; worldMat.M12 = 0.0f; worldMat.M13 = 0.0f;
            worldMat.M21 = 0.0f; worldMat.M22 = 1.0f; worldMat.M23 = 0.0f;
            worldMat.M31 = 0.0f; worldMat.M32 = 0.0f; worldMat.M33 = 1.0f;
         }


         worldMat.Multiply(savedWorldMat);
         BRenderDevice.getDevice().SetTransform(TransformType.World, worldMat);


         // Render
         if (!bHighLight)
         {
            if ((renderMode & RenderModeMask.Markers) != 0)
            {
               BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);

               switch (curTag.type)
               {
                  case visualModelAnimAssetTag.TagType.Attack:
                  case visualModelAnimAssetTag.TagType.KillAndThrow:
                  case visualModelAnimAssetTag.TagType.PhysicsImpulse:
                     visual.s_renderAttackMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.Particle:
                     visual.s_renderParticleMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.TerrainEffect:
                     visual.s_renderTerrainEffectMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.Sound:
                     visual.s_renderSoundMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.Light:
                     visual.s_renderLightMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.GroundIK:
                     visual.s_renderGroundIKMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.AttachTarget:
                     visual.s_renderAttachTargetMarker.render();
                     break;
                  case visualModelAnimAssetTag.TagType.SweetSpot:
                     visual.s_renderSweetSpotMarker.render();
                     break;
               }
               BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
            }
         }
         else
         {
            BBoundingBox box = new BBoundingBox();
            box.empty();

            box.max = new Vector3(0.2f, 0.2f, 0.2f);
            box.min = new Vector3(-0.2f, -0.2f, -0.2f);

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);

            visual.s_renderCubeHighlight = new BRenderDebugCubeHighlight(box.min, box.max, Color.Yellow.ToArgb(), 0.1f);
            visual.s_renderCubeHighlight.render();

            BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
         }

         // Render trigger time marker
         float cTagTriggerVisibleTime = 0.3f;
         float cTagTriggerStartSize = 0.15f;
         float cTagTriggerEndsize = 0.8f; 
         
         if (attachedToInstance != null)
         {
            GrannyAnimation curGrannyAnimation = GrannyManager2.getAnimation(curAnimAsset.mAnimId);
            if (curGrannyAnimation != null)
            {
               // Get duration
               float animationDuration = curGrannyAnimation.getDuration();

               float curNormalizedTime = attachedToInstance.getClock() / animationDuration;
               float tagTriggerVisibleNormalizedTime = cTagTriggerVisibleTime / animationDuration;

               float timeDelta;
               if(curNormalizedTime >= (float)curTag.position)
                  timeDelta = curNormalizedTime - (float)curTag.position;
               else
                  timeDelta = (curNormalizedTime + 1.0f) - (float)curTag.position;

               if ((timeDelta >= 0.0f) && (timeDelta < tagTriggerVisibleNormalizedTime))
               {
                  float factor = timeDelta / tagTriggerVisibleNormalizedTime;

                  BBoundingBox box = new BBoundingBox();
                  box.empty();

                  float size = cTagTriggerStartSize + factor * (cTagTriggerEndsize - cTagTriggerStartSize);

                  int color = 0;
                  if (bHighLight)
                  {
                     color = Color.Yellow.ToArgb();
                  }
                  else
                  {
                     switch (curTag.type)
                     {
                        case visualModelAnimAssetTag.TagType.Attack:
                        case visualModelAnimAssetTag.TagType.KillAndThrow:
                        case visualModelAnimAssetTag.TagType.PhysicsImpulse:
                           color = visual.s_renderAttackMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.Particle:
                           color = visual.s_renderParticleMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.TerrainEffect:
                           color = visual.s_renderTerrainEffectMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.Sound:
                           color = visual.s_renderSoundMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.Light:
                           color = visual.s_renderLightMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.GroundIK:
                           color = visual.s_renderGroundIKMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.AttachTarget:
                           color = visual.s_renderAttachTargetMarker.color;
                           break;
                        case visualModelAnimAssetTag.TagType.SweetSpot:
                           color = visual.s_renderSweetSpotMarker.color;
                           break;
                     }
                  }


                  // add fade
                  color = ((int)(255 * (1.0f - factor)) << 24) | (color & 0x00ffffff);

                  
                  Matrix savedViewMat = BRenderDevice.getDevice().GetTransform(TransformType.View);

                  savedViewMat.Invert();
                  worldMat.M11 = savedViewMat.M11; worldMat.M12 = savedViewMat.M12; worldMat.M13 = savedViewMat.M13;
                  worldMat.M21 = savedViewMat.M21; worldMat.M22 = savedViewMat.M22; worldMat.M23 = savedViewMat.M23;
                  worldMat.M31 = savedViewMat.M31; worldMat.M32 = savedViewMat.M32; worldMat.M33 = savedViewMat.M33;


                  BRenderDevice.getDevice().SetTransform(TransformType.World, worldMat);

                  BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, false);

                  BRenderDebug2CircleHighlight circleHighLight = new BRenderDebug2CircleHighlight(size, color);
                  circleHighLight.render();

                  BRenderDevice.getDevice().SetRenderState(RenderStates.Lighting, true);
               }
            }
         }

         BRenderDevice.getDevice().SetTransform(TransformType.World, savedWorldMat);
      }

      void renderLogic(visualLogic curLogic, RenderModeMask renderMode)
      {
         if (curLogic == null)
            return;

         // Render the selected item
         if (curLogic.logicdata.Count > curLogic.selectedItem)
         {
            visualLogicData curLogicData = curLogic.logicdata[curLogic.selectedItem];
            renderLogicData(curLogicData, renderMode);
         }
      }

      void renderLogicData(visualLogicData curLogicData, RenderModeMask renderMode)
      {
         if (curLogicData == null)
            return;
         
         if (curLogicData.asset != null)
         {
            renderComponentAsset(curLogicData.asset, renderMode);
         }
         else if (!string.IsNullOrEmpty(curLogicData.modelref))
         {
            foreach (visualModel curModel in modelField)
            {
               if (string.Compare(curLogicData.modelref, curModel.name, true) == 0)
               {
                  renderModel(curModel, renderMode);
               }
            }
         }
         else if(curLogicData.logic != null)
         {
            renderLogic(curLogicData.logic, renderMode);
         }
      }

      public override bool isNodeValid()
      {
         if (modelField.Count == 0)
            return false;

         // Check name
         bool foundDefaultModel = false;
         foreach(visualModel curModel in modelField)
         {
            if(String.Compare(defaultmodelField, curModel.name, true) == 0)
            {
               foundDefaultModel = true;
               break;
            }
         }

         if (!foundDefaultModel)
         {
            return false;
         }

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if(!isNodeValid())
            return(false);

         // check all models
         foreach (visualModel curModel in modelField)
         {
            if(!curModel.isBranchValid())
               return(false);
         }

         // check logic if any
         if(logicField != null)
         {
            if(!logicField.isBranchValid())
               return(false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null) 
         {
            if (logicField == null)
               return (true);
            else
               return (false);
         }

         return (false);
      }

      public override bool addChild(XMLVisualNode node) 
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            model.Add(curModel);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null) 
         {
            if (logicField == null)
            {
               logicField = curLogic;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            model.Insert(index, curModel);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (logicField == null)
            {
               logicField = curLogic;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node) 
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            model.Remove(curModel);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (curLogic == logic)
            {
               logic = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            return (model.IndexOf(curModel));
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (curLogic == logic)
               return (0);
            else
               return (-1);
         }

         return (-1);
      }

      public override void resort()
      {
         foreach (visualModel curModel in modelField)
         {
            curModel.resort();
         }

         if (logicField != null)
         {
            logicField.resort();
         }
      }

      public override void copy(XMLVisualNode node)
      {
         visual curVisual = node as visual;
         if (curVisual != null)
         {
            defaultmodel = curVisual.defaultmodel;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visual nodeCopy = new visual();

         // copy data
         nodeCopy.defaultmodel = defaultmodel;

         // copy children
         if(deepCopy)
         {
            foreach (visualModel curModel in model)
               nodeCopy.model.Add((visualModel) curModel.clone(true));

            if (logic != null)
               nodeCopy.logic = (visualLogic) logic.clone(true);
         }
         return (nodeCopy);
      }


      public override void updateTreeNodeText(TreeNode node)
      {
         node.Text = "Visual";
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode visualNode = new TreeNode();
         visualNode.Tag = this;
         visualNode.ImageIndex = 0;
         visualNode.SelectedImageIndex = 0;

         // Set text
         updateTreeNodeText(visualNode);



         // Process models
         if (model != null)
         {
            foreach (visualModel curModel in model)
            {
               // add node
               TreeNode modelNode = curModel.createTreeNode();
               visualNode.Nodes.Add(modelNode);
            }
         }


         // Process logic
         if (logic != null)
         {
            // add node
            TreeNode logicNode = logic.createTreeNode();
            visualNode.Nodes.Add(logicNode);
         }


         return visualNode;
      }
   }

   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModel : XMLVisualNode
   {
      private visualModelComponent componentField = new visualModelComponent();

      private List<visualModelAnim> animField = new List<visualModelAnim>();

      private string textField = "Default";

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string name
      {
         get { return this.textField; }
         set { this.textField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualModelComponent component
      {
         get { return this.componentField; }
         set { this.componentField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      [System.Xml.Serialization.XmlElementAttribute("anim")]
      public List<visualModelAnim> anim
      {
         get { return this.animField; }
         set { this.animField = value; }
      }

      
      public override bool isNodeValid()
      {
         if (componentField == null)
            return false;

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check component
         if (!componentField.isBranchValid())
            return (false);

         // check all anims
         foreach (visualModelAnim curAnim in animField)
         {
            if (!curAnim.isBranchValid())
               return (false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
            if (component == null)
            {
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelAnim curAnim = node as visualModelAnim;
         if (curAnim != null)
         {
            return (true);
         }

         return (false);
      }

      public override bool addChild(XMLVisualNode node) 
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
            if(component == null)
            {
               component = curComponent;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelAnim curAnim = node as visualModelAnim;
         if (curAnim != null)
         {
            anim.Add(curAnim);
            return (true);
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
            if (component == null)
            {
               component = curComponent;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelAnim curAnim = node as visualModelAnim;
         if (curAnim != null)
         {
            anim.Insert(index, curAnim);
            return (true);
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
            if (curComponent == component)
            {
               component = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelAnim curAnim = node as visualModelAnim;
         if (curAnim != null)
         {
            anim.Remove(curAnim);
            return (true);
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
            if (curComponent == component)
               return (0);
            else
               return (-1);
         }

         visualModelAnim curAnim = node as visualModelAnim;
         if (curAnim != null)
         {
            return (anim.IndexOf(curAnim));
         }

         return (-1);
      }

      public override void resort()
      {
         // check component
         if (componentField != null)
            componentField.resort();

         // check all anims
         foreach (visualModelAnim curAnim in animField)
         {
            curAnim.resort();
         }
      }


      public override void copy(XMLVisualNode node) 
      {
         visualModel curModel = node as visualModel;
         if (curModel != null)
         {
            textField = curModel.textField; 
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModel nodeCopy = new visualModel();

         // copy data
         nodeCopy.textField = textField;

         // copy children
         if(deepCopy)
         {
            if (component != null)
               nodeCopy.component = (visualModelComponent) component.clone(true);

            foreach (visualModelAnim curAnim in anim)
               nodeCopy.anim.Add((visualModelAnim) curAnim.clone(true));
         }
         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string modelNodeName = "Model: ";
         modelNodeName += name;
         node.Text = modelNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode modelNode = new TreeNode();
         modelNode.Tag = this;
         modelNode.ImageIndex = 1;
         modelNode.SelectedImageIndex = 1;

         // Set text
         updateTreeNodeText(modelNode);



         // Process component
         if (component != null)
         {
            // add node
            TreeNode componentNode = component.createTreeNode();
            modelNode.Nodes.Add(componentNode);
         }

         // Process anim
         if (anim != null)
         {
            foreach (visualModelAnim curAnim in anim)
            {
               // add node
               TreeNode animNode = curAnim.createTreeNode();
               modelNode.Nodes.Add(animNode);
            }
         }

         return modelNode;
      }
   }

   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelComponent : XMLVisualNode
   {
      private visualModelComponentAsset assetField;

      private visualLogic logicField; 
      
      private List<visualModelComponentOrAnimAttach> attachField = new List<visualModelComponentOrAnimAttach>();

      private List<visualModelComponentPoint> pointField = new List<visualModelComponentPoint>();

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualLogic logic
      {
         get { return this.logicField; }
         set { this.logicField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualModelComponentAsset asset
      {
         get { return this.assetField; }
         set { this.assetField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("attach")]
      public List<visualModelComponentOrAnimAttach> attach
      {
         get { return this.attachField; }
         set { this.attachField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("point")]
      public List<visualModelComponentPoint> point
      {
         get { return this.pointField; }
         set { this.pointField = value; }
      }


      public override bool isNodeValid()
      {
         // Must have an asset or logic
         if ((assetField == null) && (logicField == null))
            return false;

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check component asset or logic
         if (assetField != null) 
         {
            if(!assetField.isBranchValid())
            {
               return (false);
            }
         }
         else if (logicField != null)
         {
            if (!logicField.isBranchValid())
            {
               return (false);
            }
         }

         // check all attachments
         foreach (visualModelComponentOrAnimAttach curAttach in attachField)
         {
            if (!curAttach.isBranchValid())
               return (false);
         }

         // check all points
         foreach (visualModelComponentPoint curPoint in pointField)
         {
            if (!curPoint.isBranchValid())
               return (false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualModelComponentAsset curComponentAsset = node as visualModelComponentAsset;
         if (curComponentAsset != null)
         {
            if (asset == null)
               return (true);
            else
               return (false);
         }

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
            return (true);

         visualModelComponentPoint curPoint = node as visualModelComponentPoint;
         if (curPoint != null)
            return (true);

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (logic == null)
               return (true);
            else
               return (false);
         }

         return (false);
      }

      public override bool addChild(XMLVisualNode node)
      {
         visualModelComponentAsset curComponentAsset = node as visualModelComponentAsset;
         if (curComponentAsset != null)
         {
            if (asset == null)
            {
               asset = curComponentAsset;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
         {
            attach.Add(curAttach);
            return (true);
         }

         visualModelComponentPoint curPoint = node as visualModelComponentPoint;
         if (curPoint != null)
         {
            point.Add(curPoint);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (logic == null)
            {
               logic = curLogic;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualModelComponentAsset curComponentAsset = node as visualModelComponentAsset;
         if (curComponentAsset != null)
         {
            if (asset == null)
            {
               asset = curComponentAsset;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
         {
            attach.Insert(index, curAttach);
            return (true);
         }

         visualModelComponentPoint curPoint = node as visualModelComponentPoint;
         if (curPoint != null)
         {
            point.Insert(index, curPoint);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (logic == null)
            {
               logic = curLogic;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualModelComponentAsset curAsset = node as visualModelComponentAsset;
         if (curAsset != null)
         {
            if (curAsset == asset)
            {
               asset = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualModelComponentOrAnimAttach compOrAnimattach = node as visualModelComponentOrAnimAttach;
         if (compOrAnimattach != null)
         {
            attach.Remove(compOrAnimattach);
            return (true);
         }

         visualModelComponentPoint componentPoint = node as visualModelComponentPoint;
         if (componentPoint != null)
         {
            point.Remove(componentPoint);
            return (true);
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (curLogic == logic)
            {
               logic = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualModelComponentAsset curAsset = node as visualModelComponentAsset;
         if (curAsset != null)
         {
            if (curAsset == asset)
               return (0);
            else
               return (-1);
         }

         visualModelComponentOrAnimAttach compOrAnimattach = node as visualModelComponentOrAnimAttach;
         if (compOrAnimattach != null)
         {
            return (attach.IndexOf(compOrAnimattach));
         }

         visualModelComponentPoint componentPoint = node as visualModelComponentPoint;
         if (componentPoint != null)
         {
            return (point.IndexOf(componentPoint));
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (curLogic == logic)
               return (0);
            else
               return (-1);
         }

         return (-1);
      }

      public override void resort()
      {
         // check component asset
         if (assetField != null)
            assetField.resort();

         // check all attachments
         foreach (visualModelComponentOrAnimAttach curAttach in attachField)
         {
            curAttach.resort();
         }

         // check all points
         foreach (visualModelComponentPoint curPoint in pointField)
         {
            curPoint.resort();
         }
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelComponent curComponent = node as visualModelComponent;
         if (curComponent != null)
         {
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelComponent nodeCopy = new visualModelComponent();

         // copy data


         // copy children
         if (deepCopy)
         {
            if (asset != null)
               nodeCopy.asset = (visualModelComponentAsset) asset.clone(true);

            foreach (visualModelComponentOrAnimAttach curAttach in attach)
               nodeCopy.attach.Add((visualModelComponentOrAnimAttach) curAttach.clone(true));

            if (logic != null)
               nodeCopy.logic = (visualLogic) logic.clone(true);

            foreach (visualModelComponentPoint curPoint in point)
               nodeCopy.point.Add((visualModelComponentPoint) curPoint.clone(true));
         }

         return (nodeCopy);
      }



      public override void updateTreeNodeText(TreeNode node)
      {
         node.Text = "Component";
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

       public override TreeNode createTreeNode()
      {
         TreeNode componentNode = new TreeNode();
         componentNode.Tag = this;
         componentNode.ImageIndex = 2;
         componentNode.SelectedImageIndex = 2;

         // Set text
         updateTreeNodeText(componentNode);


         // Process asset
         if (asset != null)
         {
            // add node
            TreeNode assetNode = asset.createTreeNode();
            componentNode.Nodes.Add(assetNode);
         }


         // Process attach
         foreach (visualModelComponentOrAnimAttach curAttach in attach)
         {
            // add node
            TreeNode attachNode = curAttach.createTreeNode();
            componentNode.Nodes.Add(attachNode);
         }

         // Process logic
         if (logic != null)
         {
            // add node
            TreeNode logicNode = logic.createTreeNode();
            componentNode.Nodes.Add(logicNode);
         }

         // Process point
         foreach (visualModelComponentPoint curPoint in point)
         {
            // add node
            TreeNode pointNode = curPoint.createTreeNode();
            componentNode.Nodes.Add(pointNode);
         }

         return componentNode;
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelAnim : XMLVisualNode
   {
      public enum AnimType
      {
         None = 0,
         Idle,
         Walk,
         Jog,
         Run,
         RangedAttack,
         Attack,
         Limber,
         Unlimber,
         Death,
         Gather,
         Research,
         Train,
         Bored,
         Incoming,
         Landing,
         Takeoff,
         Outgoing,
         Clamshell,
         Cinematic
      }

      public enum AnimExitAction
      {
         Loop = 0,
         Freeze,
         Transition
      }

      private string animName;

      private AnimExitAction exitActionField = AnimExitAction.Loop;

      private int tweenTimeField = 0;

      private string tweenToAnimationField = "";

      private List<visualModelAnimAsset> assetField = new List<visualModelAnimAsset>();

      private List<visualModelComponentOrAnimAttach> attachField = new List<visualModelComponentOrAnimAttach>();

      private List<string> meshEnableField = new List<string>();

      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string type
      {
         get { return this.animName; }
         set { this.animName = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public AnimExitAction exitAction
      {
         get { return this.exitActionField; }
         set { this.exitActionField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public int tweenTime
      {
         get { return this.tweenTimeField; }
         set { this.tweenTimeField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string tweenToAnimation
      {
         get { return this.tweenToAnimationField; }
         set { this.tweenToAnimationField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("asset")]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public List<visualModelAnimAsset> asset
      {
         get { return this.assetField; }
         set { this.assetField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("attach")]
      public List<visualModelComponentOrAnimAttach> attach
      {
         get { return this.attachField; }
         set { this.attachField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("meshEnable")]
      public List<string> meshEnable
      {
         get { return this.meshEnableField; }
         set { this.meshEnableField = value; }
      }

      public override bool isNodeValid()
      {
         // Must have an asset
         if (assetField.Count == 0)
            return false;

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check all anims assets
         foreach (visualModelAnimAsset curAnimAsset in assetField)
         {
            if (!curAnimAsset.isBranchValid())
               return (false);
         }

         // check all attachments
         foreach (visualModelComponentOrAnimAttach curAttach in attachField)
         {
            if (!curAttach.isBranchValid())
               return (false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualModelAnimAsset curAnimAsset = node as visualModelAnimAsset;
         if (curAnimAsset != null)
            return (true);

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
            return (true);

         return (false);
      }

      public override bool addChild(XMLVisualNode node)
      {
         visualModelAnimAsset curAnimAsset = node as visualModelAnimAsset;
         if (curAnimAsset != null)
         {
            asset.Add(curAnimAsset);
            return (true);
         }

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
         {
            attach.Add(curAttach);
            return (true);
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualModelAnimAsset curAnimAsset = node as visualModelAnimAsset;
         if (curAnimAsset != null)
         {
            asset.Insert(index, curAnimAsset);
            return (true);
         }

         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
         {
            attach.Insert(index, curAttach);
            return (true);
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualModelAnimAsset animAsset = node as visualModelAnimAsset;
         if (animAsset != null)
         {
            asset.Remove(animAsset);
            return (true);
         }

         visualModelComponentOrAnimAttach compOrAnimAttach = node as visualModelComponentOrAnimAttach;
         if (compOrAnimAttach != null)
         {
            attach.Remove(compOrAnimAttach);
            return (true);
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualModelAnimAsset animAsset = node as visualModelAnimAsset;
         if (animAsset != null)
         {
            return (asset.IndexOf(animAsset));
         }

         visualModelComponentOrAnimAttach compOrAnimAttach = node as visualModelComponentOrAnimAttach;
         if (compOrAnimAttach != null)
         {
            return (attach.IndexOf(compOrAnimAttach));
         }

         return (-1);
      }

      public override void resort()
      {
         // check all anims assets
         foreach (visualModelAnimAsset curAnimAsset in assetField)
         {
            curAnimAsset.resort();
         }

         // check all attachments
         foreach (visualModelComponentOrAnimAttach curAttach in attachField)
         {
            curAttach.resort();
         }
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelAnim curModelAnim = node as visualModelAnim;
         if (curModelAnim != null)
         {
            animName = curModelAnim.animName;
            exitAction = curModelAnim.exitAction;
            tweenTime = curModelAnim.tweenTime;
            tweenToAnimation = curModelAnim.tweenToAnimation;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelAnim nodeCopy = new visualModelAnim();

         // copy data
         nodeCopy.animName = animName;
         nodeCopy.exitAction = exitAction;
         nodeCopy.tweenTime = tweenTime;
         nodeCopy.tweenToAnimation = tweenToAnimation;

         // copy children
         if (deepCopy)
         {
            foreach (visualModelAnimAsset curAsset in asset)
               nodeCopy.asset.Add((visualModelAnimAsset) curAsset.clone(true));

            foreach (visualModelComponentOrAnimAttach curAttach in attach)
               nodeCopy.attach.Add((visualModelComponentOrAnimAttach) curAttach.clone(true));

            foreach (string curMeshEnable in meshEnable)
               nodeCopy.meshEnable.Add(curMeshEnable);
         }
         return (nodeCopy);
      }


      public override void updateTreeNodeText(TreeNode node)
      {
         string animNodeName = "Anim: ";
         animNodeName += type;
         node.Text = animNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode animNode = new TreeNode();
         animNode.Tag = this;
         animNode.ImageIndex = 3;
         animNode.SelectedImageIndex = 3;

         // Set text
         updateTreeNodeText(animNode);

         // Process asset
         if (asset != null)
         {
            foreach (visualModelAnimAsset curAsset in asset)
            {
               // add node
               TreeNode assetNode = curAsset.createTreeNode();
               animNode.Nodes.Add(assetNode);
            }
         }

         // Process attach
         foreach (visualModelComponentOrAnimAttach curAttach in attach)
         {
            // add node
            TreeNode attachNode = curAttach.createTreeNode();
            animNode.Nodes.Add(attachNode);
         }

         return animNode;
      }
   }

   
   public class uvOffsetChannel
   {
      public uvOffsetChannel()
      {
         channelField = 0;
         uOffsetField = 0;
         vOffsetField = 0;
      }

      public uvOffsetChannel(int c, float u, float v)
      {
         channelField = c;
         uOffsetField = u;
         vOffsetField = v;
      }
      private int channelField;
      private float uOffsetField;
      private float vOffsetField;

      [System.Xml.Serialization.XmlAttributeAttribute()]
      public int channel
      {
         get { return this.channelField; }
         set { this.channelField = value; }
      }
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public float uOfs
      {
         get { return this.uOffsetField; }
         set { this.uOffsetField = value; }
      }
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public float vOfs
      {
         get { return this.vOffsetField; }
         set { this.vOffsetField = value; }
      }
   }

   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelComponentAsset : XMLVisualNode
   {
      public enum ComponentAssetType
      {
         Model = 0,
         Particle,
         Light
      }

      private ComponentAssetType typeField;

      private string fileField;

      private string damagefileField;

      [System.Xml.Serialization.XmlElement()]
      public uvOffsetChannel[] uvOffset = new uvOffsetChannel[3] { new uvOffsetChannel(0, 0, 0), new uvOffsetChannel(1, 0, 0), new uvOffsetChannel(2, 0, 0) };
      
      
      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public ComponentAssetType type
      {
         get { return this.typeField; }
         set { this.typeField = value; }
      }

      /// <remarks/>
      public string file
      {
         get { return this.fileField; }
         set { this.fileField = value; }
      }

      /// <remarks/>
      public string damagefile
      {
         get { return this.damagefileField; }
         set { this.damagefileField = value; }
      }




      [System.Xml.Serialization.XmlIgnore]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public GrannyInstance mInstance = null;



      public override bool isNodeValid()
      {
         // Must have an asset
         switch (typeField)
         {
            case ComponentAssetType.Model:
            case ComponentAssetType.Particle:
            case ComponentAssetType.Light:
               if (String.IsNullOrEmpty(fileField))
                  return false;
               break;
         }

         // Also check file existance
         string filenameAbsolute;
         switch (typeField)
         {
            case ComponentAssetType.Model:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + fileField + ".gr2";
               if (!File.Exists(filenameAbsolute))
                  return false;

               if (!String.IsNullOrEmpty(damagefileField))
               {
                  filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + damagefileField + ".dmg";
                  if (!File.Exists(filenameAbsolute))
                     return false;
               }
               break;
            case ComponentAssetType.Particle:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + fileField + ".pfx";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case ComponentAssetType.Light:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + fileField + ".lgt";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
         }

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node only since this is leaf node
         return (isNodeValid());
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelComponentAsset curAsset = node as visualModelComponentAsset;
         if (curAsset != null)
         {
            typeField = curAsset.typeField;
            fileField = curAsset.fileField;
            damagefileField = curAsset.damagefileField;
            mInstance = curAsset.mInstance;
            if (uvOffset != null)
            {
               uvOffset[0].uOfs = curAsset.uvOffset[0].uOfs;
               uvOffset[0].vOfs = curAsset.uvOffset[0].vOfs;
               uvOffset[1].uOfs = curAsset.uvOffset[1].uOfs;
               uvOffset[1].vOfs = curAsset.uvOffset[1].vOfs;
               uvOffset[2].uOfs = curAsset.uvOffset[2].uOfs;
               uvOffset[2].vOfs = curAsset.uvOffset[2].vOfs;
            }
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelComponentAsset nodeCopy = new visualModelComponentAsset();

         // copy data
         nodeCopy.typeField = typeField;
         nodeCopy.fileField = fileField;
         nodeCopy.damagefileField = damagefileField;
         nodeCopy.mInstance = mInstance;
         if (uvOffset!=null)
         {
            nodeCopy.uvOffset[0].uOfs = uvOffset[0].uOfs;
            nodeCopy.uvOffset[0].vOfs = uvOffset[0].vOfs;
            nodeCopy.uvOffset[1].uOfs = uvOffset[1].uOfs;
            nodeCopy.uvOffset[1].vOfs = uvOffset[1].vOfs;
            nodeCopy.uvOffset[2].uOfs = uvOffset[2].uOfs;
            nodeCopy.uvOffset[2].vOfs = uvOffset[2].vOfs;
         }
        


         // copy children

         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string assetNodeName = "Asset ";
         assetNodeName += "(" + type + "): "; 
         assetNodeName += file;

         if ((typeField == ComponentAssetType.Model) && (!String.IsNullOrEmpty(damagefileField)))
         {
            assetNodeName += ", Damage: ";
            assetNodeName += damagefile;
         }

         node.Text = assetNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode assetNode = new TreeNode();
         assetNode.Tag = this;
         //assetNode.ImageIndex = -1;
         //assetNode.SelectedImageIndex = -1;

         // Set text
         updateTreeNodeText(assetNode);

         return assetNode;
      }

      public void loadAsset()
      {
         if (mInstance == null)
         {
            if ((typeField == visualModelComponentAsset.ComponentAssetType.Model) && !string.IsNullOrEmpty(fileField))
            {
               string gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, fileField) + ".gr2";
               if (File.Exists(gr2FileName))
               {
                  int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                  mInstance = GrannyManager2.createInstance(modelId);
               }
            }
         }
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelComponentPoint : XMLVisualNode
   {
      public enum ComponentPointType
      {
         Impact = 0,
         Launch,
         HitpointBar,
         Reflect,
         Cover,
         Carry, 
         Pickup,
         Board,
         Bobble
      }

      public enum ComponentPointData
      {
         Metal = 0,
      }

      private ComponentPointType pointTypeField;

      private string boneField;

      private ComponentPointData pointDataField;

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public ComponentPointType pointType
      {
         get { return this.pointTypeField; }
         set { this.pointTypeField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string bone
      {
         get { return this.boneField; }
         set { this.boneField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public ComponentPointData pointData
      {
         get { return this.pointDataField; }
         set { this.pointDataField = value; }
      }

      public override bool isNodeValid()
      {
         // TODO:  Add validation here

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node only since this is leaf node
         return (isNodeValid());
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelComponentPoint curPoint = node as visualModelComponentPoint;
         if (curPoint != null)
         {
            pointTypeField = curPoint.pointTypeField;
            boneField = curPoint.boneField;
            pointDataField = curPoint.pointDataField;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelComponentPoint nodeCopy = new visualModelComponentPoint();

         // copy data
         nodeCopy.pointTypeField = pointTypeField;
         nodeCopy.boneField = boneField;
         nodeCopy.pointDataField = pointDataField;

         // copy children

         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string assetNodeName = "Point ";
         assetNodeName += "(" + pointType + "): ";
         assetNodeName += "Bone = " + bone; 

         node.Text = assetNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode pointNode = new TreeNode();
         pointNode.Tag = this;
         pointNode.ImageIndex = 8;
         pointNode.SelectedImageIndex = 8;

         // Set text
         updateTreeNodeText(pointNode);

         return pointNode;
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelAnimAsset : XMLVisualNode
   {
      public enum AnimAssetType
      {
         Anim = 0
      }

      private AnimAssetType typeField;

      private string fileField = "";

      private int weightField = 1;

      private EditorCore.FloatProgression progressionField = null;

      private List<visualModelAnimAssetTag> tagField = new List<visualModelAnimAssetTag>();

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public AnimAssetType type
      {
         get { return this.typeField; }
         set { this.typeField = value; }
      }

      /// <remarks/>
      public string file
      {
         get { return this.fileField; }
         set { this.fileField = value; }
      }

      /// <remarks/>
      public int weight
      {
         get { return this.weightField; }
         set { this.weightField = value; }
      }

      /// <remarks/>
      public EditorCore.FloatProgression progression
      {
         get { return this.progressionField; }
         set { this.progressionField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      [System.Xml.Serialization.XmlElementAttribute("tag")]
      public List<visualModelAnimAssetTag> tag
      {
         get { return this.tagField; }
         set { this.tagField = value; }
      }


      [System.Xml.Serialization.XmlIgnore]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public int mAnimId = -1;


      public override bool isNodeValid()
      {
         // Must have an asset
         if (String.IsNullOrEmpty(fileField))
            return false;

         // Also check file existance
         string filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + fileField + ".gr2";
         if (!File.Exists(filenameAbsolute))
            return false;


         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check all tags
         foreach (visualModelAnimAssetTag curTag in tagField)
         {
            if (!curTag.isBranchValid())
               return (false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualModelAnimAssetTag curTag = node as visualModelAnimAssetTag;
         if (curTag != null)
            return (true);

         return (false);
      }

      public override bool addChild(XMLVisualNode node)
      {
         visualModelAnimAssetTag curTag = node as visualModelAnimAssetTag;
         if (curTag != null)
         {
            tag.Add(curTag);
            return (true);
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualModelAnimAssetTag curTag = node as visualModelAnimAssetTag;
         if (curTag != null)
         {
            tag.Insert(index, curTag);
            return (true);
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualModelAnimAssetTag animAssetTag = node as visualModelAnimAssetTag;
         if (animAssetTag != null)
         {
            tag.Remove(animAssetTag);
            return (true);
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualModelAnimAssetTag animAssetTag = node as visualModelAnimAssetTag;
         if (animAssetTag != null)
         {
            return (tag.IndexOf(animAssetTag));
         }

         return (-1);
      }

      public override void resort()
      {
         // Temp list
         List<visualModelAnimAssetTag> tempTagList = new List<visualModelAnimAssetTag>();

         foreach (visualModelAnimAssetTag curTag in tagField)
         {
            decimal tagTime = curTag.position;

            // Find place in temp list
            int tagPos = 0;
            foreach (visualModelAnimAssetTag curCompareTag in tempTagList)
            {
               if (curCompareTag.position > curTag.position)
                  break;

               tagPos++;
            }

            // Insert at tag pos
            tempTagList.Insert(tagPos, curTag);
         }

         // Clear and copy recreate tagField
         tagField.Clear();
         foreach (visualModelAnimAssetTag curTag in tempTagList)
         {
            tagField.Add(curTag);
         }
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelAnimAsset curAsset = node as visualModelAnimAsset;
         if (curAsset != null)
         {
            typeField = curAsset.typeField;
            fileField = curAsset.fileField;
            mAnimId = curAsset.mAnimId;
            weightField = curAsset.weightField;

            if (curAsset.progressionField != null)
               progressionField = curAsset.progressionField.clone();
            else
               progressionField = null;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelAnimAsset nodeCopy = new visualModelAnimAsset();

         // copy data
         nodeCopy.typeField = typeField;
         nodeCopy.fileField = fileField;
         nodeCopy.weightField = weightField;
         nodeCopy.mAnimId = mAnimId;

         if (progressionField != null)
            nodeCopy.progressionField = progressionField.clone();
         else
            nodeCopy.progressionField = null;


         // copy children
         if (deepCopy)
         {
            foreach (visualModelAnimAssetTag curTag in tag)
               nodeCopy.tag.Add((visualModelAnimAssetTag) curTag.clone(true));
         }
         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string assetNodeName = "Asset (Anim): ";
         assetNodeName += file;
         assetNodeName += ", ";
         assetNodeName += "Weight = " + weightField; 
         node.Text = assetNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode assetNode = new TreeNode();
         assetNode.Tag = this;
         //assetNode.ImageIndex = -1;
         //assetNode.SelectedImageIndex = -1;

         // Set text
         updateTreeNodeText(assetNode);

         // Process tags
         if (tag != null)
         {
            foreach (visualModelAnimAssetTag curTag in tag)
            {
               // add node
               TreeNode tagNode = curTag.createTreeNode();
               assetNode.Nodes.Add(tagNode);
            }
         }

         return assetNode;
      }

      public void loadAsset()
      {
         if (mAnimId == -1)
         {
            if ((typeField == visualModelAnimAsset.AnimAssetType.Anim) && !string.IsNullOrEmpty(fileField))
            {
               string gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, fileField) + ".gr2";
               if (File.Exists(gr2FileName))
               {
                  mAnimId = GrannyManager2.getOrCreateAnimation(gr2FileName);
               }
            }
         }
      }
   }

   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelComponentOrAnimAttach : XMLVisualNode
   {
      public enum AttachType
      {
         ModelFile = 0,
         ParticleFile,
         LightFile,
         ModelRef,
         TerrainEffect
      }

      private AttachType typeField;

      private string nameField;

      private string toboneField;

      private string fromboneField;

      private bool syncanimsField;

      private bool disregardOrientField;

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public AttachType type
      {
         get { return this.typeField; }
         set { this.typeField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string name
      {
         get { return this.nameField; }
         set { this.nameField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string tobone
      {
         get { return this.toboneField; }
         set { this.toboneField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string frombone
      {
         get { return this.fromboneField; }
         set { this.fromboneField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool syncanims
      {
         get { return this.syncanimsField; }
         set { this.syncanimsField = value; }
      }
      
      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool disregardorient
      {
         get { return this.disregardOrientField; }
         set { this.disregardOrientField = value; }
      }

      [System.Xml.Serialization.XmlIgnore]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public GrannyInstance mInstance = null;


      public override bool isNodeValid()
      {
         // Must have an asset
         switch (typeField)
         {
            case AttachType.ModelFile:
            case AttachType.ModelRef:
            case AttachType.ParticleFile:
            case AttachType.LightFile:
               if (String.IsNullOrEmpty(nameField))
                  return false;
               break;
         }

         // Check if model ref exists
         if (typeField == AttachType.ModelRef)
         {
            // There is no way of getting the models for this node
         }


         // Also check file existance
         string filenameAbsolute;
         switch (typeField)
         {
            case AttachType.ModelFile:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".gr2";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case AttachType.ParticleFile:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".pfx";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case AttachType.TerrainEffect:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".tfx";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case AttachType.LightFile:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".lgt";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
         }

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node only since this is leaf node
         return (isNodeValid());
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelComponentOrAnimAttach curAttach = node as visualModelComponentOrAnimAttach;
         if (curAttach != null)
         {
            typeField = curAttach.typeField;
            nameField = curAttach.nameField;
            mInstance = curAttach.mInstance;

            toboneField = curAttach.toboneField;
            fromboneField = curAttach.fromboneField;
            syncanimsField = curAttach.syncanimsField;
            disregardOrientField = curAttach.disregardOrientField;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelComponentOrAnimAttach nodeCopy = new visualModelComponentOrAnimAttach();

         // copy data
         nodeCopy.typeField = typeField;
         nodeCopy.nameField = nameField;
         nodeCopy.toboneField = toboneField;
         nodeCopy.fromboneField = fromboneField;
         nodeCopy.syncanimsField = syncanimsField;
         nodeCopy.disregardOrientField = disregardOrientField;
         nodeCopy.mInstance = mInstance;

         // copy children

         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string attachNodeName = "Attachment ";
         attachNodeName += "(" + type + "): ";
         attachNodeName += nameField;
         attachNodeName += ", ";
         attachNodeName += "To Bone = " + tobone;
         if ((type == AttachType.ModelFile) || (type == AttachType.ModelRef))
         {
            attachNodeName += ", ";
            attachNodeName += "From Bone = " + frombone;
         }

         if (type == AttachType.ModelRef)
         {
            attachNodeName += ", ";
            attachNodeName += "Sync Anims = " + syncanims;
         }

         node.Text = attachNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode attachNode = new TreeNode();
         attachNode.Tag = this;

         switch(type)
         {
            case AttachType.ModelFile:
               attachNode.ImageIndex = 4;
               attachNode.SelectedImageIndex = 4;
               break;
            case AttachType.ModelRef:
               attachNode.ImageIndex = 5;
               attachNode.SelectedImageIndex = 5;
               break;
            case AttachType.ParticleFile:
               attachNode.ImageIndex = 6;
               attachNode.SelectedImageIndex = 6;
               break;
            case AttachType.LightFile:
               attachNode.ImageIndex = 7;
               attachNode.SelectedImageIndex = 7;
               break;
            case AttachType.TerrainEffect:
               attachNode.ImageIndex = 6;
               attachNode.SelectedImageIndex = 6;
               break;
         }

         // Set text
         updateTreeNodeText(attachNode);

         return attachNode;
      }

      public void loadAsset()
      {
         if (mInstance == null)
         {
            if ((typeField == visualModelComponentOrAnimAttach.AttachType.ModelFile) && !string.IsNullOrEmpty(nameField))
            {
               string gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, nameField) + ".gr2";
               if (File.Exists(gr2FileName))
               {
                  int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                  mInstance = GrannyManager2.createInstance(modelId);
               }
            }
         }
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualModelAnimAssetTag : XMLVisualNode
   {
      public enum TagType
      {
         Attack = 0,
         Sound,
         Particle,
         TerrainEffect,
         Light,
         CameraShake,
         GroundIK,
         AttachTarget,
         SweetSpot,
         TerrainAlpha,
         Rumble,
         BuildingDecal,
         UVOffset,
         KillAndThrow,
         PhysicsImpulse,
      }

      private TagType typeField;

      private decimal startField = 0.0M;

      private decimal positionField = 0.0M;

      private decimal endField = 1.0M;

      private string nameField;

      private string toboneField;

      private bool checkvisibleField=true;      
      
      private bool disregardOrientField;

      private bool lockToGroundField;

      private bool attachField;

      private decimal forceField = 0.0M;
      private decimal force2Field = 0.0M;

      private decimal lifespanField = 0.25M;

      private string userDataField;

      private string leftRumbleTypeField;
      private string rightRumbleTypeField;
      private bool loopField;
      private bool checkSelectedField;

      private bool checkFOWField=true;

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public TagType type
      {
         get { return this.typeField; }
         set { this.typeField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal start
      {
         get { return this.startField; }
         set { this.startField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal position
      {
         get { return this.positionField; }
         set { this.positionField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal end
      {
         get { return this.endField; }
         set { this.endField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string name
      {
         get { return this.nameField; }
         set { this.nameField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string tobone
      {
         get { return this.toboneField; }
         set { this.toboneField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool checkvisible
      {
         get { return this.checkvisibleField; }
         set { this.checkvisibleField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool lockToGround
      {
         get { return this.lockToGroundField; }
         set { this.lockToGroundField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool attach
      {
         get { return this.attachField; }
         set { this.attachField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool disregardorient
      {
         get { return this.disregardOrientField; }
         set { this.disregardOrientField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal force
      {
         get { return this.forceField; }
         set { this.forceField = value; }
      }

      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal force2
      {
         get { return this.force2Field; }
         set { this.force2Field = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public decimal lifespan
      {
         get { return this.lifespanField; }
         set { this.lifespanField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string userData
      {
         get { return this.userDataField; }
         set { this.userDataField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string leftRumbleType
      {
         get { return this.leftRumbleTypeField; }
         set { this.leftRumbleTypeField = value; }
      }

      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string rightRumbleType
      {
         get { return this.rightRumbleTypeField; }
         set { this.rightRumbleTypeField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool loop
      {
         get { return this.loopField; }
         set { this.loopField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool checkSelected
      {
         get { return this.checkSelectedField; }
         set { this.checkSelectedField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public bool checkFOW
      {
         get { return this.checkFOWField; }
         set { this.checkFOWField = value; }
      }


      public override bool isNodeValid()
      {
         // Must have an asset
         switch (typeField)
         {
            case TagType.Attack:
               break;
            case TagType.Particle:
            case TagType.TerrainEffect:
               if (String.IsNullOrEmpty(nameField))
                  return false;
               break;
            case TagType.Sound:
               if (String.IsNullOrEmpty(nameField))
                  return false;
               break;
            case TagType.Light:
               if (String.IsNullOrEmpty(nameField))
                  return false;
               break;
            case TagType.CameraShake:
               break;
            case TagType.GroundIK:
               if (String.IsNullOrEmpty(toboneField))
                  return false;
               break;
            case TagType.AttachTarget:
               if (String.IsNullOrEmpty(toboneField))
                  return false;
               break;
            case TagType.SweetSpot:
               if (String.IsNullOrEmpty(toboneField))
                  return false;
               if (start > position)
                  return false;
               if (end < position)
                  return false;
               break;
            case TagType.Rumble:
               break;
            case TagType.UVOffset:
               break;
            case TagType.TerrainAlpha:
               break;
            case TagType.BuildingDecal:
               break;
            case TagType.KillAndThrow:
               if (String.IsNullOrEmpty(toboneField))
                  return false;
               break;
            case TagType.PhysicsImpulse:
               if (String.IsNullOrEmpty(toboneField))
                  return false;
               break;
         }

         // Also check file existance
         string filenameAbsolute;
         switch (typeField)
         {
            case TagType.Particle:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".pfx";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case TagType.TerrainEffect:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".tfx";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
            case TagType.Light:
               filenameAbsolute = CoreGlobals.getSaveLoadPaths().mGameArtDirectory + "\\" + nameField + ".lgt";
               if (!File.Exists(filenameAbsolute))
                  return false;
               break;
         }

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node only since this is leaf node
         return (isNodeValid());
      }

      public override void copy(XMLVisualNode node)
      {
         visualModelAnimAssetTag curTag = node as visualModelAnimAssetTag;
         if (curTag != null)
         {
            typeField = curTag.typeField;
            startField = curTag.startField;
            positionField = curTag.positionField;
            endField = curTag.endField;
            nameField = curTag.nameField;
            toboneField = curTag.toboneField;
            lockToGroundField = curTag.lockToGroundField;
            attachField = curTag.attachField;
            checkvisibleField = curTag.checkvisibleField;
            disregardOrientField = curTag.disregardOrientField;
            forceField = curTag.forceField;
            lifespanField = curTag.lifespanField;
            userDataField = curTag.userDataField;
            leftRumbleTypeField = curTag.leftRumbleTypeField;
            rightRumbleTypeField = curTag.rightRumbleTypeField;
            force2Field = curTag.force2Field;
            loopField = curTag.loopField;
            checkSelectedField = curTag.checkSelectedField;
            checkFOWField = curTag.checkFOWField;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualModelAnimAssetTag nodeCopy = new visualModelAnimAssetTag();

         // copy data
         nodeCopy.typeField = typeField;
         nodeCopy.startField = startField;
         nodeCopy.positionField = positionField;
         nodeCopy.endField = endField;
         nodeCopy.nameField = nameField;
         nodeCopy.toboneField = toboneField;
         nodeCopy.attachField = attachField;
         nodeCopy.lockToGroundField = lockToGroundField;
         nodeCopy.checkvisibleField = checkvisibleField;         
         nodeCopy.disregardOrientField = disregardOrientField;
         nodeCopy.forceField = forceField;
         nodeCopy.lifespanField = lifespanField;
         nodeCopy.userDataField = userDataField;
         nodeCopy.leftRumbleTypeField = leftRumbleTypeField;
         nodeCopy.rightRumbleTypeField = rightRumbleTypeField;
         nodeCopy.force2Field = force2Field;
         nodeCopy.loopField = loopField;
         nodeCopy.checkSelectedField = checkSelectedField;
         nodeCopy.checkFOWField= checkFOWField;

         // copy children

         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string tagNodeName = "";

         switch (type)
         {
            case (visualModelAnimAssetTag.TagType.Attack):
               tagNodeName += "Tag (Attack): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone; 
               break;
            case (visualModelAnimAssetTag.TagType.Particle):
               tagNodeName += "Tag (Particle): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "Particle Name = " + name;
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.TerrainEffect):
               tagNodeName += "Tag (TerrainEffect): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "TerrainEffect Name = " + name;
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.Sound):
               tagNodeName += "Tag (Sound): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "Sound Name = " + name;
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.Light):
               tagNodeName += "Tag (Light): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "Light Name = " + name;
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.CameraShake):
               tagNodeName += "Tag (CameraShake): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               break;
            case (visualModelAnimAssetTag.TagType.GroundIK):
               tagNodeName += "Tag (GroundIK): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.AttachTarget):
               tagNodeName += "Tag (AttachTarget): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.SweetSpot):
               tagNodeName += "Tag (SweetSpot): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.BuildingDecal):
               tagNodeName += "Tag (BuildingDecal): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.TerrainAlpha):
               tagNodeName += "Tag (TerrainAlpha): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.Rumble):
               tagNodeName += "Tag (Rumble): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               break;
            case (visualModelAnimAssetTag.TagType.UVOffset):
               tagNodeName += "Tag (UVOffset): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               break;
            case (visualModelAnimAssetTag.TagType.KillAndThrow):
               tagNodeName += "Tag (KillAndThrow): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
            case (visualModelAnimAssetTag.TagType.PhysicsImpulse):
               tagNodeName += "Tag (PhysicsImpulse): ";
               tagNodeName += "Pos = " + position.ToString("0.00;-0.00;0.00");
               tagNodeName += ", ";
               tagNodeName += "To Bone = " + tobone;
               break;
         }
         node.Text = tagNodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode tagNode = new TreeNode();
         tagNode.Tag = this;
         switch (type)
         {
            case TagType.Attack:
               tagNode.ImageIndex = 9;
               tagNode.SelectedImageIndex = 9;
               break;
            case TagType.Sound:
               tagNode.ImageIndex = 10;
               tagNode.SelectedImageIndex = 10;
               break;
            case TagType.Particle:
               tagNode.ImageIndex = 11;
               tagNode.SelectedImageIndex = 11;
               break;
            case TagType.TerrainEffect:
               tagNode.ImageIndex = 11;
               tagNode.SelectedImageIndex = 11;
               break;
            case TagType.Light:
               tagNode.ImageIndex = 12;
               tagNode.SelectedImageIndex = 12;
               break;
            case TagType.CameraShake:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.GroundIK:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.AttachTarget:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.SweetSpot:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.BuildingDecal:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.TerrainAlpha:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.Rumble:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.UVOffset:
               tagNode.ImageIndex = 13;
               tagNode.SelectedImageIndex = 13;
               break;
            case TagType.KillAndThrow:
               tagNode.ImageIndex = 9;
               tagNode.SelectedImageIndex = 9;
               break;
            case TagType.PhysicsImpulse:
               tagNode.ImageIndex = 9;
               tagNode.SelectedImageIndex = 9;
               break;
         }

         // Set text
         updateTreeNodeText(tagNode);

         return tagNode;
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualLogic : XMLVisualNode
   {
      public enum LogicType
      {
         Variation = 0,
         BuildingCompletion,
         Tech,
         SquadMode,
         ImpactSize,
         Destruction,
         UserCiv
      }

      private LogicType typeField;

      private List<visualLogicData> dataField = new List<visualLogicData>();

      private int curSelectedItem = 0;

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public LogicType type
      {
         get { return this.typeField; }
         set { this.typeField = value; }
      }
      
      /// <remarks/>
      [System.Xml.Serialization.XmlElementAttribute("logicdata")]
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public List<visualLogicData> logicdata
      {
         get { return this.dataField; }
         set { this.dataField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlIgnore]
      public int selectedItem
      {
         get { return this.curSelectedItem; }
         set { this.curSelectedItem = value; }
      }

      public override bool isNodeValid()
      {
         if (dataField.Count == 0)
            return false;

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check all logic data
         foreach (visualLogicData curLogicData in dataField)
         {
            if (!curLogicData.isBranchValid())
               return (false);
         }

         return (true);
      }

      public override bool canAdd(XMLVisualNode node)
      {
         visualLogicData curLogicData = node as visualLogicData;
         if (curLogicData != null)
            return (true);

         return (false);
      }

      public override bool addChild(XMLVisualNode node)
      {
         visualLogicData curLogicData = node as visualLogicData;
         if (curLogicData != null)
         {
            logicdata.Add(curLogicData);
            return (true);
         }

         return (false);
      }

      public override bool insertChild(int index, XMLVisualNode node)
      {
         visualLogicData curLogicData = node as visualLogicData;
         if (curLogicData != null)
         {
            logicdata.Insert(index, curLogicData);
            return (true);
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualLogicData vLogicData = node as visualLogicData;
         if (vLogicData != null)
         {
            logicdata.Remove(vLogicData);
            return (true);
         }

         return (false);
      }

      public override int indexOf(XMLVisualNode node)
      {
         visualLogicData vLogicData = node as visualLogicData;
         if (vLogicData != null)
         {
            return (logicdata.IndexOf(vLogicData));
         }

         return (-1);
      }

      public override void copy(XMLVisualNode node)
      {
         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            typeField = curLogic.typeField;
            curSelectedItem = curLogic.curSelectedItem;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualLogic nodeCopy = new visualLogic();

         // copy data
         nodeCopy.typeField = typeField;
         nodeCopy.curSelectedItem = curSelectedItem;

         // copy children
         if (deepCopy)
         {
            foreach (visualLogicData curData in logicdata)
               nodeCopy.logicdata.Add((visualLogicData) curData.clone(true));
         }
         return (nodeCopy);
      }

      
      public override void updateTreeNodeText(TreeNode node)
      {
         node.Text = "Logic - " + type;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode logicNode = new TreeNode();
         logicNode.Tag = this;
         logicNode.ImageIndex = 4;
         logicNode.SelectedImageIndex = 4;

         // Set text
         updateTreeNodeText(logicNode);

         foreach (visualLogicData curLogicData in logicdata)
         {
            // add node
            TreeNode logicDataNode = curLogicData.createTreeNode();
            logicNode.Nodes.Add(logicDataNode);
         }

         return logicNode;
      }
   }


   /// <remarks/>
   [System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "2.0.50727.42")]
   [System.SerializableAttribute()]
   [System.Diagnostics.DebuggerStepThroughAttribute()]
   [System.ComponentModel.DesignerCategoryAttribute("code")]
   [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true)]
   public partial class visualLogicData : XMLVisualNode
   {
      private int weightField = 1;

      private string valueField = "";

      private visualModelComponentAsset assetField;

      private visualLogic logicField;

      private string modelRefField = "";

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string value
      {
         get { return this.valueField; }
         set { this.valueField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public string modelref
      {
         get { return this.modelRefField; }
         set { this.modelRefField = value; }
      }

      /// <remarks/>
      [System.Xml.Serialization.XmlAttributeAttribute()]
      public int weight
      {
         get { return this.weightField; }
         set { this.weightField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualModelComponentAsset asset
      {
         get { return this.assetField; }
         set { this.assetField = value; }
      }

      /// <remarks/>
      [Browsable(false), EditorBrowsable(EditorBrowsableState.Never)]
      public visualLogic logic
      {
         get { return this.logicField; }
         set { this.logicField = value; }
      }

      public override bool isNodeValid()
      {
         if ((assetField == null) && (logicField == null) && !string.IsNullOrEmpty(modelref))
            return true;

         if ((assetField == null) && (logicField == null))
            return false;

         if ((assetField != null) && (logicField != null))
            return false;

         return true;
      }

      public override bool isBranchValid()
      {
         // check this node
         if (!isNodeValid())
            return (false);

         // check asset
         if (assetField != null)
         {
            if (!assetField.isBranchValid())
               return (false);
         }
         else if (logicField != null)
         {
            if (!logicField.isBranchValid())
               return (false);
         }


         return (true);
      }

      public override bool addChild(XMLVisualNode node)
      {
         visualModelComponentAsset curAsset = node as visualModelComponentAsset;
         if (curAsset != null)
         {
            if (assetField == null)
            {
               assetField = curAsset;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (logicField == null)
            {
               logicField = curLogic;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override bool removeChild(XMLVisualNode node)
      {
         visualModelComponentAsset curAsset = node as visualModelComponentAsset;
         if (curAsset != null)
         {
            if (curAsset == asset)
            {
               asset = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         visualLogic curLogic = node as visualLogic;
         if (curLogic != null)
         {
            if (curLogic == logic)
            {
               logic = null;
               return (true);
            }
            else
            {
               return (false);
            }
         }

         return (false);
      }

      public override void copy(XMLVisualNode node)
      {
         visualLogicData curLogicData = node as visualLogicData;
         if (curLogicData != null)
         {
            valueField = curLogicData.valueField;
            modelref = curLogicData.modelref;
            weight = curLogicData.weight;
         }
      }

      public override XMLVisualNode clone(bool deepCopy)
      {
         visualLogicData nodeCopy = new visualLogicData();

         // copy data
         nodeCopy.valueField = valueField;
         nodeCopy.modelref = modelref;
         nodeCopy.weight = weight;

         if (assetField != null)
            nodeCopy.assetField = (visualModelComponentAsset) assetField.clone(deepCopy);

         if (logicField != null)
            nodeCopy.logicField = (visualLogic)logicField.clone(deepCopy);
 

         // copy children

         return (nodeCopy);
      }

      public override void updateTreeNodeText(TreeNode node)
      {
         string nodeName = "Node: ";

         nodeName += "Value = " + value;

         if (!string.IsNullOrEmpty(modelRefField))
         {
            nodeName += ", ModelRef = " + modelRefField;
         }

         nodeName += ", Weight = " + weight;

         node.Text = nodeName;
         node.ForeColor = isNodeValid() ? Color.Black : Color.Red;
      }

      public override TreeNode createTreeNode()
      {
         TreeNode logicDataNode = new TreeNode();
         logicDataNode.Tag = this;
         logicDataNode.ImageIndex = 4;
         logicDataNode.SelectedImageIndex = 4;

         // Set text
         updateTreeNodeText(logicDataNode);

         if (logic != null)
         {
            TreeNode logicNode = logic.createTreeNode();
            logicDataNode.Nodes.Add(logicNode);
         }

         if (asset != null)
         {
            TreeNode assetNode = asset.createTreeNode();
            logicDataNode.Nodes.Add(assetNode);
         }


         return logicDataNode;
      }
   }



   //==============================================================================
   // BVisualItem
   //==============================================================================
   public class BVisualItem
   {
      public Vector3          mMinCorner;
      public Vector3          mMaxCorner;

      public GrannyInstance   mpInstance = null;


      public void render(Vector3 playerColor, bool bUsePlayerColor)
      {
         if (mpInstance != null)
         {
            mpInstance.render(playerColor, bUsePlayerColor);
         }
      }

      public void update(float elapsedTime, BVisual pVisual, bool sendLoopEvent)
      {
         if(mpInstance != null)
         {
            mpInstance.update(elapsedTime);   
         }
         /*
         if(mpTags || (sendLoopEvent && mDuration!=0.0f && mAnimAsset.mType!=-1))
         {
            // Generate animation tag events
            float p1=mPosition/mDuration;
            mPosition+=elapsedTime;
            while(mPosition>mDuration)
               mPosition-=mDuration;
            float p2=mPosition/mDuration;
            bool wrapped=(p1>p2);

            if(sendLoopEvent && wrapped)
            {
               BProtoVisualTag tag;
               tag.mEventType=cAnimEventLoop;
               gVisualManager.handleAnimEvent(mAnimAsset.mType, pVisual, &tag);
            }

            if(mpTags)
            {
               long tagCount=mpTags->getNumber();
               for(long i=0; i<tagCount; i++)
               {
                  BProtoVisualTag& tag=(*mpTags)[i];
                  float tagPosition=tag.mPosition;
                  if( (tagPosition<cFloatCompareEpsilon && p1<cFloatCompareEpsilon && p2>=cFloatCompareEpsilon) ||
                     (tagPosition>p1 && tagPosition<=p2) ||
                     (wrapped && (tagPosition<=p2 || tagPosition>p1)) )
                  {
                     gVisualManager.handleAnimEvent(mAnimAsset.mType, pVisual, &tag);
                  }
               }
            }
         }
         else if(mSendNoAnimEvent)
         {
            BProtoVisualTag tag;
            tag.mEventType=cAnimEventLoop;
            gVisualManager.handleAnimEvent(mAnimAsset.mType, pVisual, &tag);
            mSendNoAnimEvent=false;
         }
          */
      }
   }


   //==============================================================================
   // BVisualAttachment
   //==============================================================================
   public class BVisualAttachment : BVisualItem
   {
      public Matrix  mMatrix;

      public int     mFromBoneHandle;
      public int     mToBoneHandle;      
   }


   //==============================================================================
   // BVisual
   //==============================================================================
   public class BVisualVariation
   {
      public BVisualItem mItem = new BVisualItem();
      public int mWeight = 0;
   };

   public class BVisual
   {
      protected List<BVisualVariation> mVisualVariations = new List<BVisualVariation>();
      protected int mSelectedVisualVariation = 0;

      public List<BVisualAttachment> mAttachments = new List<BVisualAttachment>();
      public BBoundingBox mBoundingBox = new BBoundingBox();

      public BVisualItem get_mItem() 
      {
         if (mVisualVariations.Count == 0)
            return null;
         if (mSelectedVisualVariation >= mVisualVariations.Count)
            mSelectedVisualVariation = 0;

         return mVisualVariations[mSelectedVisualVariation].mItem; 
      }


      //for variation logic
      public void setSelectedVisualVariation(int variationIndex)
      {
         if (variationIndex >= mVisualVariations.Count)
            variationIndex = mVisualVariations.Count - 1;

         mSelectedVisualVariation = variationIndex;
      }
      public int getSelectedVisualVariation()
      {
         return mSelectedVisualVariation;
      }

      public void cycleSelectedVisualVariation(bool useRandomWeight)
      {
         if (mVisualVariations.Count <= 1)
            return;

         if(useRandomWeight)
         {
            //find our total weight 
            int totalWeights = 0;
            for(int i=0;i<mVisualVariations.Count;i++)
               totalWeights += mVisualVariations[i].mWeight;
            

            Random mRand = new Random(DateTime.Now.Millisecond);
            int randomNum = mRand.Next(totalWeights);

            float runningTotal = 0;
            for (int i = 0; i < mVisualVariations.Count; i++)
            {
               if (runningTotal + mVisualVariations[i].mWeight > randomNum)
               {
                  mSelectedVisualVariation = i;
                  break;
               }
               runningTotal += mVisualVariations[i].mWeight;
            }


            mRand = null;
         }
         else
         {
            mSelectedVisualVariation++;

            if (mSelectedVisualVariation >= mVisualVariations.Count)
               mSelectedVisualVariation = 0;
         }
      }

      public visual                    mProtoVisual = null;
      //public long                      mAnimType;


      public void deinit()
      {
         mVisualVariations.Clear();

         mAttachments.Clear();
         mBoundingBox.empty();

         mProtoVisual = null;
      }

      public bool init(visual pProtoVisual)
      {
         mProtoVisual = pProtoVisual;

         mVisualVariations.Clear();

         // Find default model
         visualModel defaultModel = null;
         foreach (visualModel curModel in mProtoVisual.model)
         {
            if (string.Compare(mProtoVisual.defaultmodel, curModel.name, true) == 0)
            {
               defaultModel = curModel;
               break;
            }
         }

         string gr2FileName;

         if ((defaultModel != null) && (defaultModel.component != null))
         {
            if ((defaultModel.component.asset != null) && (defaultModel.component.asset.type == visualModelComponentAsset.ComponentAssetType.Model))
            {
               BVisualVariation varModel = new BVisualVariation();

               // Load model
               gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, defaultModel.component.asset.file) + ".gr2";
               if (File.Exists(gr2FileName))
               {
                  int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                  varModel.mItem.mpInstance = GrannyManager2.createInstance(modelId);
               }
               mVisualVariations.Add(varModel);



               // Load attachments
               foreach (visualModelComponentOrAnimAttach curAttachment in defaultModel.component.attach)
               {
                  switch(curAttachment.type)
                  {
                     case(visualModelComponentOrAnimAttach.AttachType.ModelFile):
                        {
                           gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, curAttachment.name) + ".gr2";
                           if (File.Exists(gr2FileName))
                           {
                              BVisualAttachment attachment = new BVisualAttachment();

                              int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                              attachment.mpInstance = GrannyManager2.createInstance(modelId);
                              attachment.mToBoneHandle = (get_mItem().mpInstance != null) ? get_mItem().mpInstance.getBoneHandle(curAttachment.tobone) : -1;
                              attachment.mFromBoneHandle = (attachment.mpInstance != null) ? attachment.mpInstance.getBoneHandle(curAttachment.frombone) : -1;

                              mAttachments.Add(attachment);
                           }
                        }
                        break;

                     case (visualModelComponentOrAnimAttach.AttachType.ModelRef):
                        {
                           BVisualAttachment attachment = initAttachment(pProtoVisual, curAttachment.name);
                           if (attachment != null)
                           {
                              attachment.mToBoneHandle = (get_mItem().mpInstance != null) ? get_mItem().mpInstance.getBoneHandle(curAttachment.tobone) : -1;
                              attachment.mFromBoneHandle = (attachment.mpInstance != null) ? attachment.mpInstance.getBoneHandle(curAttachment.frombone) : -1;

                              mAttachments.Add(attachment);
                           }
                        }
                        break;
                  }

               }

               // Load idle animation
               foreach (visualModelAnim curAnim in defaultModel.anim)
               {
                  if (string.Compare(curAnim.type, "Idle") == 0)
                  {
                     /*
                     if (curAnim.asset != null)
                     {
                        foreach (visualModelAnimAsset curAnimAsset in curAnim.asset)
                        {
                           string gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, curAnimAsset.file) + ".gr2";
                           if (File.Exists(gr2FileName))
                           {
                              curAnimAsset.mAnimId = GrannyManager2.getOrCreateAnimation(gr2FileName);
                           }
                        }
                     }
                      */

                     // Load attachments
                     foreach (visualModelComponentOrAnimAttach curAttachment in curAnim.attach)
                     {
                        if (curAttachment.type == visualModelComponentOrAnimAttach.AttachType.ModelFile)
                        {
                           gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, curAttachment.name) + ".gr2";
                           if (File.Exists(gr2FileName))
                           {
                              BVisualAttachment attachment = new BVisualAttachment();

                              int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                              attachment.mpInstance = GrannyManager2.createInstance(modelId);
                              attachment.mToBoneHandle = (get_mItem().mpInstance != null) ? get_mItem().mpInstance.getBoneHandle(curAttachment.tobone) : -1;
                              attachment.mFromBoneHandle = (attachment.mpInstance != null) ? attachment.mpInstance.getBoneHandle(curAttachment.frombone) : -1;
                              mAttachments.Add(attachment);
                           }
                        }
                     }

                     break;
                  }
               }

               // Load variation models
               if (defaultModel.component.logic != null)
               {
                  visualLogic logic = defaultModel.component.logic;

                  foreach (visualLogicData curLogicData in logic.logicdata)
                  {
               //      if (curLogicData.logic == null || curLogicData.logic.type != visualLogic.LogicType.Variation)
                  //      continue;

                     if (curLogicData.asset != null)
                     {

                        BVisualVariation varModelt = new BVisualVariation();

                        varModelt.mWeight = curLogicData.weight;

                        // Load model
                        gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, curLogicData.asset.file) + ".gr2";
                        if (File.Exists(gr2FileName))
                        {
                           int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                           varModelt.mItem.mpInstance = GrannyManager2.createInstance(modelId);
                        }

                        mVisualVariations.Add(varModelt);
                     }
                  }
                  
               }

            }
            else if(defaultModel.component.logic != null)
            {
               visualLogic logic = defaultModel.component.logic;

               foreach (visualLogicData curLogicData in logic.logicdata)
               {
               //   if (curLogicData.logic == null || curLogicData.logic.type != visualLogic.LogicType.Variation)
               //      continue;

                  if(curLogicData.asset != null)
                  {
                     BVisualVariation varModelt = new BVisualVariation();

                     varModelt.mWeight = curLogicData.weight;

                     // Load model
                     gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, curLogicData.asset.file) + ".gr2";
                     if (File.Exists(gr2FileName))
                     {
                        int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
                        varModelt.mItem.mpInstance = GrannyManager2.createInstance(modelId);
                     }

                     mVisualVariations.Add(varModelt);
                     mSelectedVisualVariation = 0;
                  }
               }

            }

            mSelectedVisualVariation = 0;

            // Update attachments
            updateAttachmentTransforms();

            // Compute bounding box
            computeBoundingBox();
         }
         return (true);
      }


      public bool init(string gr2FileNameAbsolute)
      {
         if (!File.Exists(gr2FileNameAbsolute))
         {
            return (false);
         }

         BVisualVariation varModel = new BVisualVariation();

         int modelId = GrannyManager2.getOrCreateModel(gr2FileNameAbsolute);
         varModel.mItem.mpInstance = GrannyManager2.createInstance(modelId);
         varModel.mWeight = 1;

         mVisualVariations.Add(varModel);


         // Compute bounding box
         computeBoundingBox();

         return (true);
      }


      public BVisualAttachment initAttachment(visual pProtoVisual, string modelRefName)
      {
         BVisualAttachment attachment = null;

         // Find modelRef model
         visualModel model = null;
         foreach (visualModel curModel in mProtoVisual.model)
         {
            if (string.Compare(modelRefName, curModel.name, true) == 0)
            {
               model = curModel;
               break;
            }
         }

         string gr2FileName;

         if ((model != null) && (model.component != null))
         {
            if ((model.component.asset != null) && (model.component.asset.type == visualModelComponentAsset.ComponentAssetType.Model))
            {
               // Load model
               gr2FileName = Path.Combine(CoreGlobals.getWorkPaths().mGameArtDirectory, model.component.asset.file) + ".gr2";
               if (!File.Exists(gr2FileName))
                  return null;

               attachment = new BVisualAttachment();

               int modelId = GrannyManager2.getOrCreateModel(gr2FileName);
               attachment.mpInstance = GrannyManager2.createInstance(modelId);
            }
         }

         return (attachment);
      }

      void update(float elapsedTime)
      {
         if (mProtoVisual != null) 
         {
            /*
            if (mPrevProtoVisualGeneration != mpProtoVisual->getGeneration())
               updateState();
             */
         }
         
         // Update the base item
         get_mItem().update(elapsedTime, this, true);

         // Update the attachments
         long count=mAttachments.Count;
         if(count>0)
         {
            for(int i=0; i<count; i++)
            {
               BVisualAttachment attachment = mAttachments[i];
               
               attachment.update(elapsedTime, this, false);
            }

            updateAttachmentTransforms();


            /*
            // Recompute the bounding box
            mMinCorner=cOriginVector;
            mMaxCorner=cOriginVector;
            computeBoundingBox(&mMinCorner, &mMaxCorner);
             */
         }
   
      }

      public void render(Vector3 playerColor, bool bUsePlayerColor)
      {
         render(playerColor, bUsePlayerColor, GrannyInstance.eVisualEditorRenderMode.cRenderFull);
      }
      public void render(Vector3 playerColor, bool bUsePlayerColor, GrannyInstance.eVisualEditorRenderMode renderMode)
      {
         GrannyInstance.setRenderMode(renderMode);

         if (get_mItem() == null)
         {
            return;
         }

         if (get_mItem().mpInstance != null)
         {
            get_mItem().render(playerColor, bUsePlayerColor);


            // Render the attachments
            long count=mAttachments.Count;
            if(count>0)
            {
               // Saved world matrix
               Matrix savedWorldMat = BRenderDevice.getDevice().GetTransform(TransformType.World);

               for(int i=0; i<count; i++)
               {
                  BVisualAttachment attachment = mAttachments[i];
                 
                  Matrix attachMatrix = attachment.mMatrix;
                  attachMatrix.Multiply(savedWorldMat);

                  BRenderDevice.getDevice().SetTransform(TransformType.World, attachMatrix);

                  attachment.render(playerColor, bUsePlayerColor);
               }

               // Restore world matrix
               BRenderDevice.getDevice().SetTransform(TransformType.World, savedWorldMat);
            }
         }
      }

      public bool testRayIntersection(Vector3 r0, Vector3 rD, Matrix worldMat)
      {
         // Check main model
         if (get_mItem() != null)
         {
            if (get_mItem().mpInstance.testRayIntersection(r0, rD, worldMat))
               return (true);
         }

         // Check attachments
         foreach (BVisualAttachment attachment in mAttachments)
         {
            if (attachment.mpInstance.testRayIntersection(r0, rD, worldMat))
               return (true);
         }

         return (false);
      }

      public void burnIntoObjFile(OBJFile obj, int objectId, Matrix worldMat)
      {
         // Main model
         if ((get_mItem() != null) && (get_mItem().mpInstance != null))
         {
            get_mItem().mpInstance.burnIntoObjFile(obj, objectId, worldMat);
         }

         // Attachments
         foreach (BVisualAttachment attachment in mAttachments)
         {
            attachment.mpInstance.burnIntoObjFile(obj, objectId, worldMat);
         }
      }

      protected void updateAttachmentTransforms()
      {
         long count=mAttachments.Count;
         if(count>0)
         {
            Matrix toMat = Matrix.Identity;
            Matrix fromMat = Matrix.Identity;


            for(int i=0; i<count; i++)
            {
               BVisualAttachment attachment = mAttachments[i];

               if (attachment.mpInstance != null)
               {
                  if ((get_mItem().mpInstance != null) && get_mItem().mpInstance.getBone(attachment.mToBoneHandle, ref toMat))
                  {
                     if ((attachment.mpInstance != null) && attachment.mpInstance.getBone(attachment.mFromBoneHandle, ref fromMat))
                     {
                        fromMat.Invert();

                        attachment.mMatrix = Matrix.Multiply(fromMat, toMat);
                     }
                     else
                        attachment.mMatrix = toMat;
                  }
                  else
                  {
                     if ((attachment.mpInstance != null) && attachment.mpInstance.getBone(attachment.mFromBoneHandle, ref fromMat))
                     {
                        fromMat.Invert();
                        attachment.mMatrix = fromMat;
                     }
                     else
                        attachment.mMatrix = Matrix.Identity;
                  }

                  /*
                  if(attachment.getFlag(BVisualAttachment::cFlagUseTransform))
                     attachment.mMatrix.mult(attachment.mTransform, attachment.mMatrix);                      
                   */
               }
            }
         }
      }

      protected void computeBoundingBox()
      {
         mBoundingBox.empty();
         BBoundingBox modelBox = new BBoundingBox();

         if(get_mItem()==null)
         {
            mBoundingBox.addPoint(1, 1, 1);
            mBoundingBox.addPoint(0, 0, 0);
            return;
         }

         if (get_mItem().mpInstance != null)
         {
            mBoundingBox.addBox(get_mItem().mpInstance.mStaticBoundingBox);
         }

         BBoundingBox aaBox = new BBoundingBox();
         BOrientedBoundingBox orientedBox = new BOrientedBoundingBox();
         for (int i = 0; i < mAttachments.Count; i++)
         {
            BBoundingBox attachBox = mAttachments[i].mpInstance.mStaticBoundingBox;

            orientedBox.construct(attachBox.min, attachBox.max, mAttachments[i].mMatrix);
            orientedBox.computeAABB(ref aaBox);

            mBoundingBox.addBox(aaBox);
         }
      }
   }

   public class ProtoVisualElement
   {
      public visual m_protoVisual;
      public string m_filename;
   }

   public class VisualElement
   {
      public BVisual m_visual;
      public string m_filename;
      public BVisualManager.BModelStatistics m_360MemoryStatistics;  
   }


   //==============================================================================
   // BVisualManager
   //==============================================================================
   public class BVisualManager
   {
      // Variables
      //
      private static List<ProtoVisualElement>      s_protoVisualElements = new List<ProtoVisualElement>();
      private static List<VisualElement>           s_visualElements = new List<VisualElement>();

      // Methods
      //
      public static void destroy()
      {
         for (int i = 0; i < s_protoVisualElements.Count; i++)
         {
            s_protoVisualElements[i].m_protoVisual.destroy();
            s_protoVisualElements[i].m_protoVisual = null;
         }
         s_protoVisualElements.Clear();

         for (int i = 0; i < s_visualElements.Count; i++)
         {
            s_visualElements[i].m_visual.deinit();
            s_visualElements[i].m_visual = null;
         }
         s_visualElements.Clear();

         GC.Collect();
         GC.WaitForPendingFinalizers();
      }
      public static int getProtoVisualIndex(string filename)
      {
         // Try to find first
         for (int i = 0; i < s_protoVisualElements.Count; i++)
         {
            if (s_protoVisualElements[i].m_filename.Equals(filename))
            {
               return i;
            }
         }

         // Not found
         return(-1);
      }


      public static visual getOrLoadProtoVisual(string filename)
      {
         // Try to find first
         int protoId = getProtoVisualIndex(filename);
         if(protoId != -1)
         {
            return s_protoVisualElements[protoId].m_protoVisual;
         }

         if (!File.Exists(filename))
            return null;

         // Load it since we can't find it
         Stream st = File.OpenRead(filename);
         //XmlSerializer s = new XmlSerializer(typeof(visual), new Type[] { });
         visual visualFile = (visual)mStaticSerializer.Deserialize(st);
         st.Close();


         ProtoVisualElement protoVisualElement = new ProtoVisualElement();
         protoVisualElement.m_protoVisual = visualFile;
         protoVisualElement.m_filename = filename;
         s_protoVisualElements.Add(protoVisualElement);


         return visualFile;
      }

      public static visual getProtoVisual(int index)
      {
         if (index < 0 || index >= s_protoVisualElements.Count)
            return null;

         visual protoVisual = s_protoVisualElements[index].m_protoVisual;

         return protoVisual;
      }


      public static void removeProtoVisual(visual protoVisual)
      {
         // Try to find first
         int index = -1;
         for (int i = 0; i < s_protoVisualElements.Count; i++)
         {
            if (s_protoVisualElements[i].m_protoVisual == protoVisual)
            {
               index = i;
               break;
            }
         }

         if (index != -1)
         {
            s_protoVisualElements.RemoveAt(index);
         }
      }

      static XmlSerializer mStaticSerializer = new XmlSerializer(typeof(visual), new Type[] { });


      public static void reloadProtoVisual(string fileName)
      {
         int protoId = getProtoVisualIndex(fileName);
         if (protoId == -1)
            return;

         Stream st = File.OpenRead(fileName);
         //XmlSerializer s = new XmlSerializer(typeof(visual), new Type[] { });
         visual visualFile = (visual)mStaticSerializer.Deserialize(st);
         st.Close();

         BVisualManager.s_protoVisualElements[protoId].m_protoVisual = visualFile;


         // Find all affected BVisuals
         //
         for (int i = 0; i < BVisualManager.s_visualElements.Count; i++)
         {
            if (BVisualManager.s_visualElements[i].m_filename.Equals(BVisualManager.s_protoVisualElements[protoId].m_filename))
            {
               BVisualManager.s_visualElements[i].m_visual.deinit();
               BVisualManager.s_visualElements[i].m_visual.init(visualFile);
            }
         }
      }


      // BVisual are instances of protovisuals, to play animations we really need to have a 
      // separate instance (BVisual) for each object, even if they are instances of the same
      // protovisual.  In the scenerio editor we don't need to do this, since playing anims
      // isn't important.  Therefore we share the BVisuals.  (SAT)
      //
      public static BVisual getOrLoadVisual(string filename)
      {
         // Try to find first
         for (int i = 0; i < s_visualElements.Count; i++)
         {
            if (s_visualElements[i].m_filename.Equals(filename))
            {
               return s_visualElements[i].m_visual;
            }
         }

         visual visualFile = getOrLoadProtoVisual(filename);
         if (visualFile == null)
            return null;

         BVisual visualv = createVisual(ref visualFile);
         if (visualv == null)
            return null;

         VisualElement visualElement = new VisualElement();
         visualElement.m_visual = visualv;
         visualElement.m_filename = filename;
         visualElement.m_360MemoryStatistics = new BModelStatistics();
         getStatsForVisual(visualElement.m_visual.mProtoVisual,ref visualElement.m_360MemoryStatistics);
         s_visualElements.Add(visualElement);

         return (visualv);
      }

      public static BVisual getOrLoadVisualGR2Only(string gr2FileNameAbsolute)
      {
         // Try to find first
         for (int i = 0; i < s_visualElements.Count; i++)
         {
            if (s_visualElements[i].m_filename.Equals(gr2FileNameAbsolute))
            {
               return s_visualElements[i].m_visual;
            }
         }

         BVisual visual = createVisual(gr2FileNameAbsolute);
         if (visual == null)
            return null;

         VisualElement visualElement = new VisualElement();
         visualElement.m_visual = visual;
         visualElement.m_filename = gr2FileNameAbsolute;
         s_visualElements.Add(visualElement);

         return (visual);
      }


      public static BVisual createVisual(ref visual protoVisual)
      {
         if (protoVisual == null)
            return null;

         BVisual bvisual = new BVisual();
         if (bvisual == null)
            return null;

         if (!bvisual.init(protoVisual))
         {
            return null;
         }

         return bvisual;
      }

      public static BVisual createVisual(string gr2FileNameAbsolute)
      {
         BVisual bvisual = new BVisual();
         if (bvisual == null)
            return null;

         if (!bvisual.init(gr2FileNameAbsolute))
         {
            return null;
         }

         return bvisual;
      }

      public static void releaseVisual(BVisual bvisual)
      {
         //delete pVisual;
      }

      #region 360 memory estimate..
      //CLM THESE NUMBERS ARE VALID AS OF 08-17-07.
      public class BModelStatistics
      {
         public int mUGXMemFootprint=0;
         public int mUAXMemFootprint = 0;
      };
      private static void getStatsForModel(visualModel curModel, ref BVisualManager.BModelStatistics stats)
      {

         if (curModel.component != null)
         {
            getStatsForComponent(curModel.component, ref stats);
         }

         //animation file size
         foreach (visualModelAnim curAnim in curModel.anim)
         {
            foreach (visualModelAnimAsset curAnimAsset in curAnim.asset)
            {
               // get stats for gr2 anim fix curAnimAsset.file
               string file = CoreGlobals.getWorkPaths().mGameArtDirectory +  "\\" + curAnimAsset.file + ".uax";
               if(File.Exists(file))
               {
                  System.IO.FileInfo fi = new System.IO.FileInfo(file);
                  stats.mUAXMemFootprint += (int)fi.Length;
                  fi = null;
               }
            }
         }
      }
      
      private static void getStatsForComponent(visualModelComponent curComponent, ref BVisualManager.BModelStatistics stats)
      {
         if (curComponent.asset != null)
         {
            // get stats for gr2 model file curComponent.asset.file
            string file = CoreGlobals.getWorkPaths().mGameArtDirectory + "\\" + curComponent.asset.file + ".ugx";
            if (File.Exists(file))
            {
               System.IO.FileInfo fi = new System.IO.FileInfo(file);
               stats.mUGXMemFootprint += (int)fi.Length;
               fi = null;
            }
         }
         else if (curComponent.logic != null)
         {
            getStatsForLogic(curComponent.logic, ref stats);
         }

         foreach (visualModelComponentOrAnimAttach curAttachment in curComponent.attach)
         {
            getStatsForAttachment(curAttachment, ref stats);
         }
      }
      private static void getStatsForAttachment(visualModelComponentOrAnimAttach curAttachment, ref BVisualManager.BModelStatistics stats)
      {
      
         switch (curAttachment.type)
         {
            case visualModelComponentOrAnimAttach.AttachType.ModelFile:
               // get stats for gr2 model file curAttachment.name
               break;
         }
      }
      private static void getStatsForLogic(visualLogic logic, ref BVisualManager.BModelStatistics stats)
      {
         foreach (visualLogicData curLogicData in logic.logicdata)
         {
            getStatsForLogicData(curLogicData, ref stats);
         }

      }
      private static void getStatsForLogicData(visualLogicData logicData, ref BVisualManager.BModelStatistics stats)
      {
         if (logicData.asset != null)
         {
            // get stats for gr2 model file logicData.asset.file
         }
         else if (logicData.logic != null)
         {
            getStatsForLogic(logicData.logic, ref stats);
         }
      }
      private static void getStatsForVisual(visual vis, ref BVisualManager.BModelStatistics stats)
      {
         
         if (vis != null)
         {
            foreach (visualModel curModel in vis.model)
            {
               getStatsForModel(curModel, ref stats);
            }
         }
      }

      public static BModelStatistics giveTotal360MemoryEstimate()
      {
         BModelStatistics stats = new BModelStatistics();
         for(int i=0;i<s_visualElements.Count;i++)
         {
            if (s_visualElements[i].m_360MemoryStatistics!=null)
            {
               stats.mUGXMemFootprint += s_visualElements[i].m_360MemoryStatistics.mUGXMemFootprint;
               stats.mUAXMemFootprint += s_visualElements[i].m_360MemoryStatistics.mUAXMemFootprint;
            }
         }
         return stats;
      }

      #endregion
   }

}
