.comment ******************************************************************
.comment *  Graphics Family - QBasic                                      *
.comment ******************************************************************
.comment *  7/13/90 stevesau                                              *
.comment *  Incorporated QA/copy edits.                                   *
.comment ******************************************************************
.comment *  6/28/90 stevesau                                              *
.comment *  Incorporated final review comments/edits.                     *
.comment *  Split up SCREEN function and statement.                       *
.comment ******************************************************************
.comment *  6/12/90 stevesau                                              *
.comment *  Incorporated RonS comments.                                   *
.comment ******************************************************************
.comment *  5/11/90 stevesau                                              *
.comment *  Replaced Attributes and Colors node with COLOR example        *
.comment *  showing color codes.                                          *
.comment *  Combined GET/PUT.                                             *
.comment *  Incorporated review comments.                                 *
.comment *  Completed second pass.                                        *
.comment ******************************************************************
.comment *  5/10/90 stevesau                                              *
.comment *  Reinserted X command in DRAW.                                 *
.comment *  Added Attributes and Colors node.                             *
.comment ******************************************************************
.comment *  5/4/90 stevesau                                               *
.comment *  Combined SCREEN function and statement (from Dev I/O family). *
.comment *  Created new Screen Modes topic.                               *
.comment ******************************************************************
.comment *  4/23/90 stevesau                                              *
.comment *  Added action lines.						  *
.comment *  Made COLOR Attributes link local.                             *
.comment *  Deleted references to X command in DRAW.                      *
.comment *  Added DRAW macro language screens, made links local.          *
.comment *  Added DRAW - Differences from BASICA.                         *
.comment ******************************************************************
.context CIRCLE
.context @CIRCLE
:nCIRCLE Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Desenha um crculo ou elipse na tela.

\bCIRCLE [STEP] (x!,y!),radius![,[color%] [,[start!] [,[end!] [,aspect!]]]]\p

     \bSTEP\p       Especifica que as coordenadas sao relativas  posiao
                 atual do cursor no grfico.
     \b(x!,y!)\p    As coordenadas para o centro do crculo ou elipse.
     \bradius!\p    O raio do crculo ou elipse em unidades do sistema atual
                 de coordenadas, determinado pelas instruoes SCREEN, VIEW e
                 WINDOW mais recentes.
     \bcolor%\p     Um atributo de cor que define a cor do crculo. Os
                 atributos de cor disponveis dependem de seu adaptador grfico
                 e o modo exibiao??? definido pela instruao SCREEN mais recente.
     \bstart!\p     O ngulo inicial para o arco, em radianos.
     \bend!\p       O ngulo final para o arco, em radianos.
     \baspect!\p    A razao entre o comprimento do eixo y e o comprimento do
                 eixo x, utilizado para desenhar elipses.

     Para converter graus em radianos, multiplique os graus por (PI / 180).

Example:
    'This example requires a color graphics adapter.
    SCREEN 2
    CIRCLE (320, 100), 200
    CIRCLE STEP (0,0), 100

See Also    \i\p\aCOLOR\v@COLOR\v\i\p    \i\p\aDRAW\v@DRAW\v\i\p    \i\p\aLINE\v@LINE\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aVIEW\v@VIEW\v\i\p    \i\p\aWINDOW\v@WINDOW\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context COLOR
.context @COLOR
:nCOLOR Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Define as cores de exibiao da tela.

\bCOLOR [foreground%] [,[background%] [,border%]]\p    Screen mode 0 (text only)
\bCOLOR [background%] [,palette%]\p                    Screen mode 1
\bCOLOR [foreground%]\p                                Screen modes 4, 12, 13
\bCOLOR [foreground%] [,background&]\p                 Screen modes 7-10

     \bforeground%\p    Um nmero que define a cor de primeiro plano da tela.
      \bforeground&\p    No modo de tela 0, foreground%  um atributo de cor que
                     define a cor do texto. Em outros modos de tela, foreground%
                      um atributo de cor ou valor de cor de 4 bits (apenas no modo
                     de tela?? 4) que define a cor do texto e do desenho de linha.
     \bbackground%\p    Um nmero que define a cor de segundo plano da tela. No
      \bbackground&\p    modo de tela 0, background%  um atributo de cor. No
                     modo de tela 1, background%  um valor de cor de 4 bits. Nos
                     modos de tela 7 a 10, background&  um valor de cor.
     \bborder%\p        Um atributo de cor que define a cor da borda da tela.
     \bpalette%\p       Um nmero (0 ou 1) que especifica qual dos dois conjuntos
                     de atributos de cores que ser utilizado:

                     palette%    Atributo 1     Atributo  2    Atributo 3
                                 
                     0           Verde          Vermelha       Marrom
                     1           Ciano          Magenta        Branca clara

     Os valores e atributos de cores disponveis dependem de seu adaptador
      grfico e o modo de tela definido pela instruao SCREEN mais recente.
     Se o seu sistema estiver equipado com um adaptador EGA, VGA ou MCGA,
      utilize a instruao PALETTE para modificar as designaoes de cor dos
      atributos de cores.

Example:
    'This example requires a color graphics adapter.
    SCREEN 7
    FOR i% = 0 TO 15
        COLOR i%
        PRINT i%
    NEXT i%

See Also    \i\p\aDRAW\v@DRAW\v\i\p    \i\p\aPAINT\v@PAINT\v\i\p    \i\p\aPALETTE, PALETTE USING\v@PALETTE\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context @color.table
:nColor Attributes and Values
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

             \bColor monitor                      Monochrome monitor\p
                 
\bColor        Default          Displayed         Default       Displayed\p
\battribute    color value\p(a)\b   color             color value   color\p

\bSCREEN Modes 0, 7, 8, 9\p(b)\b, 12, and 13\p
0            0                Preta             0(c)          Desativada
1            1                Azul                            Sublinhado(d)
2            2                Verde             1(c)          Ativada(d)
3            3                Ciano             1(c)          Ativada(d)
4            4                Vermelha          1(c)          Ativada(d)
5            5                Magenta           1(c)          Ativada(d)
6            6                Marrom            1(c)          Ativada(d)
7            7                Branca            1(c)          Ativada(d)
8            8                Cinza             0(c)          Desativada
9            9                Azul Claro                      Alta intensidade
                                                              Sublinhado
10           10               Verde Claro       2(c)          Alta intensidade
11           11               Ciano Claro       2(c)          Alta intensidade
12           12               Vermelha Clara    2(c)          Alta intensidade
13           13               Magenta Clara     2(c)          Alta intensidade
14           14               Amarela           2(c)          Alta intensidade
15           15               Branca de alta    0(c)          Desativada
                              intensidade

\bSCREEN Modes 1 and 9\p(e)

0            0                Preta             0             Desativada
1            11               Ciano Claro       2             Alta intensidade
2            13               Magenta Clara     2             Alta intensidade
3            15               Branca de alta    0             Branco acinzentado???
                              intensidade

\bSCREEN Modes 2 and 11\p
0            0                Preta            0             Desativada
1            15               Branca de alta   0             Branco acinzentado??
                              intensidade

  (a)  nmeros de cores EGA. VGA e MCGA utilizam valores de cor de exibiao
       que produzem cores visualmente equivalentes.
  (b)  Para VGA ou EGA com memria de vdeo > 64K.
  (c)  Somente para o modo 0.
  (d)  Desligado quando utilizado para segundo plano.
  (e)  EGA com memria de vdeo <= 64K.

See Also    \i\p\aCOLOR\v@COLOR\v\i\p    \i\p\aPALETTE, PALETTE USING\v@PALETTE\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p
            \i\p\aScreen Modes\v@screen.modes\v\i\p
.context DRAW
.context @DRAW
:nDRAW Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Desenha um objeto.

\bDRAW commandstring$\p

     \bcommandstring$\p    Uma expressao de seqncia que contm um ou mais
                        dos seguintes comandos DRAW.

      Comandos de desenho de linha e movimentaao do cursor:
        D[n%]            Move o cursor para baixo n% unidades.
        E[n%]            Move o cursor para cima e para a direita n% unidades.
        F[n%]            Move o cursor para baixo e para a direita n% unidades.
        G[n%]            Move o cursor para baixo e para a esquerda n% unidades.
        H[n%]            Move o cursor para cima e para a esquerda n% unidades.
        L[n%]            Move o cursor para a esquerda n% unidades.
        M[{+|-}]x%,y%    Move o cursor para o ponto x%,y%. Se x% for precedido
                         por + ou -, move em relaao ao ponto atual.
        R[n%]            Move o cursor para a direita n% unidades.
        U[n%]            Move o cursor para cima n% unidades.
        [B]              Um prefixo opcional que movimenta o cursor sem desenhar.
        [N]              Um prefixo opcional que desenha e retorna o cursor para
                         a sua posiao original.

      Comandos de cor, rotaao e escala:
        An%              Rotaciona um objeto n% * 90 graus (n% pode ser 0, 1,
                         2 ou 3).
        Cn%              Define a cor para o desenho (n%  o atributo da cor).
        Pn1%,n2%         Define a cor de preenchimento e das bordas de um objeto
                         (n1%  o atributo da cor de preenchimento, n2%  o
                         atributo da cor das bordas).
        Sn%              Determina a escala do desenho definindo o comprimento
                         de uma unidade de movimentaao do cursor. O n% padrao
                          4, o que  equivalente a 1 pixel.
        TAn%             Rotaciona??Movimenta?? um ngulo n% graus (-360 a 360).

     Se voc omitir n% dos comandos de desenho de linha e movimentaao do
      cursor, o cursor ser movido 1 unidade.
     Para executar uma sub-seqncia do comando DRAW, de uma seqncia do
      comando DRAW, utilize o comando "X":

      DRAW "X"+ VARPTR$(seqncia do comando$)

Example:
    'This example requires a color graphics adapter.
    SCREEN 1
    Triangle$ = "F60 L120 E60"
    DRAW "C2 X" + VARPTR$(Triangle$)
    DRAW "BD30 P1,2 C3 M-30,-30"

See Also    \i\p\aPALETTE, PALETTE USING\v@PALETTE\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aVARPTR$\v@VARPTR$\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aDifferences from BASICA\v@basica.diffs\v\i\p
.context .ggx
.context @ggx
.context .pgfx
.context @pgfx
:nGET, PUT Statements (Graphics)
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

GET captura uma imagem grfica da tela. PUT exibe a imagem capturada por GET.

\bGET [STEP](x1!,y1!)-[STEP](x2!,y2!), arrayname[(index%)]\p
\bPUT [STEP] (x1!,y1!), arrayname[(index%)] [,actionverb]\p

     \bSTEP\p          Especifica que as coordenadas sao relativas  posiao
                    atual do cursor no grfico.
     \b(x1!,y1!)\p     As coordenadas no canto superior esquerdo da imagem
                    capturada por GET ou no local da tela onde PUT exibe a imagem.
     \b(x2!,y2!)\p     As coordenadas do canto inferior direito da imagem capturada.
     \barrayname\p     O nome da matriz onde a imagem est armazenada.
                    See \i\p\aScreen Image Arrays and Compatibility\v@ggx.arrays\v\i\p to determine
                    the required size of the array.
     \bindex%\p        O ndice da matriz na qual inicia o armazenamento da imagem.???
     \bactionverb\p    Uma palavra chave indicando como a imagem ser exibida:

              Palavra Chave    Aao
                        
                    AND        Mescla a imagem armazenada com uma imagem existente.
                    OR         Sobrepoe a imagem armazenada sobre a imagem existente.??
                    PSET       Desenha a imagem armazenada, apagando a imagem existente.
                    PRESET     Desenha a imagem armazenada utilizando cores em reverso,
                               apagando a imagem existente.
                    XOR        Desenha uma imagem armazenada ou apaga uma imagem
                               pr-desenhada enquanto preserva o desenho de segundo
                               plano,?? produzindo efeitos de animaao.

     Uma instruao PUT deve sempre ser executada no mesmo modo de tela que a
      instruao GET utilizada para capturar a imagem, ou num modo compatvel.
      See \i\p\aScreen Image Arrays and Compatibility\v@ggx.arrays\v\i\p.

Example:
    'This example requires a color graphics adapter.
    SCREEN 1
    DIM Box%(1 TO 200)
    x1% = 0: x2% = 10: y1% = 0: y2% = 10
    LINE (x1%, y1%)-(x2%, y2%), 2, BF
    GET (x1%, y1%)-(x2%, y2%), Box%
    DO
        PUT (x1%, y1%), Box%, XOR
        x1% = RND * 300
        y1% = RND * 180
        PUT (x1%, y1%), Box%
    LOOP WHILE INKEY$ = ""

See Also    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context @ggx.arrays
:nScreen Image Arrays and Compatibility
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Utilize bits-por-pixel-por-plano e valores de plano para determinar o tamanho
requerido da matriz que armazena uma imagem grfica da tela. Bits-por-pixel-por
-plano e valores de plano, juntamente com a resoluao horizontal, tambm
determinam quais modos de tela sao compatveis:

                                                                 Resoluao
                                    Bits-por-pixel-              horizontal
    Modo de tela                    por-plano          Planos    (em pixels)
                
    1                               2                  1         320
    2, 4, 11                        1                  1         640
    3                               1                  1         720
    7                               1                  4         320
    8, 9(> memria de vdeo de 64K), 12    1                  4         640
    9(memria de vdeo de 64K), 10         1                  2         640
    13                              8                  1         320

A seguinte frmula fornece o tamanho requerido, em bytes, de uma matriz
utilizada para armazenar uma imagem capturada:

size% = 4 + INT(((PMAP (x2!, 0) - PMAP (x1!, 0) + 1) *
        (bits-por-pixel-por-plano%) + 7) / 8) * planos% *
        (PMAP (y2!, 1) - PMAP (y1!, 1) + 1)

As operaoes GET e PUT sao compatveis nos modos de tela com a mesma
resoluao horizontal e bits-por-pixel-por-plano e valores de plano. Por
exemplo, os modos de tela 2, 4 e 11 sao compatveis, e os modos de tela
8 e 12 sao compatveis.

See Also    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context LINE
.context @LINE
:nLINE Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Desenha uma linha ou retngulo na tela.

\bLINE [[STEP](x1!,y1!)]-[STEP](x2!,y2!) [,[color%] [,[B | BF] [,style%]]]\p

     \bSTEP\p          Especifica que as coordenadas sao relativas  posiao
                    atual do cursor no grfico.??
     \b(x1!,y1!)\p,    As coordenadas de tela do incio da linha e do final
      \b(x2!,y2!)\p     da linha.
     \bcolor%\p        Um atributo de cor que define a cor da linha ou
                    retngulo. Os atributos de cores disponveis dependem
                    de seu adaptador grfico e o modo de tela definido pela
                    instruao SCREEN mais recente.
     \bB\p             Desenha um retngulo ao invs de uma linha.
     \bBF\p            Desenha uma caixa slida.
     \bstyle%\p        Um valor de 16 bits cujos bits especificam se os pixels
                    sao desenhados ou nao. Utilize para desenhar linhas tracejadas
                    ou pontilhadas.

Example:
    'This example requires a color graphics adapter.
    SCREEN 1
    LINE (110, 70)-(190, 120), , B
    LINE (0, 0)-(320, 200), 3, , &HFF00

See Also    \i\p\aCIRCLE\v@CIRCLE\v\i\p    \i\p\aINPUT, LINE INPUT\v@INPUT\v\i\p    \i\p\aPRESET, PSET\v@PSET\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context PAINT
.context @PAINT
:nPAINT Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Preenche uma rea grfica com uma determinada cor ou padrao.??????

\bPAINT [STEP] (x!,y!)[,[{color% | tile$}] [,[bordercolor%] [,background$]]]\p

     \bSTEP\p            Especifica que as coordenadas sao relativas  posiao
                      atual do cursor no grfico.???
     \b(x!,y!)\p         As coordenadas de tela onde a pintura inicia.
     \bcolor%\p          Um atributo de cor que define a cor de preenchimento.
     \btile$\p           Um padrao de preenchimento com 8 bits de largura e
                      at 64 bytes de comprimento, definido como:

                        tile$ = CHR$(arg1) + CHR$(arg2) + ... + CHR$(argn%)

                      Os argumentos para CHR$ sao nmeros entre 0 e 255.
                      Cada CHR$(argn%) define uma fatia de 1-byte, 8-pixels
                      do padrao, baseado no formato binrio do nmero.
     \bbordercolor%\p    Um atributo de cor que especifica a cor da borda da
                      rea preenchida. PAINT encerra o preenchimento da rea
                      quando encontrar a borda da cor especificada.
     \bbackground$\p     Uma fatia de 1-byte, 8-pixels do tipo lado-a-lado de
                      segundo plano. A especificaao de uma fatia lado-a-lado de
                      segundo plano possibilita pintar sobre uma rea j pintada.

     Os atributos de cores disponveis dependem de seu adaptador grfico e do
      modo de tela definido pela instruao SCREEN mais recente.

Example:
    'This example requires a color graphics adapter.
    SCREEN 1
    CIRCLE (106, 100), 75, 1
    LINE (138, 35)-(288, 165), 1, B
    PAINT (160, 100), 2, 1

See Also    \i\p\aASC, CHR$\v@CHR$\v\i\p    \i\p\aCIRCLE\v@CIRCLE\v\i\p    \i\p\aDRAW\v@DRAW\v\i\p    \i\p\aLINE\v@LINE\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context PALETTE
.context @PALETTE
:nPALETTE, PALETTE USING Statements
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Modifique as designaoes de cores dos atributos de cores no modo de tela atual.
PALETTE e PALETTE USING funcionam somente em sistemas equipados com adaptadores
EGA, VGA ou MCGA.

\bPALETTE [attribute%,color&]\p
\bPALETTE USING arrayname#[(index%)]\p

     \battribute%\p    O atributo de cor a ser modificado.
     \bcolor&\p        Um valor de cor a ser designado a um atributo.
     \barrayname#\p    Uma matriz de valores de cores a ser designada ao conjunto
                     de atributos do modo de tela atual. A matriz deve ser
                     suficientemente grande para designar cores a todos os atributos.
     \bindex%\p        O ndice do primeiro elemento da matriz a ser designado a
                     um atributo.

     Os atributos de corees e valores disponveis dependem de seu adaptador grfico
      e do modo de tela definido pela instruao SCREEN mais recente.

Example:
    'This example requires a color graphics adapter.
    PALETTE 0, 1
    SCREEN 1
    FOR i% = 0 TO 3: a%(i%) = i%: NEXT i%
    LINE (138, 35)-(288, 165), 3, BF
    LINE (20, 10)-(160, 100), 2, BF
    DO
        FOR i% = 0 TO 3
            a%(i%) = (a%(i%) + 1) MOD 16
        NEXT i%
        PALETTE USING a%(0)
    LOOP WHILE INKEY$ = ""

See Also    \i\p\aCOLOR\v@COLOR\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context PCOPY
.context @PCOPY
:nPCOPY Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Copia uma pgina de memria de vdeo??? para outra.

\bPCOPY sourcepage%,destinationpage%\p

     \bsourcepage%\p         O nmero da pgina de memria de vdeo a ser copiada.
     \bdestinationpage%\p    O nmero da pgina de memria de vdeo para onde copiar.

     O valor que indentifica a pgina de vdeo  determinado pelo tamanho
      da memria de vdeo e o modo de tela atual.

Example:
    PCOPY 1, 3

See Also    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context SCREEN
.context @SCREEN
:nSCREEN Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Define o modo de tela e outras caractersticas da tela.

\bSCREEN mode% [,[colorswitch%] [,[activepage%] [,visualpage%]]]\p

     \bmode%\p           Define o modo de tela. See \i\p\aScreen Modes\v@screen.modes\v\i\p.
     \bcolorswitch%\p    Um valor (0 ou 1) que alterna entre a exibiao
                      monocromtica e colorida (somente os modos 0 e 1):

                      Modo    Valor       Aao
                              
                      0       0           Desativa cores
                      0       Nao zero    Ativa cores
                      1       0           Ativa cores
                      1       Nao zero    Desativa cores

     \bactivepage%\p     A pgina de tela na qual a sada de grfico ou texto ser gravada.
     \bvisualpage%\p     A pgina de tela atualmente exibida na tela.

Example:
    'This example requires a color graphics adapter.
    SCREEN 1        '320 x 200 graphics
    LINE (110, 70)-(190, 120), , B
    LINE (0, 0)-(320, 200), 3, , &HFF00

See Also    \i\p\aCIRCLE\v@CIRCLE\v\i\p    \i\p\aCOLOR\v@COLOR\v\i\p    \i\p\aDRAW\v@DRAW\v\i\p    \i\p\aLINE\v@LINE\v\i\p      \i\p\aPAINT\v@PAINT\v\i\p
            \i\p\aSCREEN Function\v@screenf\v\i\p      \i\p\aVIEW\v@VIEW\v\i\p    \i\p\aWINDOW\v@WINDOW\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
.context @screen.modes
:nScreen Modes
  \i\p\aContents\vhelpTableId\v\i\p  \i\p\aIndex\vhelpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

A seguinte tabela apresenta um resumo dos modos de tela:???

Adaptadores MDPA, CGA, Hercules, Olivetti, EGA, VGA ou MCGA
SCREEN 0: Somente modo texto
     Formato de texto 40 x 25, 40 x 43, 40 x 50, 80 x 25, 80 x 43 ou 80 x 50,
      caixa de caractere 8 x 8 (8 x 14, 9 x 14 ou 9 x 16 com EGA ou VGA)
     16 cores designadas a qualquer um dos 16 atributos (com CGA ou EGA)
     64 cores designadas a qualquer um dos 16 atributos (com EGA ou VGA)
     Dependendo da resoluao do texto e do adaptador, 8 pginas de memria de
      vdeo (0-7), 4 pginas (0-3), 2 pginas (0-1) ou 1 pgina (0)

Adaptadores CGA, EGA, VGA ou MCGA
SCREEN 1: grfico??? 320 x 200
     formato de texto 40 x 25, caixa de caractere 8 x 8
     16 cores de segundo plano e um de dois conjuntos de 3 cores de segundo
      plano designados com a instruao COLOR com CGA
     16 cores designadas a 4 atributos com EGA ou VGA
     1 pgina de memria de vdeo (0)
SCREEN 2: grfico 640 x 200
     formato de texto 80 x 25, caixa de caractere 8 x 8
     16 cores designadas a 2 atributos com EGA ou VGA
     1 pgina de memria de vdeo (0)

Adaptadores Hercules, Olivetti ou AT&T
SCREEN 3: Adaptador Hercules requerido, somente monitor monocromtico
     grfico 720 x 348
     formato de texto 80 x 25, caixa de caractere 9 x 14
     Normalmente 2 pginas de memria de vdeo (0-1); 1 pgina (0) se for
      instalado um adaptador de exibiao?? colorido secundrio
     A instruao PALETTE nao  suportada
     Ativa?? o controlador MSHERC.COM da Hercules antes de utilizar o modo de tela 3
SCREEN 4:
     Suporta os modelos M24, M240, M28, M280, M380, M380/C e M380/T da Olivetti
      Personal Computers e AT&T Personal Computers 6300 series
     grfico 640 x 400
     formato de texto 80 x 25, caixa de caractere 8 x 16
     1 de 16 cores designadas como cor de primeiro plano (selecionada pela
      instruao COLOR); o segundo plano est fixado na cor preta
     1 pgina de memria de vdeo (0)
     a instruao PALETTE nao  suportada

Adaptadores EGA ou VGA
SCREEN 7: grfico 320 x 200
     formato de texto 40 x 25, caixa de caractere 8 x 8
     Designaao de 16 cores a qualquer um de 16 atributos
     Se for um adaptador EGA com 64K de memria, 2 pginas de memria de vdeo
      (0-1); caso contrrio, 8 pginas (0-7)
SCREEN 8: grfico 640 x 200
     formato de texto 80 x 25, caixa de caractere 8 x 8
     Designaao de 16 cores a qualquer um de 16 atributos
     Se for um adaptador EGA com 64K de memria, 1 pgina de memria de vdeo
      (0); caso contrrio, 4 pginas (0-3)
SCREEN 9: grfico 640 x 350
     formato de texto 80 x 25 ou 80 x 43, caixa de caractere 8 x 14 ou 8 x 8
     16 cores designadas a 4 atributos (adaptador com de 64K de memria), ou
      64 cores designadas a 16 atributos (adaptador com mais que 64K)
     Se for um adaptador EGA com 64K de memria, 1 pgina de memria de vdeo (0);
      caso contrrio, 2 pginas (0-1)

Adaptadores EGA ou VGA, Somente Monitor Monocromtico
SCREEN 10: grfico 640 x 350, somente monitor monocromtico
     formato de texto 80 x 25 ou 80 x 43, caixa de caractere 8 x 14 ou 8 x 8
     At 9 pseudocores designadas a 4 atributos
     2 pginas de memria de vdeo (0-1), adaptador com memria de 256K exigido

Adaptadores VGA ou MCGA
Screen 11 (VGA ou MCGA)
     grfico 640 x 480
     formato de texto 80 x 30 ou 80 x 60, caixa de caractere 8 x 16 ou 8 x 8
     Designaao de at 256K cores a 2 atributos
     1 pgina de memria de vdeo (0)
Screen 12 (VGA)
     Ggrfico 640 x 480
     Fformato de texto 80 x 30 ou 80 x 60, caixa de caractere 8 x 16 ou 8 x 8
     Designaao de at 256K cores a 16 atributos
     1 pgina de memria de vdeo (0)
Screen 13 (VGA ou MCGA)
     Ggrfico 320 x 200
     Formato de texto 40 x 25, caixa de caractere 8 x 8
     Designaao de at 256K cores a 256 atributos
     1 pgina de memria de vdeo (0)

See Also    \i\p\aSCREEN Statement\v@SCREEN\v\i\p
.context @screenf
:nSCREEN Function
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Fornece??? o valor ASCII ou atributo de cor de um caractere numa posiao
especificada na tela.??????

\bSCREEN (row%,column% [,colorflag%])\p

     \brow%\p          A coordenada de linha de um caractere.
     \bcolumn%\p       A coordenada de coluna de um caractere.
     \bcolorflag%\p    Um valor (0 ou 1) que especifica o que ser fornecido.

                    Valor             Fornecer
                        
                    0 (ou omitido)    O cdigo ASCII do caractere.
                    1                 O atributo de cor do caractere.

Example:
    CLS
    PRINT "Hello"
    PRINT "The ASCII value of character at 1,1 is"; SCREEN(1, 1)

See Also    \i\p\aPOINT\v@POINT\v\i\p    \i\p\aSCREEN Statement\v@SCREEN\v\i\p
            \i\p\aASCII Character Codes\v@ac\v\i\p    \i\p\aColor Attributes and Values\v@color.table\v\i\p
.context VIEW
.context @VIEW
:nVIEW Statement
  \i\p\aContents\v@helpTableId\v\i\p  \i\p\aIndex\v@helpIndexId\v\i\p  \i\p\aBack\v!B\v\i\p

Define o tamanho e o local de uma porta de visualizaao onde os grficos podem
ser exibidos na tela.

\bVIEW [[SCREEN] (x1!,y1!)-(x2!,y2!) [,[color%] [,border%]]]\p

     \bSCREEN\p                 Especifica que as coordenadas sao relativas 
                             tela ao invs da porta de visualizaao.
     \b(x1!,y1!)-(x2!,y2!)\p    As coordenadas de cantos diagonais opostos
                             da porta de visualizaao.
     \bcolor%\p                 Um atributo de cor que define a cor de
                             preenchimento da porta de visualizaao.
     \bborder%\p                Um atributo de cor que define a cor de borda da
                             porta de visualizaao.

     Se todos os argumentos forem omitidos, a tela inteira ser a porta de visualizaao.
     Os atributos de cor disponveis dependem de seu adaptador grfico e do
      modo de tela definido pela instruao SCREEN mais recente.

Example:
    'This example requires a color graphics adapter.
    SCREEN 1
    VIEW (10, 10)-(300, 180), , 1
    LOCATE 1, 11: PRINT "A big graphics viewport";
    VIEW SCREEN (80, 80)-(200, 125), , 1
    LOCATE 11, 11: PRINT "A small graphics viewport";

See Also    \i\p\aCLS\v@CLS\v\i\p    \i\p\aSCREEN\v@SCREEN\v\i\p    \i\p\aVIEW PRINT\v@vupri\v\i\p    \i\p\aWINDOW\v@WINDOW\v\i\p
            \i\p\aColor Attributes and Values\v@color.table\v\i\p    \i\p\aScreen Modes\v@screen.modes\v\i\p
