-- New audio alarms tables

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = notify, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'notify'
		        AND c.relname in ('audio_files')
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
			   CREATE TABLE audio_files
				(  id SERIAL NOT NULL, 				   
				   file_name varchar(256),
                   data bytea,
				   CONSTRAINT pk_audio_files PRIMARY KEY (id));
				   
				   ALTER TABLE audio_files OWNER TO nms;
								 
					REVOKE ALL ON TABLE audio_files FROM PUBLIC;
					REVOKE ALL ON TABLE audio_files FROM nms;
					GRANT ALL ON TABLE audio_files TO nms;
					GRANT SELECT ON TABLE audio_files TO ndb_readers;
				    GRANT SELECT ON TABLE audio_files TO ndb_writers;
					GRANT ALL ON TABLE audio_files TO PUBLIC;
				    GRANT ALL ON TABLE audio_files TO ndbadm;
					GRANT ALL ON SEQUENCE audio_files_id_seq TO nms;

			END IF;

			SET search_path = flood, pg_catalog;

PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname in ('audio_alarms')
		        AND c.relkind = 'r';

		    IF NOT FOUND THEN
			   CREATE TABLE audio_alarms
				(  id SERIAL NOT NULL,
				   flood_id INTEGER NOT NULL,
				   audio_id INTEGER NOT NULL,
				   severity INTEGER NOT NULL,
				   at TIMESTAMP NOT NULL,
				   CONSTRAINT pk_audio_files PRIMARY KEY (id));
				   ALTER TABLE ONLY audio_alarms
                          ADD CONSTRAINT audio_alarms_flood_id_fkey FOREIGN KEY (flood_id) REFERENCES flood.registry(flood_id) ON DELETE CASCADE;
                  ALTER TABLE ONLY audio_alarms 
                         ADD CONSTRAINT audio_alarms_audio_id_fkey FOREIGN KEY (audio_id) REFERENCES notify.audio_files(id) ON DELETE CASCADE;

				   ALTER TABLE audio_alarms OWNER TO nms;

					REVOKE ALL ON TABLE audio_alarms FROM PUBLIC;
					REVOKE ALL ON TABLE audio_alarms FROM nms;
					GRANT ALL ON TABLE audio_alarms TO nms;
					GRANT SELECT ON TABLE audio_alarms TO ndb_readers;
				    GRANT SELECT ON TABLE audio_alarms TO ndb_writers;
					GRANT ALL ON TABLE audio_alarms TO PUBLIC;
				    GRANT ALL ON TABLE audio_alarms TO ndbadm;
					GRANT ALL ON SEQUENCE audio_alarms_id_seq TO nms;

			END IF;

        		
		END;
$$;  
